/*
 * Decompiled with CFR 0.152.
 */
package oroma.website;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import oroma.db.ProgPreferences;
import oroma.db.Website;
import oroma.gui.Main;
import swing.ColorButton;

public class WebColorsPanel
extends JPanel {
    private GridLayout jColorsPanelGridLayout = null;
    private Color iImgBackColor = null;
    private Color iImgTextColor = null;
    private Color iHeaderBackColor = null;
    private Color iHeaderTextColor = null;
    private Color iImgBorderColor = null;
    private Color iNewWebPicColor = null;
    private ColorButton jImageBackButton = null;
    private ColorButton jImgTextButton = null;
    private ColorButton jHeaderBackButton = null;
    private ColorButton jHeaderTextButton = null;
    private ColorButton jImgBorderButton = null;
    private ColorButton jNewWebPicButton = null;

    public WebColorsPanel() {
        this.initialize();
    }

    public void fill(Website site) {
        site.def().setImgBackColor(this.iImgBackColor);
        site.def().setImgTextColor(this.iImgTextColor);
        site.def().setImgBorderColor(this.iImgBorderColor);
        site.def().setHeaderBackColor(this.iHeaderBackColor);
        site.def().setHeaderTextColor(this.iHeaderTextColor);
        site.def().setNewWebPicColor(this.iNewWebPicColor);
    }

    public void put(Website site) {
        this.iImgBackColor = site.def().imgBackColor();
        this.iImgTextColor = site.def().imgTextColor();
        this.iImgBorderColor = site.def().imgBorderColor();
        this.iHeaderBackColor = site.def().headerBackColor();
        this.iHeaderTextColor = site.def().headerTextColor();
        this.iNewWebPicColor = site.def().newWebPicColor();
    }

    public Color getImgBackColor() {
        return this.iImgBackColor;
    }

    public void setImgBackColor(Color color) {
        this.iImgBackColor = color;
    }

    public Color getImgTextColor() {
        return this.iImgTextColor;
    }

    public void setImgTextColor(Color color) {
        this.iImgTextColor = color;
    }

    public Color getImgBorderColor() {
        return this.iImgBorderColor;
    }

    public void setImgBorderColor(Color color) {
        this.iImgBorderColor = color;
    }

    public Color getHeaderBackColor() {
        return this.iHeaderBackColor;
    }

    public void setHeaderBackColor(Color color) {
        this.iHeaderBackColor = color;
    }

    public Color getHeaderTextColor() {
        return this.iHeaderTextColor;
    }

    public void setHeaderTextColor(Color headerTextColor) {
        this.iHeaderTextColor = headerTextColor;
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.getImgBackButton().setEnabled(enable);
        this.getImgTextButton().setEnabled(enable);
        this.getHeaderBackButton().setEnabled(enable);
        this.getHeaderTextButton().setEnabled(enable);
        this.getImgBorderButton().setEnabled(enable);
        this.getNewWebPicButton().setEnabled(enable);
    }

    private GridLayout getColorsPanelGridLayout() {
        this.jColorsPanelGridLayout = new GridLayout(0, 1);
        return this.jColorsPanelGridLayout;
    }

    private ColorButton getImgBackButton() {
        if (this.jImageBackButton == null) {
            this.jImageBackButton = new ColorButton();
            this.jImageBackButton.setText("Image background color");
            this.jImageBackButton.setShowBorder(true);
        }
        return this.jImageBackButton;
    }

    private ColorButton getHeaderBackButton() {
        if (this.jHeaderBackButton == null) {
            this.jHeaderBackButton = new ColorButton();
            this.jHeaderBackButton.setText("Header background color");
            this.jHeaderBackButton.setShowBorder(true);
        }
        return this.jHeaderBackButton;
    }

    private ColorButton getImgTextButton() {
        if (this.jImgTextButton == null) {
            this.jImgTextButton = new ColorButton();
            this.jImgTextButton.setText("Image text color");
            this.jImgTextButton.setShowBorder(true);
        }
        return this.jImgTextButton;
    }

    private ColorButton getHeaderTextButton() {
        if (this.jHeaderTextButton == null) {
            this.jHeaderTextButton = new ColorButton();
            this.jHeaderTextButton.setText("Header text color");
            this.jHeaderTextButton.setShowBorder(true);
        }
        return this.jHeaderTextButton;
    }

    private ColorButton getImgBorderButton() {
        if (this.jImgBorderButton == null) {
            this.jImgBorderButton = new ColorButton();
            this.jImgBorderButton.setText("Image border color");
            this.jImgBorderButton.setShowBorder(true);
        }
        return this.jImgBorderButton;
    }

    private ColorButton getNewWebPicButton() {
        if (this.jNewWebPicButton == null) {
            this.jNewWebPicButton = new ColorButton();
            this.jNewWebPicButton.setText("New Web photo color");
            this.jNewWebPicButton.setShowBorder(true);
        }
        return this.jNewWebPicButton;
    }

    private void initialize() {
        this.setBackground(ProgPreferences.singleton().dialogColor());
        this.setLayout(this.getColorsPanelGridLayout());
        this.add(this.getHeaderBackButton());
        this.add(this.getHeaderTextButton());
        this.add(this.getImgBackButton());
        this.add(this.getImgTextButton());
        this.add(this.getImgBorderButton());
        this.add(this.getNewWebPicButton());
        ActionHandler handler = new ActionHandler();
        this.getImgBackButton().addActionListener(handler);
        this.getImgTextButton().addActionListener(handler);
        this.getHeaderBackButton().addActionListener(handler);
        this.getHeaderTextButton().addActionListener(handler);
        this.getImgBorderButton().addActionListener(handler);
        this.getNewWebPicButton().addActionListener(handler);
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == WebColorsPanel.this.getImgBackButton()) {
                this.doImgBack();
            } else if (event.getSource() == WebColorsPanel.this.getImgTextButton()) {
                this.doPicText();
            } else if (event.getSource() == WebColorsPanel.this.getHeaderTextButton()) {
                this.doHeaderText();
            } else if (event.getSource() == WebColorsPanel.this.getHeaderBackButton()) {
                this.doHeaderBack();
            } else if (event.getSource() == WebColorsPanel.this.getImgBorderButton()) {
                this.doImgBorderColor();
            } else {
                this.doNewWebPicColor();
            }
        }

        private void doHeaderText() {
            Color text = JColorChooser.showDialog(Main.singleton(), "Header text color", WebColorsPanel.this.iHeaderTextColor);
            if (text != null) {
                WebColorsPanel.this.iHeaderTextColor = text;
            }
        }

        private void doImgBack() {
            Color back = JColorChooser.showDialog(Main.singleton(), "Table background color", WebColorsPanel.this.iImgBackColor);
            if (back != null) {
                WebColorsPanel.this.iImgBackColor = back;
            }
        }

        private void doPicText() {
            Color text = JColorChooser.showDialog(Main.singleton(), "Image text color", WebColorsPanel.this.iImgTextColor);
            if (text != null) {
                WebColorsPanel.this.iImgTextColor = text;
            }
        }

        private void doHeaderBack() {
            Color back = JColorChooser.showDialog(Main.singleton(), "Header background color", WebColorsPanel.this.iHeaderBackColor);
            if (back != null) {
                WebColorsPanel.this.iHeaderBackColor = back;
            }
        }

        private void doImgBorderColor() {
            Color back = JColorChooser.showDialog(Main.singleton(), "Image border color", WebColorsPanel.this.iImgBorderColor);
            if (back != null) {
                WebColorsPanel.this.iImgBorderColor = back;
            }
        }

        private void doNewWebPicColor() {
            Color newWeb = JColorChooser.showDialog(Main.singleton(), "New Web photo color", WebColorsPanel.this.iNewWebPicColor);
            if (newWeb != null) {
                WebColorsPanel.this.iNewWebPicColor = newWeb;
            }
        }
    }
}

