/*
 * Decompiled with CFR 0.152.
 */
package oroma.website;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import mlib.MString;
import utilt.Utility;

public class SubPageTemplate
implements Cloneable {
    private LinkedList<MString> iLines = new LinkedList();
    public static final String FIELDPREFIX = "$$";
    private static final int LINESPERFIELD = 4;

    public static SubPageTemplate read(String path) throws Exception {
        SubPageTemplate temp = new SubPageTemplate();
        LinkedList<String> lines = Utility.readTextFile(path);
        for (String line : lines) {
            String work = line.trim();
            if (work.startsWith("<!--")) continue;
            temp.iLines.add(new MString(line));
        }
        return temp;
    }

    public void write(String path) throws IOException {
        PrintWriter out = new PrintWriter(new FileWriter(path));
        for (MString line : this.iLines) {
            out.println(line);
        }
        out.close();
    }

    public Object clone() {
        SubPageTemplate copy = null;
        try {
            copy = (SubPageTemplate)super.clone();
            copy.iLines = new LinkedList();
            for (MString line : this.iLines) {
                copy.iLines.add((MString)line.clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return copy;
    }

    public void replace(String token, String value) {
        for (MString line : this.iLines) {
            line.replace(token, value);
        }
    }

    public void removeFields(List<String> fieldNames) throws Exception {
        ListIterator<String> nameIter = fieldNames.listIterator();
        while (nameIter.hasNext()) {
            String name = nameIter.next();
            ListIterator<MString> linesIter = this.iLines.listIterator();
            while (linesIter.hasNext()) {
                MString line = (MString)linesIter.next();
                if (line.indexOf("<td") < 0 || line.indexOf(FIELDPREFIX + name) < 0) continue;
                linesIter = SubPageTemplate.removeField(linesIter);
            }
        }
    }

    public void removeEmptyFields() {
        ListIterator<MString> iter = this.iLines.listIterator();
        while (iter.hasNext()) {
            MString line = (MString)iter.next();
            if (line.indexOf("<td") < 0 || line.indexOf(FIELDPREFIX) < 0) continue;
            iter = SubPageTemplate.removeField(iter);
        }
    }

    public boolean hasField(String name) {
        boolean found = false;
        name = FIELDPREFIX + name.toLowerCase();
        ListIterator iter = this.iLines.listIterator();
        while (!found && iter.hasNext()) {
            MString line = (MString)iter.next();
            boolean bl = found = line.indexOf("<td") >= 0 && line.indexOf(name) >= 0;
        }
        return found;
    }

    public int numFields() {
        int num = 0;
        ListIterator iter = this.iLines.listIterator();
        while (iter.hasNext()) {
            MString line = (MString)iter.next();
            if (line.indexOf(FIELDPREFIX) < 0) continue;
            ++num;
        }
        return num;
    }

    private static ListIterator<MString> removeField(ListIterator<MString> linesIter) {
        linesIter.previous();
        linesIter.previous();
        int i = 0;
        while (i < 4) {
            linesIter.remove();
            linesIter.next();
            ++i;
        }
        return linesIter;
    }

    private SubPageTemplate() {
    }
}

