/*
 * Decompiled with CFR 0.152.
 */
package oroma.website;

import java.awt.Color;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import mlib.MLogger;
import mlib.MLogging;
import mlib.MString;
import oroma.db.Database;
import oroma.db.PersonGroup;
import oroma.db.PicInfo;
import oroma.db.ProgInstallation;
import oroma.db.Website;
import oroma.db.WebsiteDef;
import oroma.website.LinkPanel;
import oroma.website.SubPageTemplate;
import oroma.website.WebImg;
import oroma.website.WebStructFields;
import utilt.Utility;

public class AlbumHtmlPage {
    private Website iSite = null;
    private String iFileName = null;
    public static final String PAGEFIELDPREFIX = "##";
    private static SubPageTemplate SubpageTemplate = null;
    private static final int MAXPERSONS = 15;
    private Collection<String> StartHtml = new LinkedList<String>();
    private Collection<String> EndHtml = new LinkedList<String>();
    private Collection<String> FirstPageHtml = new LinkedList<String>();
    private static LinkedList<String> SubPages = new LinkedList();
    private static final char LINEBREAK = '^';
    private static final String Indent = "\t";
    private static final String[] WIDTHS = new String[]{"100%", "100%", "50%", "33%", "25%", "20%", "17%", "14%", "12%", "11%", "10%"};

    public static LinkedList<String> subPages() {
        return SubPages;
    }

    public static SubPageTemplate template() throws Exception {
        if (SubpageTemplate == null) {
            ProgInstallation install = ProgInstallation.singleton();
            String path = String.valueOf(install.dir()) + "subpage-template.html";
            SubpageTemplate = SubPageTemplate.read(path);
        }
        return (SubPageTemplate)SubpageTemplate.clone();
    }

    private static void writeLinkPanel(MLogging out, LinkPanel panel) {
        out.writeln("<center>");
        Collection<String> links = panel.html();
        for (String link : links) {
            out.writeln(link);
        }
        out.writeln("<br>Page " + (panel.curLink() + 1) + " of " + panel.numLinks());
        out.writeln("</center>");
    }

    private static void removeFields(WebsiteDef def, SubPageTemplate temp) throws Exception {
        String[] websiteFields;
        LinkedList<String> fields = new LinkedList<String>();
        String[] stringArray = PicInfo.COMBOBOXFLDS;
        int n = PicInfo.COMBOBOXFLDS.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            fields.add(name);
            ++n2;
        }
        fields.add("notes");
        fields.add("link");
        fields.add("persons");
        fields.add("date");
        String include = def.photoFields().toLowerCase();
        String[] stringArray2 = websiteFields = Utility.parseDelimStr(include, ",");
        int n3 = websiteFields.length;
        int n4 = 0;
        while (n4 < n3) {
            String name = stringArray2[n4];
            fields.remove(name);
            ++n4;
        }
        temp.removeFields(fields);
    }

    private static String neighborFontSize(String fontSize, int offset) {
        String size = null;
        int i = 0;
        while (size == null && i < WebStructFields.FONTSIZEOPTIONS.length) {
            if (fontSize.equals(WebStructFields.FONTSIZEOPTIONS[i])) {
                int index = i + offset;
                size = index >= 0 && index < WebStructFields.FONTSIZEOPTIONS.length ? WebStructFields.FONTSIZEOPTIONS[index] : WebStructFields.FONTSIZEOPTIONS[i];
            }
            ++i;
        }
        return size;
    }

    private static void writeEmptyRow(MLogging out, String colSpan, boolean line) {
        out.writeln("<tr>");
        String str = "<td " + colSpan + " class=text>";
        if (line) {
            str = String.valueOf(str) + "<hr class=hr>";
        }
        out.writeln(str);
        out.writeln("</td></tr>");
    }

    private void writeFooter(MLogging out, String footer) {
        out.writeln("<center>");
        out.writeln("<p>");
        StringTokenizer tken = new StringTokenizer(footer, "^");
        while (tken.hasMoreTokens()) {
            String line = tken.nextToken();
            if (line.length() <= 0) continue;
            out.writeln(String.valueOf(line) + "<br>");
        }
        Date curDate = new Date();
        out.writeln("Last updated: " + curDate + "<br>");
        String contact = this.site().def().contact();
        if (contact.length() > 0) {
            out.writeln("Contact: " + contact);
        }
        out.writeln("</p>");
        out.writeln("</center>");
    }

    private static String colorToHtml(Color color) {
        String str = "rgb(";
        str = String.valueOf(str) + Integer.toString(color.getRed());
        str = String.valueOf(str) + "," + Integer.toString(color.getGreen());
        str = String.valueOf(str) + "," + Integer.toString(color.getBlue()) + ")";
        return str;
    }

    public AlbumHtmlPage(Website site) {
        this.iSite = site;
    }

    public Website site() {
        return this.iSite;
    }

    public String fileName() {
        return this.iFileName;
    }

    public void write(int startImgPos, int endImgPos, String fileName, LinkPanel panel) throws Exception {
        this.iFileName = fileName;
        String filePath = String.valueOf(this.iSite.path()) + '/' + fileName;
        MLogger.File out = new MLogger.File(filePath, false);
        if (startImgPos == 0) {
            out.writeln("<!-- built by the Bluemont Photo Manager program, www.bluemontsw.com/bpm -->");
        }
        out.writeln("<!DOCTYPE html>");
        out.writeln("<html>");
        this.writeHeader(out);
        this.writeBody(out, startImgPos, endImgPos, panel);
        out.writeln("</html>");
        ((MLogger)out).close();
        this.copyBackground();
    }

    public void writeHeader(MLogging out) {
        out.writeln("<head>");
        String prefix = out.prefix();
        out.setPrefix(String.valueOf(prefix) + Indent);
        WebsiteDef def = this.iSite.def();
        out.writeln("<meta content=\"text/html; charset=ISO-8859-1\" http-equiv=\"content-type\"/>");
        out.writeln("<meta name=\"robots\" content=\"follow, index, max-snippet:-1, max-video-preview:-1, max-image-preview:large\"/>");
        out.writeln("<title>" + def.title() + "</title>");
        String fontStyle = "Arial";
        if (def.fontStyle().equals("Serif")) {
            fontStyle = "Times New Roman";
        }
        String textSize = def.textFontSize();
        String headerSize = def.headerFontSize();
        String subtitleSize = def.subtitleFontSize();
        this.writeStyles(out, fontStyle, textSize, headerSize, subtitleSize);
        out.setPrefix(prefix);
        out.writeln("</head>");
    }

    public void writeBody(MLogging out, int startImgPos, int endImgPos, LinkPanel panel) throws Exception {
        WebsiteDef def;
        if (startImgPos == 0) {
            SubPages.clear();
        }
        if ((def = this.site().def()).backImg().equals("None")) {
            out.writeln("<body class=colors>");
        } else {
            out.writeln("<body background=" + def.backImg() + " class=colors>");
        }
        String colSpan = "colspan=" + Integer.toString(def.numCols());
        boolean wroteCustom = this.writeCustom("start.html", out);
        Color newPicColor = def.newWebPicColor();
        String colorStr = String.format("#%02x%02x%02x", newPicColor.getRed(), newPicColor.getGreen(), newPicColor.getBlue());
        if (!wroteCustom) {
            this.writeTitles(out);
        }
        String prefix1 = out.prefix();
        out.setPrefix(String.valueOf(prefix1) + Indent);
        out.writeln("<table border=0 cellspacing=15 cellpadding=0 class=base>");
        out.writeln("<tbody>");
        String prefix2 = out.prefix();
        out.setPrefix(String.valueOf(prefix2) + Indent);
        Collection<WebImg> imageColl = this.site().imagesByOrderRange(startImgPos, endImgPos);
        Iterator<WebImg> images = imageColl.iterator();
        while (images.hasNext()) {
            LinkedList<WebImg> rowImages = new LinkedList<WebImg>();
            LinkedList<String> rowLabels = new LinkedList<String>();
            int i = 0;
            while (i < def.numCols() && images.hasNext()) {
                WebImg img = images.next();
                rowImages.add(img);
                String label = img.picInfo().webLabel(def.annot(), 64);
                img.setLabel(label);
                MString status = img.picInfo().comboField("status").compareValue();
                if (status.equalsIgnoreCase("new")) {
                    label = "<font color=\"" + colorStr + "\"> " + label + "</font>";
                }
                String imageName = img.filename();
                int index = imageName.indexOf(46);
                String ext = imageName.substring(index);
                String imageDir = this.site().def().imageDir();
                if (imageDir.length() > 0) {
                    imageDir = String.valueOf(imageDir) + "/";
                }
                if (!def.type().equals("Thumbnail and label")) {
                    label = "<a href=\"" + imageDir + imageName + "\">" + label + "</a>";
                    if (def.type().equals("Thumbnail, label, photo, info")) {
                        label = label.replace(ext, ".html");
                    }
                }
                rowLabels.add(label);
                ++i;
            }
            AlbumHtmlPage.writeEmptyRow(out, colSpan, def.isRowLines());
            this.writeLabelRow(out, rowLabels);
            this.writeImageRow(out, rowImages);
        }
        AlbumHtmlPage.writeEmptyRow(out, colSpan, def.isRowLines());
        out.setPrefix(prefix2);
        out.writeln("</tbody>");
        out.writeln("</table>");
        if (panel != null && panel.numLinks() > 1) {
            AlbumHtmlPage.writeLinkPanel(out, panel);
        }
        if (startImgPos == 0 && this.site().isSurvey()) {
            this.writeCustom("survey" + File.separator + "survey.html", out);
        }
        this.writeCustom("end.html", out);
        if (startImgPos == 0) {
            this.writeCustom("firstend.html", out);
        }
        out.writeln("</body>");
        this.writeFooter(out, def.footer());
    }

    public void writeTitles(MLogging out) {
        WebsiteDef def = this.site().def();
        out.writeln("<center>");
        if (def.title().length() > 0) {
            out.writeln("<h1 class=h1>" + def.title() + "</h1>");
        }
        if (def.subTitle().length() > 0) {
            out.writeln("<h2 class=h2>" + def.subTitle() + "</h2>");
        }
        out.writeln("</center>");
    }

    private void copyBackground() throws Exception {
        if (!this.iSite.def().backImg().equals("None")) {
            String filename = this.iSite.def().backImg();
            String from = String.valueOf(Database.singleton().parms().bpmPath().path()) + "bgnds" + '/' + filename;
            String to = String.valueOf(this.iSite.path()) + '/' + filename;
            Utility.copyFile(from, to);
        }
    }

    private void writeStyles(MLogging out, String fontStyle, String textSize, String headerSize, String subtitleSize) {
        WebsiteDef def = this.iSite.def();
        out.writeln("<style>");
        out.writeln("body.colors {color: " + AlbumHtmlPage.colorToHtml(def.imgTextColor()) + "; background-color: " + AlbumHtmlPage.colorToHtml(def.imgBackColor()) + ";}");
        if (def.backImg().equals("None")) {
            out.writeln("h1 {font-family: ; font-style: plain; font-size: " + headerSize + "; text-align: center; background-color: " + AlbumHtmlPage.colorToHtml(def.headerBackColor()) + "; color: " + AlbumHtmlPage.colorToHtml(def.headerTextColor()) + "; margin: 0}");
            out.writeln("h2 {font-family: ; font-style: plain; font-size: " + subtitleSize + "; text-align: center; background-color: " + AlbumHtmlPage.colorToHtml(def.headerBackColor()) + "; color: " + AlbumHtmlPage.colorToHtml(def.headerTextColor()) + "; margin: 0}");
        } else {
            out.writeln("h1 {font-family: " + fontStyle + "; font-style: plain; font-size: " + headerSize + "; text-align: center; color: " + AlbumHtmlPage.colorToHtml(def.headerTextColor()) + "; margin: 0}");
            out.writeln("h2 {font-family: " + fontStyle + "; font-style: plain; font-size: " + subtitleSize + "; text-align: center; color: " + AlbumHtmlPage.colorToHtml(def.headerTextColor()) + "; margin: 0}");
        }
        out.writeln("td.text {font-family: " + fontStyle + "; font-style: plain; font-size: " + textSize + "; text-align: center; color: " + AlbumHtmlPage.colorToHtml(def.imgTextColor()) + ";}");
        out.writeln("table.base {width: 100%; text-align: left; margin-left: auto; margin-right: auto;}");
        out.writeln("img {border: " + Integer.toString(def.imgBorderWidth()) + "px" + " solid " + AlbumHtmlPage.colorToHtml(def.imgBorderColor()) + ";}");
        out.writeln("hr {width: 100%; height: 2px;}");
        out.writeln("</style>");
    }

    private void writeLabelRow(MLogging out, LinkedList<String> labels) {
        WebsiteDef def = this.site().def();
        out.writeln("<tr>");
        String width = WIDTHS[def.numCols()];
        Iterator iter = labels.iterator();
        while (iter.hasNext()) {
            out.writeln("<td width=" + width + "; class=text>");
            String label = (String)iter.next();
            out.writeln(label);
            out.writeln("</td>");
        }
        out.writeln("</tr>");
    }

    private boolean writeCustom(String filename, MLogging out) throws Exception {
        boolean wrote = false;
        String path = String.valueOf(this.site().path()) + '/' + filename;
        File custom = new File(path);
        boolean exists = custom.exists();
        if (!exists) {
            path = String.valueOf(Database.singleton().webDb().path()) + '/' + filename;
            custom = new File(path);
            exists = custom.exists();
        }
        if (exists) {
            Collection<String> html = null;
            if (filename.equals("start.html")) {
                if (this.StartHtml.size() == 0) {
                    this.StartHtml = Utility.readTextFile(path);
                }
                html = this.StartHtml;
            } else if (filename.equals("end.html")) {
                if (this.EndHtml.size() == 0) {
                    this.EndHtml = Utility.readTextFile(path);
                }
                html = this.EndHtml;
            } else if (filename.equals("firstend.html")) {
                if (this.FirstPageHtml.size() == 0) {
                    this.FirstPageHtml = Utility.readTextFile(path);
                }
                html = this.FirstPageHtml;
            } else {
                html = Utility.readTextFile(path);
            }
            if (html != null && html.size() > 0) {
                out.writeln("<!--start custom html-->");
                for (String line : html) {
                    if (line.length() <= 0) continue;
                    out.writeln(line);
                }
                out.writeln("<!--end custom html-->");
                wrote = true;
            }
        }
        return wrote;
    }

    private void writeImageRow(MLogging out, LinkedList<WebImg> images) throws Exception {
        WebsiteDef def = this.site().def();
        out.writeln("<tr>");
        Iterator iter = images.iterator();
        while (iter.hasNext()) {
            out.writeln("<td style=\"vertical-align: " + def.imgAlign() + ";\" class=text>");
            WebImg img = (WebImg)iter.next();
            String imageName = img.filename();
            String imageDir = this.site().def().imageDir();
            if (imageDir.length() > 0) {
                imageDir = String.valueOf(imageDir) + "/";
            }
            String str = "<a";
            if (def.type().equals("Thumbnail and label")) {
                PicInfo info = img.picInfo();
                MString film = info.comboField("film type").webLabelValue();
                if (film.length() > 0) {
                    str = String.valueOf(str) + " title=\"" + film.toString() + " film\"" + " ";
                }
            } else if (def.type().equals("Thumbnail, label, photo")) {
                str = String.valueOf(str) + " title=\"click to enlarge\" ";
                str = String.valueOf(str) + " href=\"" + imageDir + imageName + "\"";
            } else if (def.type().equals("Thumbnail, label, photo, info")) {
                str = String.valueOf(str) + " title=\"click to enlarge\" ";
                String subPage = this.buildSubPage(def, img);
                SubPages.add(subPage);
                str = String.valueOf(str) + " href=\"" + imageDir + subPage + "\"";
            }
            str = String.valueOf(str) + ">";
            str = String.valueOf(str) + "<img class=\"img\" + alt=\"" + imageName + "\" src=\"" + imageDir + img.thumbFilename() + "\"></a>";
            out.writeln(str);
            out.writeln("</td>");
        }
        out.writeln("</tr>");
    }

    private String buildSubPage(WebsiteDef def, WebImg img) throws Exception {
        boolean useBack = !def.backImg().equals("None");
        SubPageTemplate temp = AlbumHtmlPage.template();
        if (useBack) {
            temp.replace("##background", "background=" + def.backImg());
        } else {
            temp.replace("##background", "");
        }
        AlbumHtmlPage.removeFields(def, temp);
        String fontFamily = "Arial";
        if (def.fontStyle().equals("Serif")) {
            fontFamily = "Times New Roman";
        }
        String page = "<a href=" + this.fileName() + ">Page</a>";
        temp.replace("##page", page);
        temp.replace("##fontfamily", fontFamily);
        temp.replace("##textfontsize", def.textFontSize());
        String fontSize = AlbumHtmlPage.neighborFontSize(def.textFontSize(), 1);
        temp.replace("##headerfontsize", fontSize);
        String name = img.picInfo().id() + ".jpg";
        temp.replace("##file", name);
        PicInfo info = img.picInfo();
        if (img.isPortrait()) {
            temp.replace("##width", "45");
        } else {
            temp.replace("##width", "73");
        }
        temp.replace("##title", def.title());
        PicInfo.ComboField[] fields = info.comboFields();
        int pos = PicInfo.comboFieldPos("town");
        MString town = fields[pos].compareValue();
        pos = PicInfo.comboFieldPos("region");
        MString region = fields[pos].compareValue();
        temp.replace("##desc", town + "," + region);
        int i = 0;
        while (i < PicInfo.COMBOBOXFLDS.length) {
            MString value = fields[i].webDisplayValue();
            if (value.length() > 0) {
                String fieldTemplate = "$$" + fields[i].name();
                temp.replace(fieldTemplate, value.toString());
            }
            ++i;
        }
        MString work = new MString(info.notes()).trimWhitespace();
        int index = work.indexOf('#');
        if (index == 0) {
            work.clear();
        } else if (index >= 1) {
            work = work.substring(0, index - 1);
        }
        if (work.length() > 0) {
            temp.replace("$$notes", work.toString());
        }
        if ((index = (work = new MString(info.link()).trimWhitespace()).indexOf('#')) == 0) {
            work.clear();
        } else if (index >= 1) {
            work = work.substring(0, index - 1);
        }
        MString link = new MString("<a href=\"" + work + "\"> More information </a>");
        if (work.length() > 0) {
            temp.replace("$$link", link.toString());
        }
        if ((work = new MString(info.dateStr()).trimWhitespace()).length() > 0) {
            temp.replace("$$date", work.toString());
        }
        Iterator persons = info.persons().iterator();
        int count = 1;
        while (persons.hasNext() && count <= 15) {
            PersonGroup person = (PersonGroup)persons.next();
            if (person.getName().length() <= 0) continue;
            String num = Integer.toString(count);
            if (num.length() == 1) {
                num = "0" + num;
            }
            String token = "$$person" + num;
            if (person.getName().charAt(0) == '#' || (work = new MString(person.getName()).trimWhitespace()).length() <= 0) continue;
            temp.replace(token, work.toString());
            ++count;
        }
        temp.removeEmptyFields();
        index = name.lastIndexOf(46);
        name = String.valueOf(name.substring(0, index)) + ".html";
        String path = String.valueOf(this.site().imagePath()) + '/' + name;
        temp.write(path);
        return name;
    }
}

