/*
 * Decompiled with CFR 0.152.
 */
package oroma.slideshow;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.Timer;
import mlib.MAppMsg;
import oroma.albumgui.AlbumBar;
import oroma.albumgui.ImagePanel;
import oroma.albumgui.PicDisplay;
import oroma.albumgui.PicInfoSummary;
import oroma.albumgui.PicturePanel;
import oroma.albumgui.ThumbnailPanel;
import oroma.db.Database;
import oroma.db.PicInfo;
import oroma.db.ProgPreferences;
import oroma.db.Query;
import oroma.gui.BpmMsgs;
import oroma.picinfogui.PicInfoPanel;
import oroma.slideshow.ControlListener;
import oroma.slideshow.ControlPanel;
import swing.ColorPanel;
import swing.Selector;
import swing.StatusBox;
import utilt.ImageIOUtil;
import utilt.Utility;

public class SlideshowPanel
extends ColorPanel {
    private ControlPanel jControlPanel = null;
    private ImagePanel jImagePanel = null;
    private Query iAlbum = null;
    private double iX = 0.0;
    private double iY = 0.0;
    private Image iImage = null;
    private Timer iTimer = null;
    private PicInfo[] iPics = null;
    private int iPicIndex = 0;
    private int iInterval = 5;
    private int iTimerCount = 0;
    private int iNextPicEnd = 0;
    private boolean iPaused = false;
    private boolean iTagsOn = false;
    private static final int SECTOMS = 1000;

    public SlideshowPanel() {
        this.setLayout(new BorderLayout());
        ColorPanel panel = new ColorPanel();
        panel.setLayout(new GridLayout(2, 1));
        panel.add(PicInfoSummary.singleton());
        panel.add(this.getControlPanel());
        this.add((Component)panel, "South");
        this.add((Component)this.getImagePanel(), "Center");
        this.getControlPanel().addButtonListener(new ControlHandler());
        this.iInterval = ProgPreferences.singleton().slideInterval();
        this.jControlPanel.putInterval(String.valueOf(this.iInterval) + " sec");
    }

    public void doShow(Query album) {
        this.iAlbum = album;
        PicturePanel.singleton().clear();
        PicInfoPanel.singleton().setPicInfo(new PicInfo());
        PicInfoPanel.singleton().setEnabled(false);
        ThumbnailPanel.singleton().clearSelectedItems();
        TreeSet<PicInfo> infos = Database.singleton().selectPicInfos(this.iAlbum);
        this.jControlPanel.putNumPics(infos.size());
        this.iPics = infos.toArray(new PicInfo[0]);
        this.iPicIndex = 0;
        MAppMsg msg = BpmMsgs.get("slideshow_started");
        StatusBox.singleton().showMsg(msg.format(), msg.isError());
        this.iNextPicEnd = 0;
        this.iTimer = new Timer(1000, new TimerHandler());
        this.iTimer.setRepeats(true);
        this.iTimer.start();
    }

    public void stopShow() {
        this.iTimer.stop();
        PicturePanel.singleton().clear();
        MAppMsg msg = BpmMsgs.get("slideshow_ended");
        StatusBox.singleton().showMsg(msg.format(), msg.isError());
        AlbumBar.singleton().enableSlideshow(true);
        this.jControlPanel.enable(false);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        PicDisplay picDisp = PicturePanel.singleton().picDisplay();
        try {
            if (picDisp != null) {
                if (this.iImage == null) {
                    this.iImage = picDisp.image();
                }
                double scale = this.calcPos(this.iImage);
                this.jImagePanel.draw(scale, 1.0, this.iX, this.iY, this.iImage.getWidth(null), this.iImage.getHeight(null));
            }
        }
        catch (Exception xcp) {
            MAppMsg msg = BpmMsgs.get("unable_display_photo");
            StatusBox.singleton().queueShowMsg(msg.format(picDisp.info().picPathname()), msg.isError());
        }
    }

    private ControlPanel getControlPanel() {
        if (this.jControlPanel == null) {
            this.jControlPanel = new ControlPanel();
        }
        return this.jControlPanel;
    }

    private ImagePanel getImagePanel() {
        if (this.jImagePanel == null) {
            this.jImagePanel = new ImagePanel();
        }
        return this.jImagePanel;
    }

    private double calcPos(Image image) {
        double factor;
        int margin = ProgPreferences.singleton().imageMargin();
        double panelWidth = this.jImagePanel.getSize().width;
        double panelHeight = this.jImagePanel.getSize().height;
        double imageWidth = image.getWidth(null) + margin;
        double imageHeight = image.getHeight(null) + margin;
        double fitScale = 1.0;
        if (imageHeight > panelHeight) {
            factor = panelHeight / imageHeight;
            imageWidth *= factor;
            fitScale *= factor;
        }
        if (imageWidth > panelWidth) {
            factor = panelWidth / imageWidth;
            fitScale *= factor;
        }
        this.iX = 0.5 * (panelWidth - (double)image.getWidth(null) * fitScale);
        this.iY = 0.5 * (panelHeight - (double)image.getHeight(null) * fitScale);
        return fitScale;
    }

    private class ControlHandler
    implements ControlListener {
        private ControlHandler() {
        }

        @Override
        public void pause(ActionEvent event) {
            SlideshowPanel.this.iPaused = true;
        }

        @Override
        public void resume(ActionEvent event) {
            SlideshowPanel.this.iPaused = false;
        }

        @Override
        public void stop(ActionEvent event) {
            SlideshowPanel.this.stopShow();
        }

        @Override
        public void interval(Selector.Event event) {
            StringTokenizer tken = new StringTokenizer(event.getSelection(), " ");
            SlideshowPanel.this.iInterval = Integer.parseInt(tken.nextToken());
        }

        @Override
        public void nextPic(Selector.Event event) {
            SlideshowPanel.this.iPicIndex = Integer.parseInt(event.getSelection().trim()) - 1;
        }

        @Override
        public void toggleTags(ActionEvent event) {
            SlideshowPanel.this.iTagsOn = !SlideshowPanel.this.iTagsOn;
            SlideshowPanel.this.jImagePanel.setShowTags(SlideshowPanel.this.iTagsOn);
        }
    }

    private class TimerHandler
    implements ActionListener {
        private TimerHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            SlideshowPanel slideshowPanel = SlideshowPanel.this;
            slideshowPanel.iTimerCount = slideshowPanel.iTimerCount + 1;
            if (!SlideshowPanel.this.iPaused && SlideshowPanel.this.iTimerCount >= SlideshowPanel.this.iNextPicEnd) {
                if (SlideshowPanel.this.iPicIndex >= SlideshowPanel.this.iPics.length) {
                    SlideshowPanel.this.stopShow();
                } else {
                    PicInfo info = SlideshowPanel.this.iPics[SlideshowPanel.this.iPicIndex];
                    String pathname = info.picPathname();
                    try {
                        BufferedImage image = ImageIOUtil.load(pathname);
                        SlideshowPanel.this.jControlPanel.putPicNum(SlideshowPanel.this.iPicIndex + 1);
                        if (image != null) {
                            double scale = SlideshowPanel.this.calcPos(image);
                            PicDisplay disp = new PicDisplay(info);
                            PicturePanel.singleton().setPicDisplay(disp);
                            SlideshowPanel.this.jImagePanel.draw(scale, 1.0, SlideshowPanel.this.iX, SlideshowPanel.this.iY, ((Image)image).getWidth(null), ((Image)image).getHeight(null));
                            PicInfoSummary.singleton().put(info);
                        } else {
                            MAppMsg msg = BpmMsgs.get("unable_display_photo");
                            StatusBox.singleton().showMsg(msg.format(info.fileName()), msg.isError());
                        }
                    }
                    catch (Exception xcp) {
                        MAppMsg msg = BpmMsgs.get("unable_display_photo");
                        StatusBox.singleton().showMsg(msg.format(Utility.xcpMsg(xcp)), msg.isError());
                    }
                    SlideshowPanel.this.iNextPicEnd = SlideshowPanel.this.iTimerCount + SlideshowPanel.this.iInterval;
                    SlideshowPanel slideshowPanel2 = SlideshowPanel.this;
                    slideshowPanel2.iPicIndex = slideshowPanel2.iPicIndex + 1;
                }
            }
        }
    }
}

