/*
 * Decompiled with CFR 0.152.
 */
package oroma.slideshow;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import oroma.db.ProgPreferences;
import oroma.gui.Main;
import oroma.slideshow.ControlListener;
import swing.ControlButton;
import swing.PanelLabel;
import swing.Selector;

public class ControlPanel
extends JPanel {
    private JButton jPauseResButton = null;
    private JButton jStopButton = null;
    private Selector jIntervalSelector = null;
    private Selector jPicNumSelector = null;
    private JButton jTagButton = null;
    private PanelLabel jCounter = new PanelLabel();
    private LinkedList<ControlListener> iLis = new LinkedList();
    private boolean iPaused = false;
    private boolean iTagsOn = false;
    private ActionHandler iHandler = new ActionHandler();
    private SelectorHandler iSelHandler = new SelectorHandler();
    private static final String[] INTERVALOPTIONS = new String[]{"1 sec", "2 sec", "3 sec", "4 sec", "5 sec", "7 sec", "10 sec", "15 sec", "30 sec", "60 sec"};

    public ControlPanel() {
        this.add(this.getPauseResButton());
        this.add(this.getStopButton());
        this.add(this.getTagButton());
        this.add(this.getPicNumSelector());
        this.add(this.jCounter);
        PanelLabel label = new PanelLabel("at");
        this.add(label);
        this.add(this.getIntervalSelector());
        Color backColor = ProgPreferences.singleton().headerBackColor();
        this.setBackground(backColor);
        this.jCounter.setBackground(backColor);
        this.getIntervalSelector().setBackground(backColor);
        label.setBackground(backColor);
    }

    public void addButtonListener(ControlListener lis) {
        this.iLis.add(lis);
    }

    public void putNumPics(int num) {
        String[] options = new String[num];
        int i = 0;
        while (i < options.length) {
            options[i] = " " + (i + 1);
            ++i;
        }
        this.getPicNumSelector().setOptions(options);
        this.jCounter.setText("of " + num);
    }

    public void putPicNum(int num) {
        this.getPicNumSelector().setSelection(" " + num, false);
    }

    public void putInterval(String interval) {
        this.jIntervalSelector.setSelection(interval, false);
    }

    @Override
    public void enable(boolean enable) {
        this.getPauseResButton().setEnabled(enable);
        this.getStopButton().setEnabled(enable);
        this.getTagButton().setEnabled(enable);
        this.getPicNumSelector().setEnabled(enable);
        this.getIntervalSelector().setEnabled(enable);
    }

    private JButton getPauseResButton() {
        if (this.jPauseResButton == null) {
            ImageIcon icon = Main.singleton().iconMgr().icon("next");
            this.jPauseResButton = new ControlButton("Pause/resume", icon, 'P');
            this.jPauseResButton.setEnabled(true);
            this.jPauseResButton.addActionListener(this.iHandler);
        }
        return this.jPauseResButton;
    }

    private JButton getStopButton() {
        if (this.jStopButton == null) {
            ImageIcon icon = Main.singleton().iconMgr().icon("stop");
            this.jStopButton = new ControlButton("End", icon, 'E');
            this.jStopButton.setEnabled(true);
            this.jStopButton.addActionListener(this.iHandler);
        }
        return this.jStopButton;
    }

    private Selector getIntervalSelector() {
        if (this.jIntervalSelector == null) {
            this.jIntervalSelector = new Selector(null, INTERVALOPTIONS);
            this.jIntervalSelector.addListener(this.iSelHandler);
            this.jIntervalSelector.setFont(ProgPreferences.singleton().menuFont());
        }
        return this.jIntervalSelector;
    }

    private Selector getPicNumSelector() {
        if (this.jPicNumSelector == null) {
            this.jPicNumSelector = new Selector(null, INTERVALOPTIONS);
            this.jPicNumSelector.addListener(this.iSelHandler);
            this.jPicNumSelector.setFont(ProgPreferences.singleton().menuFont());
        }
        return this.jPicNumSelector;
    }

    private JButton getTagButton() {
        if (this.jTagButton == null) {
            ImageIcon icon = Main.singleton().iconMgr().icon("tagoff");
            this.jTagButton = new ControlButton("Show tags", icon, 't');
            this.jTagButton.setEnabled(true);
            this.jTagButton.addActionListener(this.iHandler);
        }
        return this.jTagButton;
    }

    static /* synthetic */ JButton access$3(ControlPanel controlPanel) {
        return controlPanel.jPauseResButton;
    }

    static /* synthetic */ boolean access$4(ControlPanel controlPanel) {
        return controlPanel.iPaused;
    }

    static /* synthetic */ void access$5(ControlPanel controlPanel, boolean bl) {
        controlPanel.iPaused = bl;
    }

    static /* synthetic */ JButton access$6(ControlPanel controlPanel) {
        return controlPanel.jTagButton;
    }

    static /* synthetic */ boolean access$7(ControlPanel controlPanel) {
        return controlPanel.iTagsOn;
    }

    static /* synthetic */ void access$8(ControlPanel controlPanel, boolean bl) {
        controlPanel.iTagsOn = bl;
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void actionPerformed(ActionEvent event) {
            block9: {
                block8: {
                    iter = ControlPanel.access$0(ControlPanel.this).iterator();
                    if (event.getSource() != ControlPanel.access$3(ControlPanel.this)) break block8;
                    ControlPanel.access$5(ControlPanel.this, ControlPanel.access$4(ControlPanel.this) == false);
                    if (ControlPanel.access$4(ControlPanel.this)) {
                        ControlPanel.access$3(ControlPanel.this).setIcon(Main.singleton().iconMgr().icon("pause"));
                        while (iter.hasNext()) {
                            lis = (ControlListener)iter.next();
                            lis.pause(event);
                        }
                    } else {
                        ControlPanel.access$3(ControlPanel.this).setIcon(Main.singleton().iconMgr().icon("next"));
                        while (iter.hasNext()) {
                            lis = (ControlListener)iter.next();
                            lis.resume(event);
                        }
                    }
                    break block9;
                }
                if (event.getSource() != ControlPanel.access$6(ControlPanel.this)) ** GOTO lbl31
                ControlPanel.access$8(ControlPanel.this, ControlPanel.access$7(ControlPanel.this) == false);
                if (ControlPanel.access$7(ControlPanel.this)) {
                    ControlPanel.access$6(ControlPanel.this).setIcon(Main.singleton().iconMgr().icon("tagon"));
                } else {
                    ControlPanel.access$6(ControlPanel.this).setIcon(Main.singleton().iconMgr().icon("tagoff"));
                }
                while (iter.hasNext()) {
                    lis = (ControlListener)iter.next();
                    lis.toggleTags(event);
                }
                break block9;
lbl-1000:
                // 1 sources

                {
                    lis = (ControlListener)iter.next();
                    lis.stop(event);
lbl31:
                    // 2 sources

                    ** while (iter.hasNext())
                }
            }
        }
    }

    private class SelectorHandler
    implements Selector.Listener {
        private SelectorHandler() {
        }

        @Override
        public synchronized void selected(Selector.Event event) {
            block3: {
                Iterator iter;
                block2: {
                    iter = ControlPanel.this.iLis.iterator();
                    if (event.getSource() != ControlPanel.this.jIntervalSelector) break block2;
                    while (iter.hasNext()) {
                        ControlListener lis = (ControlListener)iter.next();
                        lis.interval(new Selector.Event(this, ControlPanel.this.jIntervalSelector.getSelection(), 0));
                    }
                    break block3;
                }
                if (event.getSource() != ControlPanel.this.jPicNumSelector) break block3;
                while (iter.hasNext()) {
                    ControlListener lis = (ControlListener)iter.next();
                    lis.nextPic(new Selector.Event(this, ControlPanel.this.jPicNumSelector.getSelection(), 0));
                }
            }
        }
    }
}

