/*
 * Decompiled with CFR 0.152.
 */
package oroma.picinfogui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.File;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import oroma.db.ImageFileInfo;
import oroma.db.PicInfo;
import oroma.gui.Main;
import swing.PanelLabel;
import swing.SwingProgram;
import utilt.Utility;

public class ThumbInfoPanel
extends JPanel {
    private InfoPrompts jInfoPrompts = new InfoPrompts();
    private InfoValues jInfoValues = new InfoValues();

    public ThumbInfoPanel() {
        this.setLayout(new BoxLayout(this, 0));
        this.setBackground(SwingProgram.DIALOGBACKCOLOR);
        ImageIcon icon = Main.singleton().iconMgr().icon("info");
        PanelLabel label = new PanelLabel(icon);
        this.add(Box.createHorizontalStrut(10));
        this.add(label);
        this.add(Box.createHorizontalStrut(10));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBackground(SwingProgram.DIALOGBACKCOLOR);
        panel.add((Component)this.jInfoPrompts, "West");
        panel.add((Component)this.jInfoValues, "Center");
        this.add(panel);
    }

    public void setup(PicInfo info) {
        this.jInfoValues.setup(info);
    }

    private class InfoPrompts
    extends JPanel {
        private PanelLabel jFilePath = null;
        private PanelLabel jFileSize = null;
        private PanelLabel jFileDate = null;
        private PanelLabel jImageSize = null;
        private PanelLabel jImageNum = null;

        public InfoPrompts() {
            this.setLayout(new GridLayout(0, 1));
            this.add(this.getFilePath());
            this.add(this.getFileSize());
            this.add(this.getFileDate());
            this.add(this.getImageSize());
            this.add(this.getImageNum());
        }

        private PanelLabel getFilePath() {
            if (this.jFilePath == null) {
                this.jFilePath = new PanelLabel("File path", ':');
            }
            return this.jFilePath;
        }

        private PanelLabel getFileSize() {
            if (this.jFileSize == null) {
                this.jFileSize = new PanelLabel("File size", ':');
            }
            return this.jFileSize;
        }

        private PanelLabel getFileDate() {
            if (this.jFileDate == null) {
                this.jFileDate = new PanelLabel("File date", ':');
            }
            return this.jFileDate;
        }

        private PanelLabel getImageSize() {
            if (this.jImageSize == null) {
                this.jImageSize = new PanelLabel("Image pixels", ':');
            }
            return this.jImageSize;
        }

        private PanelLabel getImageNum() {
            if (this.jImageNum == null) {
                this.jImageNum = new PanelLabel("Image number", ':');
            }
            return this.jImageNum;
        }
    }

    private class InfoValues
    extends JPanel {
        private PanelLabel jFilePath = new PanelLabel();
        private PanelLabel jFileSize = new PanelLabel();
        private PanelLabel jFileDate = new PanelLabel();
        private PanelLabel jImageSize = new PanelLabel();
        private PanelLabel jImageNum = new PanelLabel();

        public InfoValues() {
            this.setLayout(new GridLayout(0, 1));
            this.add(this.jFilePath);
            this.add(this.jFileSize);
            this.add(this.jFileDate);
            this.add(this.jImageSize);
            this.add(this.jImageNum);
        }

        public void setup(PicInfo picInfo) {
            String name = picInfo.picPathname();
            File file = new File(name);
            Date date = new Date(file.lastModified());
            this.jFileDate.setText(Utility.DMY.format(date));
            this.jFilePath.setText(name);
            ImageFileInfo fileInfo = picInfo.getFileInfo();
            this.jFileSize.setText(String.valueOf(Integer.toString(fileInfo.getSizeKB())) + " KB");
            String imgSize = String.valueOf(Integer.toString(fileInfo.getNumCols())) + " X " + Integer.toString(fileInfo.getNumRows());
            this.jImageSize.setText(imgSize);
            this.jImageNum.setText(picInfo.id().toString());
        }
    }
}

