/*
 * Decompiled with CFR 0.152.
 */
package oroma.picinfogui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.SystemColor;
import java.util.Collection;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import mlib.MAppMsg;
import oroma.albumgui.AlbumSelectionBox;
import oroma.db.Database;
import oroma.db.PicInfo;
import oroma.db.ProgPreferences;
import oroma.db.Query;
import oroma.gui.BpmMsgs;
import oroma.picinfogui.ButtonPanel;
import oroma.picinfogui.InfoPanelTop;
import oroma.picinfogui.PersonsPanel;
import swing.PanelLabel;
import swing.StatusBox;
import swing.StdScrollPane;
import utilt.Utility;

public class PicInfoPanel
extends JPanel {
    private PicInfo iPicInfo = null;
    private JPanel jScrollPanel = null;
    private JScrollPane jJScrollPane = null;
    private PanelLabel jPersonsLabel = null;
    private static PicInfo iCopiedInfo = new PicInfo();
    private static PicInfoPanel Singleton = null;

    public static PicInfoPanel singleton() {
        if (Singleton == null) {
            Singleton = new PicInfoPanel();
        }
        return Singleton;
    }

    public void enableEdit(boolean enable) {
        ButtonPanel.singleton().setEnabled(enable);
        this.setEnabled(enable);
    }

    @Override
    public void setEnabled(boolean enable) {
        ButtonPanel.singleton().setEnabled(enable);
        InfoPanelTop.singleton().setEnabled(enable);
        this.getPersonsPanel().setEnabled(enable);
    }

    public void setPicInfo(PicInfo picInfo) {
        this.setEnabled(true);
        this.iPicInfo = picInfo;
        InfoPanelTop.singleton().put(this.iPicInfo);
        this.getPersonsPanel().put(this.iPicInfo);
        this.setEnabled(true);
    }

    private PicInfo buildNewPicInfo() {
        PicInfo info = new PicInfo();
        info.assign(this.iPicInfo);
        InfoPanelTop.singleton().fill(info);
        this.getPersonsPanel().fill(info);
        return info;
    }

    private PicInfoPanel() {
        this.setBackground(ProgPreferences.singleton().dialogColor());
        this.setLayout(new BorderLayout());
        this.setBackground(SystemColor.info);
        this.add((Component)ButtonPanel.singleton(), "North");
        this.add((Component)this.getJScrollPane(), "Center");
        this.setEnabled(false);
        ButtonPanel.singleton().addListener(new ButtonHandler());
        Singleton = this;
    }

    private JPanel getPanelToScroll() {
        if (this.jScrollPanel == null) {
            this.jScrollPanel = new JPanel();
            this.jScrollPanel.setBackground(ProgPreferences.singleton().dialogColor());
            this.jScrollPanel.setLayout(new BoxLayout(this.jScrollPanel, 1));
            this.jScrollPanel.add(InfoPanelTop.singleton());
            this.jScrollPanel.add(this.getPersonsLabel());
            this.jScrollPanel.add(this.getPersonsPanel());
        }
        return this.jScrollPanel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jJScrollPane == null) {
            this.jJScrollPane = new StdScrollPane();
            this.getJScrollPane().setViewportView(this.getPanelToScroll());
        }
        return this.jJScrollPane;
    }

    private PersonsPanel getPersonsPanel() {
        PersonsPanel.singleton().setAlignmentX(0.5f);
        return PersonsPanel.singleton();
    }

    private PanelLabel getPersonsLabel() {
        if (this.jPersonsLabel == null) {
            this.jPersonsLabel = new PanelLabel("Persons", ':');
        }
        return this.jPersonsLabel;
    }

    private class ButtonHandler
    implements ButtonPanel.Listener {
        private ButtonHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updatePic(ButtonPanel.Event event) {
            String msg = InfoPanelTop.singleton().testIfValid();
            if (msg == null) {
                Database db;
                PicInfoPanel.this.iPicInfo.assign(PicInfoPanel.this.buildNewPicInfo());
                Database database = db = Database.singleton();
                synchronized (database) {
                    try {
                        db.putPic(PicInfoPanel.this.iPicInfo, true);
                        MAppMsg appMsg = BpmMsgs.get("updated_photo");
                        StatusBox.singleton().queueShowMsg(appMsg.format(), appMsg.isError());
                    }
                    catch (Exception xcp) {
                        MAppMsg appMsg = BpmMsgs.get("unable_update_photo");
                        StatusBox.singleton().queueShowMsg(appMsg.format(Utility.xcpMsg(xcp)), appMsg.isError());
                    }
                }
            }
            StatusBox.singleton().showMsg(msg, true);
        }

        @Override
        public void updateAlbum(ButtonPanel.Event event) {
            String result = InfoPanelTop.singleton().testIfValid();
            if (result == null) {
                try {
                    PicInfo newPicInfo = PicInfoPanel.this.buildNewPicInfo();
                    Query curAlbum = AlbumSelectionBox.singleton().getCurAlbum();
                    TreeSet<PicInfo> picInfos = Database.singleton().selectPicInfos(curAlbum);
                    PicsUpdater updater = new PicsUpdater(newPicInfo, picInfos);
                    updater.start();
                }
                catch (Exception xcp) {
                    MAppMsg msg = BpmMsgs.get("unable_update_album");
                    StatusBox.singleton().showMsg(msg.format(Utility.xcpMsg(xcp)), msg.isError());
                }
            }
        }

        @Override
        public void cancel(ButtonPanel.Event event) {
            PicInfoPanel.this.setPicInfo(PicInfoPanel.this.iPicInfo);
            MAppMsg msg = BpmMsgs.get("edit_cancelled");
            StatusBox.singleton().showMsg(msg.format(), msg.isError());
        }

        @Override
        public void copy(ButtonPanel.Event event) {
            iCopiedInfo.assign(PicInfoPanel.this.iPicInfo);
            MAppMsg msg = BpmMsgs.get("copied_info");
            StatusBox.singleton().showMsg(msg.format(), msg.isError());
        }

        @Override
        public void paste(ButtonPanel.Event event) {
            PicInfoPanel.this.iPicInfo.assignComboFields(iCopiedInfo);
            PicInfoPanel.this.iPicInfo.assignDate(iCopiedInfo);
            PicInfoPanel.this.setPicInfo(PicInfoPanel.this.iPicInfo);
        }
    }

    private class PicsUpdater
    extends Thread {
        private PicInfo iNewInfo = null;
        private Collection<PicInfo> iInfos = null;

        public PicsUpdater(PicInfo newInfo, Collection<PicInfo> infos) {
            this.iNewInfo = newInfo;
            this.iInfos = infos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Database db;
            Database database = db = Database.singleton();
            synchronized (database) {
                block15: {
                    MAppMsg msg = BpmMsgs.get("updating_photos");
                    StatusBox.singleton().queueShowMsg(msg.format(), msg.isError());
                    PicInfoPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        try {
                            Collection<String> names = PicInfoPanel.this.iPicInfo.diffComboFields(this.iNewInfo);
                            int count = 0;
                            for (PicInfo info : this.iInfos) {
                                boolean updated = info.updateComboFields(names, this.iNewInfo);
                                if (!updated) continue;
                                db.putPic(info, false);
                                ++count;
                            }
                            msg = BpmMsgs.get("updated_photos");
                            String text = Integer.toString(count);
                            StatusBox.singleton().queueShowMsg(msg.format(text), msg.isError());
                        }
                        catch (Exception xcp) {
                            msg = BpmMsgs.get("unable_update_photo");
                            StatusBox.singleton().queueShowMsg(msg.format(Utility.xcpMsg(xcp)), msg.isError());
                            try {
                                db.infosDb().save(false);
                            }
                            catch (Exception xcp2) {
                                msg = BpmMsgs.get("unable_update_photo");
                                StatusBox.singleton().queueShowMsg(msg.format(), msg.isError());
                            }
                            PicInfoPanel.this.setCursor(Cursor.getDefaultCursor());
                            break block15;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            db.infosDb().save(false);
                        }
                        catch (Exception xcp) {
                            msg = BpmMsgs.get("unable_update_photo");
                            StatusBox.singleton().queueShowMsg(msg.format(), msg.isError());
                        }
                        PicInfoPanel.this.setCursor(Cursor.getDefaultCursor());
                        throw throwable;
                    }
                    try {
                        db.infosDb().save(false);
                    }
                    catch (Exception xcp) {
                        msg = BpmMsgs.get("unable_update_photo");
                        StatusBox.singleton().queueShowMsg(msg.format(), msg.isError());
                    }
                    PicInfoPanel.this.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }
}

