/*
 * Decompiled with CFR 0.152.
 */
package oroma.picinfogui;

import java.util.LinkedList;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import mlib.MAppMsg;
import mswing.WheelComboBoxDb;
import oroma.db.Database;
import oroma.db.PersonGroup;
import oroma.db.PicInfo;
import oroma.gui.BpmMsgs;
import oroma.gui.Main;
import swing.WheelComboBox;
import utilt.Utility;

public class PersonsPanel
extends JPanel {
    private WheelComboBox[] iPersons = new WheelComboBox[30];
    public static final int MAXPERSONS = 30;
    private static PersonsPanel Singleton = null;

    public static PersonsPanel singleton() {
        if (Singleton == null) {
            Singleton = new PersonsPanel();
        }
        return Singleton;
    }

    public void fill(PicInfo info) {
        LinkedList<PersonGroup> persons = new LinkedList<PersonGroup>();
        int i = 0;
        while (i < 30) {
            PersonGroup person = new PersonGroup();
            String selection = (String)this.iPersons[i].getSelectedItem();
            if (selection != null) {
                person.setName(selection);
                persons.add(person);
            }
            ++i;
        }
        info.setPersons(persons);
    }

    public void put(PicInfo picInfo) {
        int i = 0;
        while (i < 30) {
            this.iPersons[i].setSelectedItem("");
            ++i;
        }
        LinkedList<PersonGroup> persons = picInfo.persons();
        int person = 0;
        for (PersonGroup pGroup : persons) {
            WheelComboBox box = this.iPersons[person];
            box.addItem(pGroup.getName());
            box.setSelectedItem(pGroup.getName());
            ++person;
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        int i = 0;
        while (i < 30) {
            this.iPersons[i].setEnabled(enabled);
            this.iPersons[i].setEditable(enabled);
            ++i;
        }
    }

    private PersonsPanel() {
        this.setLayout(new BoxLayout(this, 1));
        int i = 0;
        while (i < 30) {
            WheelComboBox box = new WheelComboBox();
            box.setEditable(false);
            try {
                WheelComboBoxDb db = Database.singleton().comboDb("persons");
                box.setDb(db, true);
                this.iPersons[i] = box;
                this.add(this.iPersons[i]);
            }
            catch (Exception xcp) {
                MAppMsg msg = BpmMsgs.get("startup");
                Main.singleton().logger().writeln(msg.format(Utility.xcpMsg(xcp)));
            }
            ++i;
        }
    }
}

