/*
 * Decompiled with CFR 0.152.
 */
package oroma.gui;

import clp.Clp;
import cmdproc.BpmClp;
import files.FileInfo;
import files.Filesystem;
import help.HelpTree;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.util.LinkedList;
import misc.SampleAlbum;
import mlib.MAppMsg;
import mlib.MLogger;
import oroma.albumgui.AlbumFiller;
import oroma.albumgui.AlbumPanel;
import oroma.albumgui.PictureAdder;
import oroma.albumgui.PicturePanel;
import oroma.albumsgui.AlbumPopupObject;
import oroma.albumsgui.AlbumsPanel;
import oroma.albumsgui.CategorySelectionBox;
import oroma.albumsgui.DbInfoLabel;
import oroma.db.Database;
import oroma.db.PicInfo;
import oroma.db.ProgInstallation;
import oroma.db.ProgPreferences;
import oroma.db.Query;
import oroma.db.StructureUpdates;
import oroma.gui.BpmMsgs;
import oroma.gui.MainPanel;
import swing.DatePanel;
import swing.EntryField;
import swing.SplashScreen;
import swing.StatusBox;
import swing.VersionedProgram;
import utilt.Utility;

public class Main
extends VersionedProgram {
    private Clp iClp = null;
    private boolean iDbExists = false;
    private boolean iDidInstall = false;
    public static final String PROGNAME = "Bluemont Photo Manager";
    public static final String ALBUMFIELDSFILE = "album-fields.txt";
    private static final String VERSION = "14-Jan-2026";
    private static final String WEBSITEURL = "http://www.bluemontsw.com/bpm/";
    private static final String PROGTITLE = "Bluemont Photo Manager version 14-Jan-2026";
    private static final String EXTERNDBARG = "extdb";
    private static final String ACTIVEFILE = "active";
    private static SplashScreen Splash = null;
    private static Main Singleton = null;
    public static HelpTree TheHelpTree = null;

    public static Main singleton() {
        return Singleton;
    }

    private static void checkRunning(ProgInstallation install) {
        File active = new File(String.valueOf(install.dir()) + ACTIVEFILE);
        if (active.exists()) {
            System.out.println("BPM already running");
            System.exit(1);
        } else {
            try {
                active.createNewFile();
            }
            catch (Exception xcp) {
                System.out.println(xcp);
            }
        }
    }

    private static void backupInstallFile(ProgInstallation install) {
        try {
            String fromPath = String.valueOf(System.getProperty("user.home")) + File.separator + ProgInstallation.REGISTERFILEPATH;
            String toPath = String.valueOf(install.dir()) + "ief17qtz.ovl";
            Utility.copyFile(fromPath, toPath);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        block5: {
            Singleton = new Main();
            try {
                ProgInstallation install = ProgInstallation.read();
                if (install == null) {
                    ProgInstallation.create();
                    install = ProgInstallation.singleton();
                    install.write();
                }
                Main.checkRunning(install);
                Singleton.setLogger(install.fileLogger());
                MAppMsg msg = BpmMsgs.get("startup");
                Singleton.logger().writeln(msg.format(install.toString()), msg.isError());
                if (Singleton.parseArgs(args)) {
                    Singleton.startup();
                } else {
                    msg = BpmMsgs.get("startup");
                    Singleton.logger().writeln(msg.format("invalid startup arguments"), msg.isError());
                }
            }
            catch (Exception xcp) {
                MAppMsg msg = BpmMsgs.get("startup");
                Singleton.logger().writeln(msg.format(Utility.xcpMsg(xcp)), msg.isError());
                if (Splash == null) break block5;
                Splash.dispose();
            }
        }
    }

    public void showAlbum(Query query) {
        AlbumFiller.halt();
        AlbumPanel panel = AlbumPanel.singleton();
        panel.clear();
        panel.addAlbumSelection(query.name());
        AlbumFiller.startNew(query);
    }

    public Clp clp() {
        return this.iClp;
    }

    private Main() {
        super(PROGTITLE);
        this.setTitle(PROGNAME);
        this.addWindowListener(new WindowHandler());
        this.setExtendedState(6);
        try {
            this.progArgs().addArg(EXTERNDBARG, "External database to use", null, false, 2, 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setIconImage(this.iconMgr().icon("bpm").getImage());
        Runtime.getRuntime().addShutdownHook(new Shutdown());
    }

    private void startup() throws Exception {
        this.iClp = new BpmClp(new BpmClp.State(), false);
        this.iClp.setLogger(new MLogger.File("clplog.txt", false));
        URL url = Main.class.getResource("splash.gif");
        Splash = new SplashScreen(url);
        Splash.splash();
        this.doDb();
        ProgInstallation install = ProgInstallation.singleton();
        ProgPreferences pref = ProgPreferences.read(install);
        this.setup(pref, install);
        this.startGui(pref);
    }

    private void startGui(ProgPreferences pref) throws Exception {
        pref.setEntryHilightColor(pref.entryBackColor());
        this.setupGui(pref);
        TheHelpTree = HelpTree.readZip(new File("help.dat"));
        StatusBox.singleton().setLogger(this.logger());
        DatePanel.putBackColorAll(pref.dialogColor());
        EntryField.putBackColorAll(pref.dialogColor());
        MainPanel panel = MainPanel.singleton();
        this.getContentPane().add((Component)panel, "Center");
        this.setIconImage(this.iconMgr().icon("bpm").getImage());
        AlbumsPanel.singleton().setup();
        AlbumPopupObject.setup();
        String javaVer = System.getProperty("java.version");
        StatusBox.singleton().queueShowMsg("Java version " + javaVer, false);
        StatusBox.singleton().queueShowMsg(PROGTITLE, false);
        Splash.dispose();
        this.setVisible(true);
        PicturePanel.singleton().requestFocus();
        DbInfoLabel.singleton().show();
        CategorySelectionBox.singleton().setBackground(pref.headerBackColor());
        CategorySelectionBox.singleton().setFont(pref.menuFont());
        CategorySelectionBox.singleton().addItem("*");
        CategorySelectionBox.singleton().setSelectedItem("*");
        if (this.iDidInstall) {
            Query sample = Database.singleton().query("Sample Album", true);
            Main.singleton().showAlbum(sample);
        } else {
            this.checkVersion();
        }
    }

    private void doDb() throws Exception {
        Filesystem.Local fs = new Filesystem.Local(ProgInstallation.singleton().dir(), true);
        FileInfo.Local bpmDir = new FileInfo.Local((Filesystem)fs, "");
        Database.Parms parms = new Database.Parms(bpmDir, null);
        this.iDbExists = Database.exists(bpmDir);
        if (this.iDbExists) {
            if (Singleton.progArgs().argSupplied(EXTERNDBARG)) {
                String path = this.progArgs().argValue(EXTERNDBARG, 0);
                fs = new Filesystem.Local(path, true);
                FileInfo.Local extDir = new FileInfo.Local((Filesystem)fs, "");
                path = this.progArgs().argValue(EXTERNDBARG, 1);
                path = path.replace('\\', '/');
                fs = new Filesystem.Local(path, true);
                FileInfo.Local local = new FileInfo.Local((Filesystem)fs, "");
                parms = new Database.Parms(extDir, local);
                MAppMsg msg = BpmMsgs.get("startup");
                this.logger().writeln(msg.format("Using external " + parms.toString()));
                msg = BpmMsgs.get(EXTERNDBARG);
                StatusBox.singleton().queueShowMsg(msg.format(extDir.path()), false);
            }
            Database.open(parms, true, this.logger());
            LinkedList<Object> cats = CategorySelectionBox.singleton().items();
            LinkedList<String> strs = new LinkedList<String>();
            for (Object e : cats) {
                strs.add((String)e);
            }
            Database.singleton().checkCategories(strs);
        } else {
            this.iDidInstall = true;
            MAppMsg msg = BpmMsgs.get("startup");
            this.logger().writeln(msg.format("Doing installation..."));
            Database.create(parms, this.logger());
            msg = BpmMsgs.get("startup");
            this.logger().writeln(msg.format("Created database"));
            SampleAlbum.create();
            msg = BpmMsgs.get("startup");
            this.logger().writeln(msg.format("Create sample album"));
            Database.open(parms, true, this.logger());
            this.iDbExists = true;
        }
    }

    private void setup(ProgPreferences pref, ProgInstallation install) throws Exception {
        String dirPath = install.dir();
        LinkedList<String> fieldNames = Utility.readTextFile(String.valueOf(dirPath) + File.separator + ALBUMFIELDSFILE);
        for (String name : fieldNames) {
            if (name.length() <= 0 || name.startsWith("//")) continue;
            int pos = PicInfo.comboFieldPos(name);
            if (pos < 0) {
                this.logger().writeln("Photo field not found: " + name, true);
                continue;
            }
            pref.dispFields().addLast(name);
        }
        StructureUpdates.addFilmFormatField();
        StructureUpdates.changeToWheelPanels();
    }

    private void cleanup() {
        try {
            this.iClp.state().removeParm("result");
            Clp.DynamicCmd dynamCmd = new Clp.DynamicCmd(this.clp(), "clean combo boxes");
            dynamCmd.addArg("clean", null, false);
            dynamCmd.addArg("comboboxes", null, false);
            dynamCmd.execute();
        }
        catch (Exception xcp) {
            this.logger().writeln("Cleanup error: " + xcp, true);
        }
    }

    private void checkVersion() {
        try {
            boolean avail = this.newVersionAvail(WEBSITEURL, VERSION);
            if (avail) {
                MAppMsg msg = BpmMsgs.get("update-available");
                StatusBox.singleton().showMsg(msg.format(), msg.isError());
            }
        }
        catch (Exception xcp) {
            MAppMsg msg = BpmMsgs.get("unable-read-version");
            this.logger().writeln(msg.format(Utility.xcpMsg(xcp)));
        }
    }

    private class Shutdown
    extends Thread {
        private Shutdown() {
        }

        @Override
        public void run() {
            block8: {
                try {
                    try {
                        ProgInstallation install = ProgInstallation.singleton();
                        if (!Main.this.iDbExists) {
                            ProgInstallation.singleton().delete();
                            break block8;
                        }
                        install.incCounter();
                        install.write();
                        Main.this.cleanup();
                        Database.singleton().shutdown();
                        Main.backupInstallFile(install);
                    }
                    catch (Exception xcp) {
                        MAppMsg msg = BpmMsgs.get("shutdown-error");
                        Main.this.logger().writeln(msg.format(Utility.xcpMsg(xcp)));
                        ProgInstallation install = ProgInstallation.singleton();
                        if (install != null) {
                            Main.this.logger().close();
                            File active = new File(String.valueOf(install.dir()) + Main.ACTIVEFILE);
                            active.delete();
                        }
                    }
                }
                finally {
                    ProgInstallation install = ProgInstallation.singleton();
                    if (install != null) {
                        Main.this.logger().close();
                        File active = new File(String.valueOf(install.dir()) + Main.ACTIVEFILE);
                        active.delete();
                    }
                }
            }
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            AlbumFiller.halt();
            PictureAdder.halt();
            Main.this.setCursor(Cursor.getPredefinedCursor(3));
            System.exit(0);
        }

        @Override
        public void windowOpened(WindowEvent event) {
            AlbumPanel.singleton().setupSizes();
            Singleton.requestFocus();
        }
    }
}

