/*
 * Decompiled with CFR 0.152.
 */
package oroma.db;

import bpv.AlbumGroup;
import files.FtpServer;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.TreeSet;
import mlib.MAppMsg;
import mlib.MLogging;
import mlib.MString;
import oroma.db.Database;
import oroma.db.PicInfo;
import oroma.db.ProgInstallation;
import oroma.db.Query;
import oroma.db.WebsiteDef;
import oroma.gui.BpmMsgs;
import oroma.website.AlbumHtmlPage;
import oroma.website.LinkPanel;
import oroma.website.WebDefDialog;
import oroma.website.WebImg;
import oroma.website.WebMgr;
import swing.StatusBox;
import utilt.ImageIOUtil;
import utilt.Utility;

public class Website
implements Cloneable,
Serializable {
    private WebsiteDef iDef = new WebsiteDef();
    private Date iLastBuild = null;
    private Date iLastUpload = null;
    private String iLastCopyright = "";
    private AlbumGroup iAlbumGroup = null;
    private TreeMap<PicInfo, WebImg> iImgs = new TreeMap(new PicInfo.ImageComparator());
    private transient TreeMap<PicInfo, WebImg> iOrderedImgs = null;
    private transient Date iPrevBuild = null;
    public static final String HTML = ".html";
    public static final String HOMEPAGE = "bpm.html";
    public static final int MAXNOTESLABELCHARS = 64;
    public static final String DELIM = "/";
    public static final String DEFAULTPAGE = "index.html";
    public static final String STARTHTML = "start.html";
    public static final String ENDHTML = "end.html";
    public static final String FIRSTENDHTML = "firstend.html";
    public static final String SURVEYDIR = "survey";
    public static final String SURVEYHTML = "survey.html";
    public static final String UPLOADFILEPREFIX = "bpm-";
    public static final char SPECIALCHAR1 = '#';
    public static final char SPECIALCHAR2 = '^';
    private static final float IMGUPLOADPERCENT = 75.0f;
    private static final String DEFAULTPAGE_TEMPLATE = "index-template.html";
    private static final String MSGPREFIX = "Web: ";
    static final long serialVersionUID = -3700958939276593396L;

    public Website(WebsiteDef def) {
        this.iDef = def;
    }

    public Website(String albumName) throws Exception {
        this.iDef.init(albumName);
    }

    public Object clone() {
        Website clone = null;
        try {
            TreeMap imgs;
            clone = (Website)super.clone();
            clone.iDef = (WebsiteDef)this.iDef.clone();
            clone.iImgs = imgs = (TreeMap)this.iImgs.clone();
            if (clone.iLastBuild != null) {
                clone.iLastBuild = (Date)this.iLastBuild.clone();
            }
            if (clone.iLastUpload != null) {
                clone.iLastUpload = (Date)this.iLastUpload.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public WebsiteDef def() {
        return this.iDef;
    }

    public AlbumGroup albumGroup() {
        return this.iAlbumGroup;
    }

    public String path() {
        String path = Database.singleton().webDb().path();
        path = String.valueOf(path) + '/' + Integer.toString(this.iDef.albumNum());
        path = path.replace('\\', '/');
        return path;
    }

    public String imagePath() {
        String path = this.path();
        String imageDirName = this.iDef.imageDir();
        if (imageDirName.length() > 0) {
            imageDirName = String.valueOf('/') + imageDirName;
        }
        path = String.valueOf(path) + imageDirName;
        return path;
    }

    public Date lastBuild() {
        return this.iLastBuild;
    }

    public Date prevBuild() {
        return this.iPrevBuild;
    }

    public void setLastBuild(Date date) {
        this.iPrevBuild = this.iLastBuild;
        this.iLastBuild = date;
    }

    public Date lastUpload() {
        return this.iLastUpload;
    }

    public void setLastUpload(Date date) {
        this.iLastUpload = date;
    }

    public int numImgs() {
        return this.iImgs.size();
    }

    public Collection<WebImg> webImgs() {
        return this.iImgs.values();
    }

    public void clear() {
        this.iLastBuild = null;
        this.iLastUpload = null;
        this.iPrevBuild = null;
        this.iImgs.clear();
    }

    public boolean isSurvey() {
        File file = new File(String.valueOf(this.path()) + File.separator + SURVEYDIR);
        return file.exists();
    }

    public Collection<WebImg> imagesByOrderRange(int startPos, int endPos) {
        WebImg[] images = new WebImg[this.iOrderedImgs.size()];
        Collection<WebImg> webImgs = this.iOrderedImgs.values();
        int i = 0;
        Iterator<WebImg> iterator = webImgs.iterator();
        while (iterator.hasNext()) {
            WebImg img;
            images[i] = img = iterator.next();
            ++i;
        }
        LinkedList<WebImg> range = new LinkedList<WebImg>();
        if (endPos >= images.length) {
            endPos = images.length - 1;
        }
        int j = startPos;
        while (j <= endPos) {
            range.add(images[j]);
            ++j;
        }
        return range;
    }

    public String firstImageFilename() {
        String name = null;
        Iterator<WebImg> images = this.iImgs.values().iterator();
        if (images.hasNext()) {
            WebImg img = images.next();
            name = img.filename();
        }
        return name;
    }

    public void build(Date curDate, MLogging logger) throws Exception {
        String include;
        boolean completed = false;
        if (this.def().type().equals("Thumbnail, label, photo, info") && (include = this.def().photoFields()).length() == 0) {
            MAppMsg msg = BpmMsgs.get("website_nofields");
            Utility.throwError(msg.format());
        }
        this.removePageHtml();
        MAppMsg msg = BpmMsgs.get("building_website");
        StatusBox.singleton().queueShowMsg(msg.format(this.def().albumName()), msg.isError());
        EventQueue.invokeAndWait(new PcUpdater(0));
        completed = this.buildImgs(logger);
        int imgsPerPage = this.iDef.numCols() * this.iDef.numRows();
        int numLoops = this.iImgs.size() / imgsPerPage;
        if (this.iImgs.size() % imgsPerPage > 0) {
            ++numLoops;
        }
        LinkPanel panel = new LinkPanel(numLoops);
        int startPos = 0;
        int endPos = startPos + imgsPerPage - 1;
        int i = 0;
        while (i < numLoops) {
            panel.setCurLink(i);
            AlbumHtmlPage page = new AlbumHtmlPage(this);
            if (startPos == 0) {
                page.write(startPos, endPos, HOMEPAGE, panel);
            } else {
                page.write(startPos, endPos, panel.linkPageName(i), panel);
            }
            startPos += imgsPerPage;
            endPos += imgsPerPage;
            ++i;
        }
        this.setupPrevNextLinks();
        if (this.def().type().equals("Thumbnail and label")) {
            this.removePicHtml();
        }
        this.writeBpvFile();
        EventQueue.invokeAndWait(new PcUpdater(100));
        if (completed) {
            this.setLastBuild(curDate);
            msg = BpmMsgs.get("built_website");
            StatusBox.singleton().queueShowMsg(msg.format(this.def().albumName()), msg.isError());
            this.iLastCopyright = this.def().copyright();
            String homePath = String.valueOf(this.path()) + '/' + HOMEPAGE;
            StringSelection str = new StringSelection(homePath);
            Toolkit tkit = Toolkit.getDefaultToolkit();
            tkit.getSystemClipboard().setContents(str, null);
        }
    }

    public void upload(FtpServer server, String hostDir, Date curDate) throws Exception {
        MAppMsg msg = BpmMsgs.get("uploading_website");
        String text = msg.format(this.iDef.albumName());
        StatusBox.singleton().queueShowMsg(text, msg.isError());
        try {
            EventQueue.invokeAndWait(new PcUpdater(0));
            boolean completed = this.uploadImgs(server, hostDir, curDate);
            if (completed) {
                completed = this.uploadCustomImgs(server, hostDir);
            }
            if (completed) {
                completed &= this.uploadHtml(server, hostDir);
            }
            this.uploadViewerFile(server, hostDir);
            if (this.isSurvey()) {
                String dir = String.valueOf(hostDir) + SURVEYDIR;
                server.mkdir(dir);
                dir = String.valueOf(this.path()) + '/' + SURVEYDIR;
                server.uploadFolder(String.valueOf(hostDir) + SURVEYDIR, dir);
            }
            this.setupHomeLinks(server, hostDir);
            EventQueue.invokeAndWait(new PcUpdater(100));
            this.iLastUpload = curDate;
            Database.singleton().webDb().put(this);
            msg = BpmMsgs.get("uploaded_website");
            text = msg.format(this.def().albumName());
            StatusBox.singleton().queueShowMsg(text, msg.isError());
        }
        finally {
            server.disconnect();
        }
    }

    private void setupHomeLinks(FtpServer server, String hostDir) throws Exception {
        String localPath = String.valueOf(this.path()) + '/' + HOMEPAGE;
        server.uploadFile(String.valueOf(hostDir) + HOMEPAGE, localPath);
        ProgInstallation installation = ProgInstallation.singleton();
        localPath = String.valueOf(installation.dir()) + '/' + DEFAULTPAGE_TEMPLATE;
        File file = new File(localPath);
        if (file.exists()) {
            FileInputStream in = new FileInputStream(localPath);
            LinkedList<String> lines = Utility.readTextFileFromStream(in);
            PrintWriter out = new PrintWriter(String.valueOf(this.path()) + '/' + DEFAULTPAGE);
            for (String line : lines) {
                MString work = new MString(line);
                work.replace("$title$", this.def().title());
                out.println(work.toString());
            }
            in.close();
            out.close();
            server.uploadFile(String.valueOf(hostDir) + DEFAULTPAGE, localPath);
            if (!this.def().backImg().equals("None")) {
                String filename = this.def().backImg();
                localPath = String.valueOf(this.path()) + '/' + filename;
                server.uploadFile(String.valueOf(hostDir) + filename, localPath);
            }
        }
    }

    private void setupPrevNextLinks() throws Exception {
        LinkedList<String> subPages = AlbumHtmlPage.subPages();
        String[] pages = new String[subPages.size()];
        int i = 0;
        for (String page : subPages) {
            pages[i++] = page;
        }
        i = 0;
        String[] stringArray = pages;
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            String previous;
            String page;
            page = stringArray[n2];
            String path = String.valueOf(this.path()) + File.separator + page;
            MString text = Utility.readFileAsText(path);
            if (i == 0) {
                text.replace("##previous", "");
                String next = "<a href=" + pages[i + 1] + ">Next</a>";
                text.replace("##next", next);
            } else if (i == pages.length - 1) {
                previous = "<a href=" + pages[i - 1] + ">Previous</a>";
                text.replace("##previous", previous);
                text.replace("##next", "");
            } else {
                previous = "<a href=" + pages[i - 1] + ">Previous</a>";
                text.replace("##previous", previous);
                String next = "<a href=" + pages[i + 1] + ">Next</a>";
                text.replace("##next", next);
            }
            LinkedList<byte[]> bytes = new LinkedList<byte[]>();
            bytes.add(text.bytes());
            Utility.writeBinaryFile(path, bytes);
            ++i;
            ++n2;
        }
    }

    private void removePageHtml() {
        File[] pageFiles;
        File dir = new File(this.path());
        File[] fileArray = pageFiles = dir.listFiles(new PageHtmlFilter());
        int n = pageFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
    }

    private void removePicHtml() {
        File[] htmlFiles;
        File dir = new File(this.path());
        File[] fileArray = htmlFiles = dir.listFiles(new PicHtmlFilter());
        int n = htmlFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            file.delete();
            ++n2;
        }
    }

    private boolean buildImgs(MLogging logger) throws Exception {
        boolean completed = false;
        Database db = Database.singleton();
        Query query = db.query(this.def().albumName(), true);
        try {
            TreeSet<PicInfo> pics = db.selectPicInfos(query);
            if (pics.size() < this.def().numCols()) {
                String msg = BpmMsgs.get("too_many_columns").format();
                StatusBox.singleton().showMsg(msg, true);
            } else {
                String order = this.def().imageOrder();
                this.iOrderedImgs = order.equals("By date") ? new TreeMap(new PicInfo.DateComparator()) : (order.equals("By region") ? new TreeMap(new PicInfo.RegionComparator()) : (order.equals("By id") ? new TreeMap(new PicInfo.IdComparator()) : (order.equals("By group") ? new TreeMap(new PicInfo.GroupComparator()) : new TreeMap(new PicInfo.NumPixComparator()))));
                double total = pics.size() + 1;
                double count = 0.0;
                Iterator iter = pics.iterator();
                boolean forceBuild = this.iLastCopyright != null && !this.iLastCopyright.equals(this.def().copyright());
                while (iter.hasNext() && WebMgr.buildActive()) {
                    PicInfo info = (PicInfo)iter.next();
                    WebImg webImg = this.iImgs.get(info);
                    if (webImg == null) {
                        webImg = this.buildImg(info, logger);
                    } else if (forceBuild || webImg.needsBuild(this, info)) {
                        webImg = this.buildImg(info, logger);
                    } else {
                        String imagePath = String.valueOf(this.imagePath()) + '/' + info.id() + ".jpg";
                        File file = new File(imagePath);
                        if (!file.exists()) {
                            webImg = this.buildImg(info, logger);
                        }
                    }
                    if (webImg != null) {
                        webImg.setPicInfo(info);
                        this.iOrderedImgs.put(info, webImg);
                    }
                    int done = (int)(90.0 * (count += 1.0) / total);
                    EventQueue.invokeAndWait(new PcUpdater(done));
                }
                this.iImgs.clear();
                Collection<WebImg> webImgs = this.iOrderedImgs.values();
                for (WebImg img : webImgs) {
                    this.iImgs.put(img.picInfo(), img);
                }
                completed = true;
            }
        }
        finally {
            Database.singleton().webDb().put(this);
        }
        return completed;
    }

    private WebImg buildImg(PicInfo info, MLogging logger) {
        WebImg webImg = null;
        String pathname = info.picPathname();
        try {
            BufferedImage image = ImageIOUtil.load(pathname);
            if (image == null) {
                String msg = BpmMsgs.get("unable_read_file").format(info.fileName());
                StatusBox.singleton().queueShowMsg(msg, true);
            } else {
                webImg = new WebImg(pathname, image, info, this);
                image = null;
                logger.writeln("Web: built image " + pathname, false);
            }
        }
        catch (Exception xcp) {
            webImg = null;
            String msg = BpmMsgs.get("unable_build_image").format(Utility.xcpMsg(xcp));
            logger.writeln(MSGPREFIX + msg, true);
            msg = BpmMsgs.get("unable_build_image").format(pathname);
            StatusBox.singleton().queueShowMsg(msg, true);
        }
        return webImg;
    }

    private void writeBpvFile() throws Exception {
        String localPath = String.valueOf(this.path()) + '/' + "images.dat";
        File file = new File(localPath.toLowerCase());
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
        Collection<WebImg> webImgs = this.iOrderedImgs.values();
        LinkedList<WebImg> viewerImgs = new LinkedList<WebImg>();
        for (WebImg img : webImgs) {
            WebImg viewerImg = (WebImg)img.clone();
            String label = img.picInfo().webLabel(this.def().annot(), 64);
            viewerImg.setLabel(label);
            viewerImgs.add(viewerImg);
        }
        out.writeObject(viewerImgs);
        out.close();
    }

    private void uploadViewerFile(FtpServer server, String hostDir) throws Exception {
        String localPath = String.valueOf(this.path()) + '/' + "images.dat";
        String hostPath = String.valueOf(hostDir) + "images.dat";
        server.uploadFile(hostPath, localPath);
    }

    private boolean uploadHtml(FtpServer server, String hostDir) throws Exception {
        String imageDir = this.iDef.imageDir();
        File dir = new File(this.path());
        File[] files = dir.listFiles(new HtmlFilter(null, null));
        int i = 0;
        while (i < files.length && WebMgr.uploadActive()) {
            String fileName = files[i].getName().toLowerCase();
            String hostPath = hostDir;
            if (imageDir.length() > 0) {
                hostPath = String.valueOf(hostPath) + hostDir + DELIM;
            }
            hostPath = String.valueOf(hostPath) + fileName;
            String localPath = String.valueOf(this.path()) + DELIM + fileName;
            if (imageDir.length() > 0) {
                localPath = String.valueOf(this.path()) + DELIM + imageDir + DELIM + fileName;
            }
            server.uploadFile(hostPath, localPath);
            int done = (int)(75.0f + 25.0f * (float)i / (float)files.length);
            EventQueue.invokeAndWait(new PcUpdater(done));
            ++i;
        }
        return WebMgr.uploadActive();
    }

    private boolean uploadCustomImgs(FtpServer server, String hostDir) throws Exception {
        String imageDir = this.iDef.imageDir();
        File dir = new File(this.path());
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            String fileName = files[i].getName().toLowerCase();
            if (fileName.startsWith(UPLOADFILEPREFIX)) {
                String hostPath = hostDir;
                if (imageDir.length() > 0) {
                    hostPath = String.valueOf(hostPath) + hostDir + DELIM;
                }
                hostPath = String.valueOf(hostPath) + fileName;
                String localPath = String.valueOf(this.path()) + DELIM + fileName;
                if (imageDir.length() > 0) {
                    localPath = String.valueOf(this.path()) + DELIM + imageDir + DELIM + fileName;
                }
                server.uploadFile(hostPath, localPath);
            }
            ++i;
        }
        return WebMgr.uploadActive();
    }

    /*
     * Unable to fully structure code
     */
    private boolean uploadImgs(FtpServer server, String hostDir, Date curDate) throws Exception {
        completed = false;
        total = this.iImgs.size() + 1;
        count = 0;
        imgs = this.iImgs.values().iterator();
        ** GOTO lbl35
        {
            img = imgs.next();
            imageName = img.picInfo().id() + ".jpg";
            imageDir = this.iDef.imageDir();
            hostPath = String.valueOf(hostDir) + imageDir;
            if (imageDir.length() > 0) {
                server.mkdir(hostPath);
            }
            if (!hostPath.endsWith("/")) {
                hostPath = String.valueOf(hostPath) + "/";
            }
            hostPath = String.valueOf(hostPath) + imageName;
            localPath = String.valueOf(this.path()) + "/" + imageDir + "/" + imageName;
            hostPath = String.valueOf(hostDir) + imageDir;
            if (!hostPath.endsWith("/")) {
                hostPath = String.valueOf(hostPath) + "/";
            }
            hostPath = String.valueOf(hostPath) + imageName;
            localPath = String.valueOf(this.path()) + "/" + imageDir + '/' + imageName;
            if (img.needsUpload(this, server, hostPath)) {
                server.uploadFile(hostPath, localPath);
                hostPath = String.valueOf(hostDir) + imageDir;
                if (!hostPath.endsWith("/")) {
                    hostPath = String.valueOf(hostPath) + "/";
                }
                hostPath = String.valueOf(hostPath) + img.thumbFilename();
                localPath = String.valueOf(this.path()) + "/" + imageDir + '/' + img.thumbFilename();
                server.uploadFile(hostPath, localPath);
                img.setUploadDate(curDate);
            }
            done = (int)(75.0f * (float)(++count) / (float)total);
            EventQueue.invokeAndWait(new PcUpdater(done));
            do {
                if (imgs.hasNext() && WebMgr.uploadActive()) continue block0;
                completed = WebMgr.uploadActive();
lbl35:
                // 2 sources

            } while (imgs.hasNext() && WebMgr.uploadActive());
        }
        return completed;
    }

    private class HtmlFilter
    implements FilenameFilter {
        private HtmlFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            boolean accept = name.endsWith(Website.HTML);
            return accept;
        }

        /* synthetic */ HtmlFilter(HtmlFilter htmlFilter, HtmlFilter htmlFilter2) {
            this();
        }
    }

    private class PageHtmlFilter
    extends HtmlFilter {
        private PageHtmlFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            boolean accept = super.accept(dir, name);
            if (accept) {
                accept = false;
                if (name.startsWith("page")) {
                    accept = true;
                }
            }
            return accept;
        }
    }

    private class PcUpdater
    extends Thread {
        private int iPercent = 0;

        public PcUpdater(int percent) {
            this.iPercent = percent;
        }

        @Override
        public void run() {
            WebDefDialog.putPercent(this.iPercent);
        }
    }

    private class PicHtmlFilter
    extends HtmlFilter {
        private PicHtmlFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            boolean accept = super.accept(dir, name);
            if (accept) {
                accept = false;
                int index = name.indexOf(46);
                if (index >= 0) {
                    name = name.substring(0, index);
                }
                try {
                    Integer.parseInt(name);
                    accept = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return accept;
        }
    }
}

