/*
 * Decompiled with CFR 0.152.
 */
package oroma.db;

import java.io.Serializable;
import java.util.LinkedList;
import oroma.db.ProgPreferences;

public class PicTag
implements Serializable,
Cloneable {
    private int iX = -1;
    private int iY = -1;
    private String iText = "";

    public PicTag(String text, int x, int y) {
        this.iText = text;
        this.iX = x;
        this.iY = y;
    }

    public Object clone() {
        PicTag copy = null;
        try {
            copy = (PicTag)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return copy;
    }

    public static PicTag find(LinkedList<PicTag> tags, int xPos, int yPos) {
        PicTag tag = null;
        int tolerance = ProgPreferences.singleton().tagMarkerSize() * 2;
        for (PicTag aTag : tags) {
            int yDiff;
            int xDiff = xPos - aTag.iX;
            if (xDiff < 0) {
                xDiff *= -1;
            }
            if ((yDiff = yPos - aTag.iY) < 0) {
                yDiff *= -1;
            }
            if (xDiff > tolerance || yDiff > tolerance) continue;
            tag = aTag;
            break;
        }
        return tag;
    }

    public String getText() {
        return this.iText;
    }

    public int getX() {
        return this.iX;
    }

    public int getY() {
        return this.iY;
    }

    public void setText(String newText) {
        this.iText = newText;
    }

    public void setX(int newX) {
        this.iX = newX;
    }

    public void setY(int newY) {
        this.iY = newY;
    }
}

