/*
 * Decompiled with CFR 0.152.
 */
package oroma.db;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import mlib.MAppMsg;
import mlib.MLogger;
import mlib.MLogging;
import mlib.MString;
import mswing.ThumbnailImage;
import oroma.albumgui.Thumbnail;
import oroma.db.BpmExifTag;
import oroma.db.Database;
import oroma.db.ExifTags;
import oroma.db.ImageFileInfo;
import oroma.db.PersonGroup;
import oroma.db.PicTag;
import oroma.db.ProgPreferences;
import oroma.gui.BpmMsgs;
import oroma.gui.Main;
import swing.DatePanel;
import swing.StatusBox;
import utilt.BinnedDb;
import utilt.ImageIOUtil;
import utilt.Utility;
import utilt.XmlAble;

public class PicInfo
implements Serializable,
Cloneable,
Comparable<PicInfo>,
BinnedDb.Binnable,
XmlAble {
    private TreeMap<String, ComboField> iFieldsByName = new TreeMap();
    private Integer iObjNum = -1;
    private String iNotes = "";
    private String iLink = "";
    private int iYear = -1;
    private int iMonth = -1;
    private int iDay = -1;
    private int iUncer = -1;
    private int iHour = -1;
    private LinkedList<PersonGroup> iPersons = new LinkedList();
    private LinkedList<PicTag> iTags = new LinkedList();
    private String iPicPathname = "";
    private ImageFileInfo iFileInfo = new ImageFileInfo();
    private ExifTags jExifTags = null;
    private String iDateStr = "no date";
    private Calendar iUpdateDate = null;
    private Integer iThumbObjNum = -1;
    private Integer iOrigObjNum = -1;
    private String iOrigPath = null;
    private boolean iUpdateExif = false;
    private transient ThumbnailImage iThumbnail = null;
    private transient String iDateSortStr = null;
    private transient String iMonthSortStr = null;
    public static final String CAMERAFLDNAME = "camera";
    public static final String COUNTRYFLDNAME = "country";
    public static final String FILMTYPEFLDNAME = "film type";
    public static final String PLACEFLDNAME = "place";
    public static final String RATINGFLDNAME = "rating";
    public static final String REGIONFLDNAME = "region";
    public static final String TOPICFLDNAME = "topic";
    public static final String TOWNFLDNAME = "town";
    public static final String TAKENBYFLDNAME = "taken by";
    public static final String SOURCEFLDNAME = "source";
    public static final String IDENTIFIERFLDNAME = "identifier";
    public static final String TECHNIQUEFLDNAME = "technique";
    public static final String LENSFLDNAME = "lens";
    public static final String DEVELOPERFLDNAME = "developer";
    public static final String SCANNERFLDNAME = "scanner";
    public static final String FILMROLLFLDNAME = "film roll";
    public static final String STORAGEFLDNAME = "storage";
    public static final String STATUSFLDNAME = "status";
    public static final String LOCATIONFLDNAME = "location";
    public static final String SUBJECTFLDNAME = "subject";
    public static final String GROUPFLDNAME = "group";
    public static final String FILMFORMATFLDNAME = "film format";
    public static final String[] COMBOBOXFLDS = new String[]{"camera", "country", "film type", "place", "rating", "region", "topic", "town", "taken by", "source", "identifier", "technique", "lens", "developer", "scanner", "film roll", "storage", "status", "location", "subject", "group", "film format"};
    public static final String NOTESFLDNAME = "notes";
    public static final String LINKFLDNAME = "link";
    public static final String PERSONSFLDNAME = "persons";
    public static final String DATEFLDNAME = "date";
    public static final String STATUSNEW = "new";
    public static final int NOINTVALUE = -1;
    public static final String NODATE = "no date";
    public static final String HIDDEN = "hidden";
    public static final int THUMBREBUILDTHRESHOLD = 5000;
    public static int MOSTUSEDFIELDNUM = -1;
    public static int IDFIELDNUM = -1;
    private static final String NOSTRVALUE = "";
    private static final String SEP = ", ";
    private static final int SORTSIZE = 100;
    private static final int DATESTRLEN = 8;
    private static final String NODATEPART = "00";
    static final long serialVersionUID = -4790980857775648971L;
    private static ComboField[] FieldsByPos = null;

    static {
        PicInfo.setupComboFields();
    }

    public static void main(String[] args) {
        try {
            PicInfo info = new PicInfo(123);
            Collection<String> xml = info.toXML(NOSTRVALUE);
            System.out.println(xml);
            ComboField field = info.comboField(TOWNFLDNAME);
            System.out.println("compare:");
            field.setValue("abc ^xyz");
            System.out.println(field.compareValue());
            field.setValue("#abc ^xyz");
            System.out.println(field.compareValue());
            field.setValue("def#abc ^xyz");
            System.out.println(field.compareValue());
            System.out.println();
            System.out.println("sort");
            field.setValue("abc ^xyz");
            System.out.println(field.sortValue());
            field.setValue("#abc ^xyz");
            System.out.println(field.sortValue());
            field.setValue("def#abc ^xyz");
            System.out.println(field.sortValue());
            System.out.println("web display:");
            field.setValue("abc ^xyz");
            System.out.println(field.webDisplayValue());
            field.setValue("#abc ^xyz");
            System.out.println(field.webDisplayValue());
            field.setValue("def#abc ^xyz");
            System.out.println(field.webDisplayValue());
            System.out.println("web label:");
            field.setValue("abc ^xyz");
            System.out.println(field.webLabelValue());
            field.setValue("#abc ^xyz");
            System.out.println(field.webLabelValue());
            field.setValue("def#abc ^xyz");
            System.out.println(field.webLabelValue());
        }
        catch (Exception xcp) {
            System.out.println(xcp);
        }
    }

    public static ComboField[] comboFieldsByPos() {
        return FieldsByPos;
    }

    public static int comboFieldPos(String name) {
        int pos = -1;
        int i = 0;
        while (i < FieldsByPos.length && pos < 0) {
            if (FieldsByPos[i].name().equalsIgnoreCase(name)) {
                pos = i;
            }
            ++i;
        }
        return pos;
    }

    private static void setupComboFields() {
        TreeMap<String, ComboField> fields = PicInfo.createComboFields();
        TreeSet<ComboField> sorted = new TreeSet<ComboField>();
        for (ComboField field : fields.values()) {
            sorted.add(field);
        }
        FieldsByPos = sorted.toArray(new ComboField[0]);
        MOSTUSEDFIELDNUM = PicInfo.comboFieldPos(TOPICFLDNAME);
        IDFIELDNUM = PicInfo.comboFieldPos(IDENTIFIERFLDNAME);
    }

    private static TreeMap<String, ComboField> createComboFields() {
        TreeMap<String, ComboField> fields = new TreeMap<String, ComboField>();
        fields.put(PLACEFLDNAME, new ComboField(PLACEFLDNAME, 2));
        fields.put(TOWNFLDNAME, new ComboField(TOWNFLDNAME, 4));
        fields.put(REGIONFLDNAME, new ComboField(REGIONFLDNAME, 5));
        fields.put(COUNTRYFLDNAME, new ComboField(COUNTRYFLDNAME, 6));
        fields.put(TOPICFLDNAME, new ComboField(TOPICFLDNAME, 7));
        fields.put(SOURCEFLDNAME, new ComboField(SOURCEFLDNAME, 8));
        fields.put(TAKENBYFLDNAME, new ComboField(TAKENBYFLDNAME, 9));
        fields.put(CAMERAFLDNAME, new ComboField(CAMERAFLDNAME, 10));
        fields.put(FILMTYPEFLDNAME, new ComboField(FILMTYPEFLDNAME, 11));
        fields.put(LENSFLDNAME, new ComboField(LENSFLDNAME, 13));
        fields.put(TECHNIQUEFLDNAME, new ComboField(TECHNIQUEFLDNAME, 14));
        fields.put(DEVELOPERFLDNAME, new ComboField(DEVELOPERFLDNAME, 15));
        fields.put(SCANNERFLDNAME, new ComboField(SCANNERFLDNAME, 16));
        fields.put(RATINGFLDNAME, new ComboField(RATINGFLDNAME, 18));
        fields.put(IDENTIFIERFLDNAME, new ComboField(IDENTIFIERFLDNAME, 19));
        fields.put(FILMROLLFLDNAME, new ComboField(FILMROLLFLDNAME, 20));
        fields.put(STATUSFLDNAME, new ComboField(STATUSFLDNAME, 21));
        fields.put(STORAGEFLDNAME, new ComboField(STORAGEFLDNAME, 22));
        fields.put(LOCATIONFLDNAME, new ComboField(LOCATIONFLDNAME, 3));
        fields.put(SUBJECTFLDNAME, new ComboField(SUBJECTFLDNAME, 1));
        fields.put(GROUPFLDNAME, new ComboField(GROUPFLDNAME, 17));
        fields.put(FILMFORMATFLDNAME, new ComboField(FILMFORMATFLDNAME, 12));
        return fields;
    }

    private static void writeXMLText(MLogging logger, String name, String value, String indent) {
        if (value != null) {
            MString str = new MString(value);
            str.removeWhitespace();
            if (str.length() > 0) {
                String ele = String.valueOf(indent) + "<" + name + "> " + value + " </" + name + ">";
                logger.writeln(ele, false);
            }
        }
    }

    private static void writeXMLInt(MLogging logger, String name, int value, String indent) {
        String str = NOSTRVALUE;
        if (value != -1) {
            str = Integer.toString(value);
        }
        PicInfo.writeXMLText(logger, name, str, indent);
    }

    public PicInfo() {
        this.iFieldsByName = PicInfo.createComboFields();
    }

    public PicInfo(Integer objNum) {
        this();
        this.setId(objNum);
        this.iOrigObjNum = objNum;
    }

    @Override
    public void setId(Integer num) {
        this.iObjNum = num;
        this.iThumbObjNum = num;
    }

    @Override
    public Integer id() {
        return this.iObjNum;
    }

    @Override
    public String name() {
        return this.iPicPathname;
    }

    public String dateSortStr() {
        return this.iDateSortStr;
    }

    public String monthSortStr() {
        return this.iMonthSortStr;
    }

    public ThumbnailImage thumbnail() {
        return this.iThumbnail;
    }

    public boolean hasThumbnail() {
        return this.iThumbnail != Thumbnail.DefaultThumbnail;
    }

    public void setThumbId(int id) {
        this.iThumbObjNum = id;
    }

    public Integer thumbObjNum() {
        return this.iThumbObjNum;
    }

    public Integer origObjNum() {
        return this.iOrigObjNum;
    }

    public ComboField[] comboFields() {
        ComboField[] fields = new ComboField[this.iFieldsByName.size()];
        Iterator<ComboField> iterator = this.iFieldsByName.values().iterator();
        while (iterator.hasNext()) {
            ComboField field;
            fields[field.pos() - 1] = field = iterator.next();
        }
        return fields;
    }

    public ComboField comboField(String name) {
        return this.iFieldsByName.get(name);
    }

    public String comboFieldsStr() {
        MString str = new MString();
        for (ComboField field : this.iFieldsByName.values()) {
            MString value = field.compareValue();
            if (value == null || value.length() <= 0) continue;
            if (str.length() > 0) {
                str.concat(SEP);
            }
            str.concat(String.valueOf(field.name()) + ":");
            str.concat(String.valueOf('\"') + value.toString() + '\"');
        }
        return str.toString();
    }

    public void addPerson(PersonGroup perGroup) {
        this.iPersons.add((PersonGroup)perGroup.clone());
    }

    public void replacePerson(PersonGroup from, PersonGroup to) {
        for (PersonGroup pg : this.iPersons) {
            if (pg == null || !pg.equals(from)) continue;
            pg.assign(to);
        }
    }

    public void assign(PicInfo info) {
        this.assignFromQuery(info);
        this.setNotes(info.iNotes);
        this.setLink(info.iLink);
        this.iObjNum = info.iObjNum;
        this.iPicPathname = info.iPicPathname;
        this.iOrigPath = info.iOrigPath;
        this.iPersons = new LinkedList();
        this.setPersons(info.iPersons);
        this.iTags = new LinkedList();
        this.iTags.addAll(info.iTags);
    }

    public void assignFromQuery(PicInfo info) {
        this.assignComboFields(info);
        this.assignDate(info);
    }

    public void assignFromBpmExifTag() {
        File file = new File(this.iPicPathname);
        if (file.getName().toLowerCase().endsWith(".jpg")) {
            try {
                ExifTags tags = ExifTags.read(this, false);
                ExifTags.Pair tag = tags.getTag("Unknown tag (0x84e0)");
                if (tag != null) {
                    MString value;
                    BpmExifTag bpmTag = new BpmExifTag(this, tag);
                    for (ComboField field : this.iFieldsByName.values()) {
                        MString value2;
                        if (field.compareValue().length() != 0 || (value2 = bpmTag.getElement(field.name())) == null) continue;
                        field.setValue(value2.toString());
                    }
                    if (this.year() == -1 && (value = bpmTag.getElement("year")) != null) {
                        this.setYear(Integer.parseInt(value.toString()));
                    }
                    if (this.month() == -1 && (value = bpmTag.getElement("month")) != null) {
                        this.setMonth(Integer.parseInt(value.toString()));
                    }
                    if (this.day() == -1 && (value = bpmTag.getElement("day")) != null) {
                        this.setDay(Integer.parseInt(value.toString()));
                    }
                    if (this.uncer() == -1 && (value = bpmTag.getElement("uncer")) != null) {
                        this.setUncer(Integer.parseInt(value.toString()));
                    }
                    if (this.notes().length() == 0 && (value = bpmTag.getElement(NOTESFLDNAME)) != null) {
                        this.setNotes(value.toString());
                    }
                    if (this.link().length() == 0 && (value = bpmTag.getElement(LINKFLDNAME)) != null) {
                        this.setLink(value.toString());
                    }
                    if (this.iPersons.size() == 0) {
                        value = bpmTag.getElement(PERSONSFLDNAME);
                        String[] persons = Utility.parseDelimStr(value.toString(), ",");
                        this.iPersons.clear();
                        String[] stringArray = persons;
                        int n = persons.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String person = stringArray[n2];
                            this.iPersons.add(new PersonGroup(person));
                            ++n2;
                        }
                    }
                }
            }
            catch (Exception xcp) {
                MAppMsg msg = BpmMsgs.get("unable_assign_exif");
                Main.singleton().logger().writeln(msg.format(Utility.xcpMsg(xcp)));
            }
        }
    }

    public void assignDate(PicInfo info) {
        this.setUncer(info.iUncer);
        this.setYear(info.iYear);
        this.setMonth(info.iMonth);
        this.setDay(info.iDay);
        this.setHour(info.iHour);
    }

    public void assignComboFields(PicInfo info) {
        for (ComboField field : this.iFieldsByName.values()) {
            MString value = info.iFieldsByName.get(field.name()).mValue();
            if (value.isEmpty()) {
                value.assign(NOSTRVALUE);
            }
            field.setValue(value.toString());
        }
    }

    public void setupForAdd() {
        for (ComboField field : this.iFieldsByName.values()) {
            MString value = field.mValue();
            value.remove("*", 999, 0);
            field.setValue(value.toString());
        }
        this.iNotes = NOSTRVALUE;
        this.iLink = NOSTRVALUE;
    }

    public Object clone() {
        PicInfo clone = null;
        try {
            clone = (PicInfo)super.clone();
            if (this.iUpdateDate != null) {
                clone.iUpdateDate = (Calendar)this.iUpdateDate.clone();
            }
            clone.iPersons = new LinkedList();
            for (PersonGroup person : this.iPersons) {
                clone.iPersons.add((PersonGroup)person.clone());
            }
            clone.iTags = new LinkedList();
            for (PicTag tag : this.iTags) {
                clone.iTags.add((PicTag)tag.clone());
            }
            clone.iFileInfo = (ImageFileInfo)this.iFileInfo.clone();
            clone.iFieldsByName = PicInfo.createComboFields();
            for (ComboField field : this.iFieldsByName.values()) {
                ComboField copy = clone.iFieldsByName.get(field.name());
                copy.setValue(this.iFieldsByName.get(field.name()).value().toString());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public String dateStr() {
        String str = this.iDateStr;
        if ((str = str.replace('-', ' ')).charAt(0) == '0') {
            str = " " + str.substring(1);
        }
        return str;
    }

    public int day() {
        return this.iDay;
    }

    public ImageFileInfo getFileInfo() {
        return this.iFileInfo;
    }

    public int month() {
        return this.iMonth;
    }

    public String notes() {
        return this.iNotes;
    }

    public void setNotes(String notes) {
        this.iNotes = notes.trim();
    }

    public String notesWebValue() {
        String notes = this.notes();
        if (notes.length() > 0 && notes.charAt(0) == '#') {
            notes = NOSTRVALUE;
        }
        return notes;
    }

    public String link() {
        return this.iLink;
    }

    public void setLink(String link) {
        this.iLink = link;
    }

    public LinkedList<PersonGroup> persons() {
        return this.iPersons;
    }

    public String picPathname() {
        return this.iPicPathname;
    }

    public LinkedList<PicTag> tags() {
        return this.iTags;
    }

    public void setFileInfo(ImageFileInfo info) {
        this.iFileInfo = info;
    }

    public int uncer() {
        return this.iUncer;
    }

    public int year() {
        return this.iYear;
    }

    public void setDay(int newDay) {
        this.iDay = newDay;
        this.setupDate();
    }

    public void setHour(int hour) {
        this.iHour = hour;
        this.setupDate();
    }

    public int hour() {
        return this.iHour;
    }

    public void setMonth(int newMonth) {
        this.iMonth = newMonth;
        this.setupDate();
    }

    public void setPersons(LinkedList<PersonGroup> newPersons) {
        this.iPersons.clear();
        for (PersonGroup pGroup : newPersons) {
            this.iPersons.add((PersonGroup)pGroup.clone());
        }
    }

    public ExifTags exifTags() {
        return this.jExifTags;
    }

    public String bpmExifTag() {
        ExifTags tags = this.exifTags();
        String value = null;
        ExifTags.Pair tag = tags.getTag("Unknown tag (0x84e0)");
        if (tag != null) {
            value = tag.getValue();
        }
        return value;
    }

    public void setExifTags(ExifTags tags) {
        this.jExifTags = tags;
    }

    public void setPicPathname(String pathname) {
        this.iPicPathname = pathname.replace('\\', '/');
        if (this.iPicPathname == null) {
            this.iPicPathname = pathname;
        }
    }

    public Calendar updateDate() {
        return this.iUpdateDate;
    }

    public void setUpdateDate(Calendar date) {
        this.iUpdateDate = date;
    }

    public String fileName() {
        String name = this.iPicPathname;
        int index = name.lastIndexOf(47);
        if (index >= 0) {
            name = name.substring(index + 1);
        }
        return name;
    }

    public void setTags(LinkedList<PicTag> newTags) {
        this.iTags = newTags;
    }

    public void setUncer(int newUncer) {
        this.iUncer = newUncer;
    }

    public void setupDate() {
        this.iDateStr = NODATE;
        MString sortStr = new MString();
        MString monthStr = null;
        if (this.iYear == -1) {
            sortStr.concat(NODATEPART);
            sortStr.addHead('0', 8);
        } else {
            this.iDateStr = DatePanel.dateString(this.iYear, this.iMonth, this.iDay);
            sortStr.concat(Integer.toString(this.iYear));
            if (this.iMonth != -1) {
                monthStr = new MString(Integer.toString(this.iMonth));
                monthStr.addHead('0', 2);
                sortStr.concat(monthStr);
            } else {
                sortStr.concat(NODATEPART);
            }
            if (this.iDay != -1) {
                MString dayStr = new MString(Integer.toString(this.iDay));
                dayStr.addHead('0', 2);
                sortStr.concat(dayStr);
            } else {
                sortStr.concat(NODATEPART);
            }
        }
        this.iMonthSortStr = sortStr.toString();
        if (monthStr != null) {
            this.iMonthSortStr = String.valueOf(monthStr.toString()) + sortStr;
        }
        String hourStr = NODATEPART;
        if (this.iHour != -1) {
            hourStr = Integer.toString(this.iHour);
        }
        if (hourStr.length() == 1) {
            hourStr = "0" + hourStr;
        }
        sortStr.concat(hourStr);
        this.iDateSortStr = sortStr.toString();
        if (this.iUncer > 0) {
            this.iDateStr = String.valueOf(this.iDateStr) + '?';
            this.iDateSortStr = String.valueOf(this.iDateSortStr) + '?';
        } else {
            this.iDateSortStr = String.valueOf(this.iDateSortStr) + '>';
        }
    }

    public void setYear(int newYear) {
        this.iYear = newYear;
        this.setupDate();
    }

    public String webLabel(String fieldsStr, int maxNotesLength) {
        MString label = new MString();
        String[] fields = null;
        try {
            fields = Utility.parseDelimStr(fieldsStr.toLowerCase(), ",");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            MString value;
            String field = stringArray[n2];
            if (field.equals(TOWNFLDNAME)) {
                value = this.comboField(TOWNFLDNAME).mValue();
                if (!value.isEmpty()) {
                    int index = value.indexOf('^');
                    if (index >= 0) {
                        try {
                            value = value.substring(0, index - 1);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (value.charAt(0) == '#') {
                        value.replace("#", "near ");
                    }
                    if (!value.isEmpty()) {
                        label.concat(SEP + value.trimWhitespace());
                    }
                }
            } else if (field.equals(LOCATIONFLDNAME)) {
                value = this.comboField(LOCATIONFLDNAME).mValue();
                if (!value.isEmpty()) {
                    if (value.charAt(0) == '#') {
                        value.clear();
                    } else {
                        int index = value.indexOf('^');
                        if (index >= 0) {
                            try {
                                value = value.substring(0, index - 1);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    if (!value.isEmpty()) {
                        label.concat(SEP + value.trimWhitespace());
                    }
                }
            } else if (field.equals(DATEFLDNAME)) {
                if (!this.dateStr().equals(NODATE)) {
                    label.concat(SEP + new MString(this.dateStr()));
                }
            } else if (field.equals(NOTESFLDNAME)) {
                MString work = new MString(this.notes()).trimWhitespaceTail();
                if (work.length() > 0) {
                    MString notes = new MString();
                    if (work.charAt(0) != '#') {
                        Iterator words = work.tokenize(" ", false).iterator();
                        boolean done = false;
                        while (!done && words.hasNext()) {
                            MString word = (MString)words.next();
                            if (word.length() + notes.length() < maxNotesLength) {
                                notes.concat(word + " ");
                                continue;
                            }
                            notes.concat("...");
                            done = true;
                        }
                    }
                    notes.trimWhitespace();
                    label.concat(SEP + notes);
                }
            } else {
                value = this.comboField(field).webLabelValue().trimWhitespace();
                if (!value.isEmpty()) {
                    label.concat(SEP + value);
                }
            }
            ++n2;
        }
        label.remove(SEP, 1, 0);
        return label.toString();
    }

    @Override
    public int compareTo(PicInfo info) {
        int result = 0;
        if (info != this) {
            result = -1;
            if (info != null) {
                result = this.iDateSortStr.compareTo(info.iDateSortStr);
            }
            if (result == 0) {
                result = -1;
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        return this.compareTo((PicInfo)obj) == 0;
    }

    public int hashCode() {
        return this.iPicPathname.hashCode();
    }

    public boolean equalInValue(PicInfo info) {
        boolean equal = false;
        if (info != null && (equal = info.dateSortStr().equals(this.dateSortStr()))) {
            Iterator<ComboField> iter = this.iFieldsByName.values().iterator();
            while (!equal && iter.hasNext()) {
                ComboField field1 = iter.next();
                ComboField field2 = info.iFieldsByName.get(field1.name());
                equal = field1.equalInValue(field2);
            }
        }
        return equal;
    }

    public Collection<String> diffComboFields(PicInfo otherInfo) {
        LinkedList<String> diffs = new LinkedList<String>();
        Collection<ComboField> fields = this.iFieldsByName.values();
        for (ComboField field : fields) {
            ComboField other = otherInfo.iFieldsByName.get(field.name());
            if (field.value().equals(other.value())) continue;
            diffs.add(field.name());
        }
        return diffs;
    }

    public boolean updateComboFields(Collection<String> fieldNames, PicInfo sourceInfo) {
        ComboField field;
        boolean update = true;
        for (String name : fieldNames) {
            field = this.iFieldsByName.get(name);
            ComboField sourceField = sourceInfo.iFieldsByName.get(name);
            update &= field.value().equals(sourceField.prevValue());
        }
        if (update) {
            for (String name : fieldNames) {
                field = this.iFieldsByName.get(name);
                String curValue = field.value();
                String newValue = sourceInfo.iFieldsByName.get(name).value();
                field.setPrevValue(curValue);
                field.setValue(newValue);
            }
        }
        return update;
    }

    public void setup() throws Exception {
        BufferedImage image = null;
        ImageFileInfo fileInfo = this.getFileInfo();
        if (fileInfo.getNumRows() == -1) {
            image = ImageIOUtil.load(this.picPathname());
            if (image == null) {
                Exception xcp = new Exception("Unable to read image");
                throw xcp;
            }
            fileInfo.setNumRows((short)image.getHeight(null));
            fileInfo.setNumCols((short)image.getWidth(null));
            File file = new File(this.picPathname());
            float size = (float)file.length() * 0.001f;
            fileInfo.setSizeKB((int)((double)size + 0.5));
        }
        this.setupThumb(image);
    }

    public boolean isHidden() {
        ComboField rating = this.iFieldsByName.get(RATINGFLDNAME);
        String value = rating.value().toString().toLowerCase();
        boolean hidden = value.indexOf(HIDDEN) >= 0;
        return hidden;
    }

    public void clearComboFields() {
        for (ComboField field : this.iFieldsByName.values()) {
            field.clear();
        }
    }

    public void clear() {
        this.clearComboFields();
        this.iPicPathname = NOSTRVALUE;
        this.iTags = null;
        this.iFileInfo = null;
    }

    public boolean needsExifUpdate() {
        return this.iUpdateExif;
    }

    public void setNeedsExifUpdate() {
        this.iUpdateExif = true;
    }

    public void resetThumb() {
        this.iThumbnail = Thumbnail.DefaultThumbnail;
    }

    public float resMp() {
        float mp = (float)(this.iFileInfo.getNumCols() * this.iFileInfo.getNumRows()) / 1000000.0f;
        return mp;
    }

    public void writeXML(MLogging logger, boolean includePicPath) {
        String indent = "\t";
        logger.writeln(String.valueOf(indent) + "<picture>", false);
        indent = String.valueOf(indent) + "\t";
        if (includePicPath) {
            PicInfo.writeXMLText(logger, "imagepath", this.iPicPathname, indent);
        }
        for (ComboField field : this.iFieldsByName.values()) {
            String xml = field.asXML();
            if (xml.length() <= 0) continue;
            logger.writeln(String.valueOf(indent) + xml, false);
        }
        PicInfo.writeXMLText(logger, NOTESFLDNAME, this.iNotes, indent);
        PicInfo.writeXMLInt(logger, "year", this.iYear, indent);
        PicInfo.writeXMLInt(logger, "month", this.iMonth, indent);
        PicInfo.writeXMLInt(logger, "day", this.iDay, indent);
        PicInfo.writeXMLInt(logger, "uncer", this.iUncer, indent);
        for (PersonGroup pg : this.iPersons) {
            String name = pg.getName();
            if (name == null) continue;
            PicInfo.writeXMLText(logger, "person", name, indent);
        }
        for (PicTag tag : this.iTags) {
            PicInfo.writeXMLText(logger, "tag", tag.getText(), indent);
        }
        indent = "\t";
        logger.writeln(String.valueOf(indent) + "</picture>", false);
    }

    @Override
    public Collection<String> toXML(String curIndent) {
        MLogger.List logger = new MLogger.List();
        this.writeXML(logger, true);
        return logger.lines();
    }

    public void setOrigPath(String path) {
        this.iOrigPath = path;
    }

    public String origPath() {
        if (this.iOrigPath == null) {
            this.iOrigPath = this.iPicPathname;
        }
        return this.iOrigPath;
    }

    public String toString() {
        String str = this.iObjNum + "," + this.iOrigObjNum + "," + this.iThumbObjNum + "," + this.iPicPathname + " has Date:" + this.iDateStr + SEP;
        str = String.valueOf(str) + this.comboFieldsStr();
        str = String.valueOf(str) + ", notes:" + this.notes();
        str = String.valueOf(str) + ", persons:";
        for (PersonGroup pg : this.iPersons) {
            str = String.valueOf(str) + "," + pg.getName();
        }
        return str;
    }

    public void addField(ComboField field) {
        this.iFieldsByName.put(field.name(), field);
    }

    public void resetFieldNames() {
        Set<Map.Entry<String, ComboField>> mappings = this.iFieldsByName.entrySet();
        for (Map.Entry<String, ComboField> entry : mappings) {
            ComboField field = entry.getValue();
            field.setName(entry.getKey());
        }
    }

    private void setupThumb(BufferedImage image) throws Exception {
        if (this.iThumbnail == null || this.iThumbnail == Thumbnail.DefaultThumbnail) {
            ThumbnailImage thumb = new ThumbnailImage();
            thumb.setImagePath(this.picPathname());
            BinnedDb.Path binPath = Database.singleton().infosDb().filePath(this.iThumbObjNum, ".jpg");
            boolean read = thumb.read(binPath.path());
            if (read) {
                this.iThumbnail = thumb;
            } else {
                try {
                    if (image == null) {
                        image = ImageIOUtil.load(this.picPathname());
                    }
                    this.buildThumb(thumb, image);
                }
                catch (Exception xcp) {
                    this.iThumbnail = Thumbnail.DefaultThumbnail;
                    MAppMsg msg = BpmMsgs.get("unable_build_thumb");
                    StatusBox.singleton().showMsg(msg.format(Utility.xcpMsg(xcp)), msg.isError());
                }
            }
        }
    }

    private void buildThumb(ThumbnailImage thumb, BufferedImage image) throws Exception {
        ProgPreferences pref = ProgPreferences.singleton();
        int thumbSize = pref.thumbnailSize();
        thumb.setup(image, thumbSize);
        this.iThumbnail = thumb;
        BinnedDb.Path path = Database.singleton().infosDb().filePath(this.iThumbObjNum, ".jpg");
        this.iThumbnail.write(path.path());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.setupDate();
    }

    public static class ComboField
    implements Serializable,
    Cloneable,
    Comparable<ComboField> {
        private int iPos = -1;
        private String iName = "";
        private String iValue = "";
        private String iPrevValue = "";
        private static final char FILLER = '-';
        private static final int SORTVALUELEN = 30;
        static final long serialVersionUID = -8221905483471874467L;

        public static String dbNameToName(String dbName) {
            String name = dbName.replace('-', ' ');
            return name;
        }

        public ComboField(String name, int screenPos) {
            this.iPos = screenPos;
            this.iName = name;
        }

        public String name() {
            return this.iName;
        }

        public String capName() {
            MString name = new MString(this.iName);
            return name.capFirstChar().toString();
        }

        public String fileName() {
            return this.iName.replace(' ', '-');
        }

        public String prevValue() {
            return this.iPrevValue;
        }

        public void setPrevValue(String value) {
            this.iPrevValue = value;
        }

        public int pos() {
            return this.iPos;
        }

        @Override
        public int compareTo(ComboField field) {
            int result = 0;
            if (field != this) {
                result = -1;
                if (field != null) {
                    result = this.iPos - field.iPos;
                }
            }
            return result;
        }

        public boolean equals(Object obj) {
            return this.compareTo((ComboField)obj) == 0;
        }

        public boolean equalInValue(ComboField field) {
            boolean result = false;
            if (field != null) {
                result = field.compareValue().equals(this.compareValue());
            }
            return result;
        }

        public int hashCode() {
            return this.iName.hashCode();
        }

        public String asXML() {
            String xml = PicInfo.NOSTRVALUE;
            if (this.iValue != null && this.iValue.length() > 0) {
                MString value = this.compareValue();
                xml = "<" + this.fileName() + "> " + value.toString() + " </" + this.fileName() + ">";
            }
            return xml;
        }

        public Object clone() {
            ComboField clone = null;
            try {
                clone = (ComboField)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return clone;
        }

        public void clear() {
            this.iValue = PicInfo.NOSTRVALUE;
            this.iPrevValue = PicInfo.NOSTRVALUE;
        }

        public void setValue(String value) {
            this.iPrevValue = this.iValue;
            this.iValue = value.length() <= 0 ? PicInfo.NOSTRVALUE : value.trim();
        }

        public String value() {
            return this.iValue;
        }

        public MString mValue() {
            return new MString(this.iValue);
        }

        public MString compareValue() {
            MString value = this.mValue();
            if (!value.equals(PicInfo.NOSTRVALUE)) {
                int index = value.indexOf('^');
                if (index > 0) {
                    try {
                        value = value.substring(0, index - 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (value.charAt(0) == '#') {
                    value.trimHead('#');
                }
            }
            return value.trimWhitespace();
        }

        public MString sortValue() {
            MString value = this.mValue();
            if (!value.equals(PicInfo.NOSTRVALUE)) {
                int index;
                if (value.charAt(0) == '#') {
                    value.trimHead('#');
                }
                if ((index = value.indexOf('^')) >= 0) {
                    try {
                        value = value.substring(0, index - 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            value.trimWhitespace();
            while (value.length() < 30) {
                value.concat('-');
            }
            if (value.length() > 30) {
                value.compress(30);
            }
            return value.toLowerCase();
        }

        public MString webDisplayValue() {
            MString value = this.mValue();
            if (!value.equals(PicInfo.NOSTRVALUE)) {
                if (value.charAt(0) == '#') {
                    value.clear();
                } else {
                    value.remove('^', 1, 0);
                }
            }
            return value.trimWhitespace();
        }

        public MString webLabelValue() {
            MString value = this.mValue();
            int index = value.indexOf(',');
            if (index >= 0) {
                try {
                    value = value.substring(0, index - 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!value.equals(PicInfo.NOSTRVALUE)) {
                if (value.charAt(0) == '#') {
                    value.clear();
                } else {
                    index = value.indexOf('^');
                    if (index >= 0) {
                        try {
                            value = value.substring(0, index - 1);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            return value.trimWhitespace();
        }

        public MString printValue() {
            return this.compareValue();
        }

        public String toString() {
            String str = String.valueOf(this.iName) + "," + this.iPos + "," + this.iValue + "," + this.iPrevValue;
            return str;
        }

        void setPos(int pos) {
            this.iPos = pos;
        }

        void setName(String name) {
            this.iName = name;
        }
    }

    public static class DateComparator
    implements Comparator<PicInfo> {
        static final long serialVersionUID = -2187191358190056221L;
        private boolean iReverse = false;

        public DateComparator() {
        }

        public DateComparator(boolean reverse) {
            this.iReverse = reverse;
        }

        @Override
        public int compare(PicInfo info1, PicInfo info2) {
            int result = -1;
            if (info1 != null && info2 != null) {
                MString str1 = new MString(100);
                str1.concat(info1.dateSortStr());
                str1.concat(info1.comboField(PicInfo.TOWNFLDNAME).sortValue());
                str1.concat(info1.comboField(PicInfo.LOCATIONFLDNAME).sortValue());
                MString str2 = new MString(100);
                str2.concat(info2.dateSortStr());
                str2.concat(info2.comboField(PicInfo.TOWNFLDNAME).sortValue());
                str2.concat(info2.comboField(PicInfo.LOCATIONFLDNAME).sortValue());
                result = this.iReverse ? str2.compareTo(str1) : str1.compareTo(str2);
                if (result == 0) {
                    result = -1;
                }
            }
            return result;
        }
    }

    public static class GroupComparator
    implements Comparator<PicInfo> {
        @Override
        public int compare(PicInfo info1, PicInfo info2) {
            int result = -1;
            if (info1 != null && info2 != null) {
                MString str1 = new MString(100);
                str1.concat(info1.comboField(PicInfo.GROUPFLDNAME).sortValue());
                str1.concat(info1.dateSortStr());
                MString str2 = new MString(100);
                str2.concat(info2.comboField(PicInfo.GROUPFLDNAME).sortValue());
                str2.concat(info2.dateSortStr());
                result = str1.compareTo(str2);
                if (result == 0) {
                    result = -1;
                }
            }
            return result;
        }
    }

    public static class IdComparator
    implements Comparator<PicInfo>,
    Serializable {
        @Override
        public int compare(PicInfo info1, PicInfo info2) {
            MString str2;
            MString str1;
            int result = -1;
            if (info1 != null && info2 != null && (result = (str1 = info1.comboField(PicInfo.IDENTIFIERFLDNAME).sortValue()).compareTo(str2 = info2.comboField(PicInfo.IDENTIFIERFLDNAME).sortValue())) == 0) {
                result = -1;
            }
            return result;
        }
    }

    public static class ImageComparator
    implements Comparator<PicInfo>,
    Serializable {
        static final long serialVersionUID = 3637430348648163640L;

        @Override
        public int compare(PicInfo info1, PicInfo info2) {
            int result = -1;
            if (info1 != null && info2 != null) {
                String str1 = info1.picPathname();
                String str2 = info2.picPathname();
                result = str1.compareTo(str2);
            }
            return result;
        }
    }

    public static class NumPixComparator
    implements Comparator<PicInfo>,
    Serializable {
        @Override
        public int compare(PicInfo info1, PicInfo info2) {
            int result = -1;
            if (info1 != null && info2 != null && (result = info1.getFileInfo().numPixels() - info2.getFileInfo().numPixels()) == 0) {
                result = -1;
            }
            return result;
        }
    }

    public static class PicNumComparator
    implements Comparator<PicInfo> {
        @Override
        public int compare(PicInfo info1, PicInfo info2) {
            int result = -1;
            if (info1 != null && info2 != null && (result = info1.id() - info2.id()) == 0) {
                result = -1;
            }
            return result;
        }
    }

    public static class RegionComparator
    implements Comparator<PicInfo> {
        static final long serialVersionUID = 3381305470392450097L;

        @Override
        public int compare(PicInfo info1, PicInfo info2) {
            int result = -1;
            if (info1 != null && info2 != null) {
                MString str1 = new MString(100);
                str1.concat(info1.comboField(PicInfo.COUNTRYFLDNAME).sortValue());
                str1.concat(info1.comboField(PicInfo.REGIONFLDNAME).sortValue());
                str1.concat(info1.comboField(PicInfo.TOWNFLDNAME).sortValue());
                str1.concat(info1.comboField(PicInfo.LOCATIONFLDNAME).sortValue());
                str1.concat(info1.comboField(PicInfo.PLACEFLDNAME).sortValue());
                str1.concat(info1.dateSortStr());
                str1.concat(info1.comboField(PicInfo.IDENTIFIERFLDNAME).sortValue());
                MString str2 = new MString(100);
                str2.concat(info1.comboField(PicInfo.COUNTRYFLDNAME).sortValue());
                str2.concat(info2.comboField(PicInfo.REGIONFLDNAME).sortValue());
                str2.concat(info2.comboField(PicInfo.TOWNFLDNAME).sortValue());
                str2.concat(info2.comboField(PicInfo.LOCATIONFLDNAME).sortValue());
                str2.concat(info2.comboField(PicInfo.PLACEFLDNAME).sortValue());
                str2.concat(info2.dateSortStr());
                str2.concat(info2.comboField(PicInfo.IDENTIFIERFLDNAME).sortValue());
                result = str1.compareTo(str2);
                if (result == 0) {
                    result = -1;
                }
            }
            return result;
        }
    }
}

