/*
 * Decompiled with CFR 0.152.
 */
package oroma.db;

import com.drew.imaging.ImageMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import mlib.MString;
import oroma.db.PicInfo;
import swing.DatePanel;

public class ExifTags
implements Serializable,
Cloneable {
    private TreeMap<String, Pair> iTags = new TreeMap();
    public static final String BPMEXIFTAG = "Unknown tag (0x84e0)";
    private static final String MODEL = "Model";
    private static final String FNUMBER = "F-Number";
    private static final String DATETIME = "Date/Time Original";
    private static final String SHUTTER = "Shutter Speed Value";
    private static final String FLASH = "Flash";
    private static final String FOCALLEN = "Focal Length";
    private static final String ISO = "ISO Speed Ratings";
    private static final String MAKE = "Make";
    private static final String DELIM = ", ";
    private static final int MAXEXIFLEN = 500;
    private static final String[] MONTHS = new String[]{"", "Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final long serialVersionUID = -4650455153510479609L;

    public static ExifTags read(PicInfo info, boolean reread) throws Exception {
        if (reread || info.exifTags() == null) {
            ExifTags tags = new ExifTags();
            try {
                File file = new File(info.picPathname());
                Metadata metadata = ImageMetadataReader.readMetadata((File)file);
                Iterable dirs = metadata.getDirectories();
                for (Directory dir : dirs) {
                    Collection theTags = dir.getTags();
                    for (Tag tag : theTags) {
                        CharSequence desc;
                        boolean skip = tag.getDescription().endsWith("values]");
                        if (!skip) {
                            desc = tag.getDescription();
                            int index = ((String)desc).indexOf("<picture>");
                            boolean bl = skip = tag.getDescription().length() > 500 && index < 0;
                        }
                        if (skip) continue;
                        desc = new MString(tag.getDescription());
                        if (((MString)desc).endsWith(" sec")) {
                            ((MString)desc).replace(" sec", "s");
                        } else if (((MString)desc).endsWith(" mm")) {
                            ((MString)desc).replace(" mm", "mm");
                        }
                        Pair exifTag = new Pair(tag.getTagName(), tag.getDescription());
                        tags.iTags.put(exifTag.getName(), exifTag);
                    }
                }
                tags.setup(info);
                info.setExifTags(tags);
            }
            catch (Exception xcp) {
                info.setExifTags(new ExifTags());
                throw xcp;
            }
        }
        return info.exifTags();
    }

    private static int timeToHour(String time) {
        int hour = -1;
        StringTokenizer tken = new StringTokenizer(time, ":");
        if (tken.countTokens() >= 2) {
            hour = Integer.parseInt(tken.nextToken());
            int min = Integer.parseInt(tken.nextToken());
            if (min >= 30) {
                ++hour;
            }
        }
        return hour;
    }

    private static void doDateTime(Pair dateTimeTag, PicInfo info) {
        int year;
        String date;
        StringTokenizer tken1;
        String str;
        StringTokenizer tken = new StringTokenizer(dateTimeTag.getValue(), " ");
        if (tken.hasMoreTokens() && (str = (tken1 = new StringTokenizer(date = tken.nextToken(), ":")).nextToken()) != null && (year = Integer.parseInt(str)) > 0) {
            String month;
            int monthVal;
            info.setYear(year);
            str = tken1.nextToken();
            if (str != null && (monthVal = DatePanel.month(month = MONTHS[Integer.parseInt(str)])) > 0) {
                int day;
                info.setMonth(monthVal);
                str = tken1.nextToken();
                if (str != null && (day = Integer.parseInt(str)) > 0) {
                    String time;
                    info.setDay(day);
                    if (tken.hasMoreTokens() && (time = tken.nextToken()) != null) {
                        info.setHour(ExifTags.timeToHour(time));
                    }
                }
            }
        }
    }

    public int count() {
        return this.iTags.values().size();
    }

    public Collection<Pair> allTags() {
        return this.iTags.values();
    }

    public Pair getTag(String name) {
        return this.iTags.get(name);
    }

    public void addTag(Pair pair) {
        this.iTags.put(pair.getName(), pair);
    }

    public Object clone() {
        ExifTags clone = null;
        try {
            clone = (ExifTags)super.clone();
            clone.iTags = new TreeMap();
            Set<Map.Entry<String, Pair>> mappings = this.iTags.entrySet();
            for (Map.Entry<String, Pair> entry : mappings) {
                Pair pair = entry.getValue();
                clone.iTags.put(entry.getKey(), (Pair)pair.clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public String toString() {
        String str = "";
        for (Pair tag : this.iTags.values()) {
            str = String.valueOf(str) + tag.toString() + "|";
        }
        return str;
    }

    private void setup(PicInfo info) {
        if (this.count() > 0) {
            this.doTechnique(info);
            Pair tag = this.iTags.get(DATETIME);
            if (tag != null) {
                ExifTags.doDateTime(tag, info);
            }
            if ((tag = this.iTags.get(MODEL)) != null) {
                Pair makeTag = this.iTags.get(MAKE);
                if (makeTag == null) {
                    info.comboField("camera").setValue(tag.getValue());
                } else {
                    boolean skip;
                    boolean bl = skip = makeTag.getValue().equalsIgnoreCase("PIE") || makeTag.getValue().equalsIgnoreCase("Epson");
                    if (!skip) {
                        info.comboField("camera").setValue(tag.getValue());
                    }
                }
            }
        }
    }

    private void doTechnique(PicInfo info) {
        String tech = "";
        Pair tag = this.iTags.get(FNUMBER);
        if (tag != null && tag.getValue().length() > 0) {
            tech = String.valueOf(tech) + tag.getValue();
        }
        if ((tag = this.iTags.get(SHUTTER)) != null && tag.getValue().length() > 0) {
            if (tech.length() > 0) {
                tech = String.valueOf(tech) + DELIM;
            }
            tech = String.valueOf(tech) + tag.getValue();
        }
        if ((tag = this.iTags.get(FLASH)) != null && tag.getValue().length() > 0) {
            if (tech.length() > 0) {
                tech = String.valueOf(tech) + DELIM;
            }
            tech = tag.getValue().indexOf("no") >= 0 ? String.valueOf(tech) + "no flash" : String.valueOf(tech) + "flash";
        }
        if ((tag = this.iTags.get(ISO)) != null && tag.getValue().length() > 0) {
            if (tech.length() > 0) {
                tech = String.valueOf(tech) + DELIM;
            }
            tech = String.valueOf(tech) + "ISO" + tag.getValue();
        }
        if ((tag = this.iTags.get(FOCALLEN)) != null && tag.getValue().length() > 0) {
            if (tech.length() > 0) {
                tech = String.valueOf(tech) + DELIM;
            }
            tech = String.valueOf(tech) + tag.getValue();
        }
        info.comboField("technique").setValue(tech);
    }

    private ExifTags() {
    }

    public static class Pair
    implements Comparable<Pair>,
    Serializable {
        private String iName = null;
        private String iValue = null;
        private static final long serialVersionUID = 5129276073254961488L;

        public Pair(String name, String value) {
            this.iName = name.trim();
            this.iValue = value.trim();
        }

        public String getName() {
            return this.iName;
        }

        public String getValue() {
            return this.iValue;
        }

        @Override
        public int compareTo(Pair tag) {
            int result = 0;
            if (tag != this) {
                result = -1;
                if (tag != null && (result = this.iName.compareToIgnoreCase(tag.iName)) == 0) {
                    result = this.iValue.compareToIgnoreCase(tag.iValue);
                }
            }
            return result;
        }

        public boolean equals(Object obj) {
            return this.compareTo((Pair)obj) == 0;
        }

        public int hashCode() {
            return (String.valueOf(this.iName) + this.iValue).hashCode();
        }

        public Object clone() {
            Pair clone = null;
            try {
                clone = (Pair)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return clone;
        }

        public String toString() {
            return String.valueOf(this.iName) + "=" + this.iValue;
        }
    }
}

