/*
 * Decompiled with CFR 0.152.
 */
package oroma.albumsgui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import mlib.MAppMsg;
import mlib.MString;
import mswing.WheelComboBoxDb;
import oroma.albumsgui.CategorySelectionBox;
import oroma.db.Database;
import oroma.db.PersonGroup;
import oroma.db.PicInfo;
import oroma.db.ProgPreferences;
import oroma.db.Query;
import oroma.gui.BpmMsgs;
import swing.ColorPanel;
import swing.DatePanel;
import swing.EntryField;
import swing.PanelLabel;
import swing.SwingProgram;
import swing.WheelComboBox;

public class QueryPanel
extends JPanel {
    private Prompts iPrompts = new Prompts();
    private Fields iFields = new Fields();

    public QueryPanel() {
        this.setBackground(ProgPreferences.singleton().dialogColor());
        this.setLayout(new BorderLayout());
        this.add((Component)this.iPrompts, "West");
        this.add((Component)this.iFields, "Center");
        this.add((Component)this.iFields.datePanel(), "South");
        this.setEnabled(true);
        this.setBorder(SwingProgram.STDBORDER);
    }

    public Query query() {
        return this.iFields.query();
    }

    public Component focusComp() {
        return this.iFields.focusComp();
    }

    public void putQuery(boolean enabled, Query query) {
        this.iFields.setQuery(enabled, query);
    }

    public String testIfValid() {
        return this.iFields.testIfValid();
    }

    private class Fields
    extends JPanel {
        private Query iQuery = new Query();
        private TreeMap<String, WheelComboBox> iComboBoxes = new TreeMap();
        private EntryField iNameField = new EntryField();
        private EntryField iDescField = new EntryField();
        private WheelComboBox iCategoryBox = null;
        private EntryField iExifField = new EntryField();
        private DatePanel iDatePanel = new DatePanel(false, true);
        private WheelComboBox iPersonBox = null;
        private WheelComboBox iOrderBox = null;
        private WheelComboBox iAspectBox = null;

        public Fields() {
            this.setLayout(new GridLayout(0, 1));
            ProgPreferences pref = ProgPreferences.singleton();
            this.setBackground(pref.dialogColor());
            this.add(this.iNameField);
            this.add(this.iDescField);
            this.add(this.getCategoryBox());
            for (String fieldName : pref.dispFields()) {
                WheelComboBox box = new WheelComboBox();
                box.setEditable(true);
                WheelComboBoxDb db = Database.singleton().comboDb(fieldName);
                box.setDb(db, true);
                this.add(box);
                this.iComboBoxes.put(fieldName, box);
            }
            this.add(this.getPersonBox());
            ColorPanel botPanel = new ColorPanel();
            botPanel.setBackground(ProgPreferences.singleton().dialogColor());
            botPanel.setLayout(new BoxLayout(botPanel, 0));
            botPanel.add(this.iExifField);
            botPanel.add(new PanelLabel("Aspect", ':'));
            botPanel.add(this.getAspectBox());
            botPanel.add(new PanelLabel("Order", ':'));
            botPanel.add(this.getOrderBox());
            this.add(botPanel);
        }

        public Query query() {
            this.iQuery.setName(this.iNameField.getText().trim());
            this.iQuery.setDesc(this.iDescField.getText().trim());
            this.iQuery.setExif(this.iExifField.getText().trim());
            this.iQuery.setCategory((String)this.iCategoryBox.getSelectedItem());
            if (this.iQuery.category() == null) {
                this.iQuery.setCategory("*");
            }
            this.iQuery.setOrdering((String)this.iOrderBox.getSelectedItem());
            this.iQuery.setAspect((String)this.iAspectBox.getSelectedItem());
            PersonGroup person = new PersonGroup((String)this.iPersonBox.getSelectedItem());
            this.iQuery.setPerson(person);
            PicInfo info = this.iQuery.picInfo();
            Set<Map.Entry<String, WheelComboBox>> mappings = this.iComboBoxes.entrySet();
            for (Map.Entry<String, WheelComboBox> entry : mappings) {
                PicInfo.ComboField field = info.comboField(entry.getKey());
                String value = ((String)entry.getValue().getSelectedItem()).trim();
                field.setValue(value);
            }
            info.setYear(this.iDatePanel.obtainYear());
            info.setUncer(this.iDatePanel.obtainUncer());
            info.setMonth(this.iDatePanel.obtainMonth());
            info.setDay(this.iDatePanel.obtainDay());
            info.setHour(this.iDatePanel.obtainHour());
            return this.iQuery;
        }

        public Component focusComp() {
            return this.iNameField;
        }

        public DatePanel datePanel() {
            return this.iDatePanel;
        }

        public void setQuery(boolean enabled, Query query) {
            this.iQuery = query;
            this.iNameField.setText(this.iQuery.name());
            this.iNameField.setEnabled(enabled);
            this.iDescField.setText(this.iQuery.desc());
            this.iExifField.setText(this.iQuery.exif());
            this.iCategoryBox.setEnabled(true);
            CategorySelectionBox.singleton().enabled(false);
            this.iCategoryBox.setSelectedItem(query.category());
            CategorySelectionBox.singleton().enabled(true);
            PicInfo info = this.iQuery.picInfo();
            Set<Map.Entry<String, WheelComboBox>> mappings = this.iComboBoxes.entrySet();
            for (Map.Entry<String, WheelComboBox> entry : mappings) {
                PicInfo.ComboField field = query.picInfo().comboField(entry.getKey());
                entry.getValue().setSelectedItem(field.value());
            }
            this.iOrderBox.setSelectedItem(query.ordering());
            this.iAspectBox.setSelectedItem(query.aspect());
            this.iPersonBox.setSelectedItem(query.personGroup().getName());
            this.iDatePanel.putYear(info.year());
            this.iDatePanel.putUncer(info.uncer());
            this.iDatePanel.setEnabled(enabled);
            this.iDatePanel.putMonth(info.month());
            this.iDatePanel.putDay(info.day());
            this.iDatePanel.putHour(info.hour());
            this.iDatePanel.setEnabled(enabled);
        }

        public String testIfValid() {
            StringTokenizer tken;
            MAppMsg msg;
            String result = null;
            if (this.iNameField.getText().length() == 0) {
                msg = BpmMsgs.get("album_name_blank");
                result = msg.format();
            } else if (this.iNameField.getText().equals("Orphans")) {
                msg = BpmMsgs.get("no_orphan_album");
                result = msg.format();
            } else {
                result = this.iDatePanel.testIfValid();
            }
            if (result == null && this.iExifField.getText().length() > 0 && (tken = new StringTokenizer(this.iExifField.getText(), "=")).countTokens() != 2) {
                MAppMsg msg2 = BpmMsgs.get("exif_format");
                result = msg2.format();
            }
            return result;
        }

        private WheelComboBox getCategoryBox() {
            this.iCategoryBox = new WheelComboBox();
            this.iCategoryBox.setEditable(true);
            WheelComboBoxDb db = Database.singleton().comboDb("category");
            this.iCategoryBox.setDb(db, false);
            return this.iCategoryBox;
        }

        private WheelComboBox getPersonBox() {
            this.iPersonBox = new WheelComboBox();
            this.iPersonBox.setEditable(true);
            WheelComboBoxDb db = Database.singleton().comboDb("persons");
            this.iPersonBox.setDb(db, true);
            return this.iPersonBox;
        }

        private WheelComboBox getOrderBox() {
            this.iOrderBox = new WheelComboBox();
            Object[] options = new String[]{"By date", "By region", "By group", "By id", "By pixels", "By number"};
            this.iOrderBox.setItems(options);
            this.iOrderBox.setEditable(false);
            this.iOrderBox.setWheelEnabled(true);
            this.iOrderBox.setKeepOrder(true);
            return this.iOrderBox;
        }

        private WheelComboBox getAspectBox() {
            this.iAspectBox = new WheelComboBox();
            Object[] options = new String[]{"Any", "Portrait", "Landscape", "Square"};
            this.iAspectBox.setItems(options);
            this.iAspectBox.setEditable(false);
            this.iAspectBox.setWheelEnabled(true);
            this.iAspectBox.setKeepOrder(true);
            return this.iAspectBox;
        }
    }

    private class Prompts
    extends JPanel {
        public Prompts() {
            this.setLayout(new GridLayout(0, 1));
            ProgPreferences pref = ProgPreferences.singleton();
            this.setBackground(pref.dialogColor());
            this.add(new PanelLabel("Name", ':'));
            this.add(new PanelLabel("Description", ':'));
            this.add(new PanelLabel("Category", ':'));
            for (String fieldName : pref.dispFields()) {
                MString work = new MString(fieldName);
                work.capFirstChar();
                this.add(new PanelLabel(work.toString(), ':'));
            }
            this.add(new PanelLabel("Person", ':'));
            this.add(new PanelLabel("EXIF", ':'));
        }
    }
}

