/*
 * Decompiled with CFR 0.152.
 */
package oroma.albumsgui;

import java.awt.Cursor;
import java.util.Collection;
import mlib.MAppMsg;
import oroma.albumgui.AlbumFiller;
import oroma.albumgui.AlbumPanel;
import oroma.albumsgui.AlbumsPanel;
import oroma.albumsgui.DbInfoLabel;
import oroma.db.Database;
import oroma.db.PicInfo;
import oroma.db.Query;
import oroma.gui.BpmMsgs;
import swing.StatusBox;
import utilt.Utility;

public class OrphanAnalyzer
extends Thread {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Database db;
        Database database = db = Database.singleton();
        synchronized (database) {
            block10: {
                try {
                    try {
                        MAppMsg msg = BpmMsgs.get("finding_orphans");
                        StatusBox.singleton().queueShowMsg(msg.format(), msg.isError());
                        AlbumPanel.singleton().setCursor(Cursor.getPredefinedCursor(3));
                        db.deleteQuery(9999, true);
                        AlbumsPanel.singleton().showAlbums(false);
                        Collection<PicInfo> orphans = Database.singleton().findOrphanPics();
                        if (orphans.size() > 0) {
                            for (PicInfo picInfo : orphans) {
                                picInfo.comboField("topic").setValue("Orphan");
                                db.putPic(picInfo, true);
                            }
                            Query query = OrphanAnalyzer.createAlbum(db);
                            AlbumPanel panel = AlbumPanel.singleton();
                            panel.addAlbumSelection(query.name());
                            AlbumFiller.startNew(query);
                            AlbumsPanel.singleton().showAlbums(false);
                            DbInfoLabel.singleton().show();
                        }
                        msg = BpmMsgs.get("found_orphans");
                        StatusBox.singleton().queueShowMsg(msg.format("" + orphans.size()), msg.isError());
                    }
                    catch (Exception xcp) {
                        MAppMsg msg = BpmMsgs.get("unable_create_orphans");
                        StatusBox.singleton().queueShowMsg(msg.format(Utility.xcpMsg(xcp)), msg.isError());
                        AlbumPanel.singleton().setCursor(Cursor.getDefaultCursor());
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    AlbumPanel.singleton().setCursor(Cursor.getDefaultCursor());
                    throw throwable;
                }
                AlbumPanel.singleton().setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private static Query createAlbum(Database db) throws Exception {
        Query query = new Query(9999);
        query.setName("Orphans");
        PicInfo picInfo = query.picInfo();
        picInfo.comboField("topic").setValue("Orphan");
        db.putQuery(query, true);
        return query;
    }
}

