/*
 * Decompiled with CFR 0.152.
 */
package oroma.albumgui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.util.Collection;
import java.util.LinkedList;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.ImageIcon;
import mlib.MString;
import oroma.albumgui.PicturePanel;
import oroma.db.PersonGroup;
import oroma.db.PicInfo;
import swing.StatusBox;
import utilt.ImageIOUtil;

public class ImagePrinter
extends Thread {
    private int iInfoSizePc = 0;
    private Collection<PicInfo> iPicInfos = new LinkedList<PicInfo>();
    private double iYOffset = 0.0;
    private HashPrintRequestAttributeSet iAttrs = new HashPrintRequestAttributeSet();
    private static final Font ANNOTFONT = new Font("Dialog", 1, 10);
    private static final double LAND_ROTATE = -1.57;
    private static final int SPACING = 15;
    private static final String PERSONINDENT = "   ";

    public ImagePrinter(Collection<PicInfo> picInfos, int infoSizePc) {
        this.iPicInfos = picInfos;
        this.iInfoSizePc = infoSizePc;
    }

    @Override
    public void run() {
        PrinterJob job = PrinterJob.getPrinterJob();
        if (job.printDialog(this.iAttrs)) {
            PicturePanel.singleton().repaint();
            int numPics = this.iPicInfos.size();
            int picNum = 1;
            for (PicInfo info : this.iPicInfos) {
                try {
                    String msg;
                    String devPath = info.picPathname();
                    BufferedImage image = ImageIOUtil.load(devPath);
                    if (image == null) {
                        msg = "Unable to load photo file " + devPath;
                        StatusBox.singleton().queueShowMsg(msg, true);
                    } else {
                        job.setPrintable(new Printer(image, info));
                        msg = "Printing photo " + picNum + " of " + numPics;
                        StatusBox.singleton().queueShowMsg(msg, false);
                        job.print();
                        ++picNum;
                    }
                }
                catch (Exception xcp) {
                    StatusBox.singleton().queueShowMsg("Unable to print image", true);
                }
                job = PrinterJob.getPrinterJob();
            }
            StatusBox.singleton().queueShowMsg("Printed " + --picNum + " of " + numPics + " photos", false);
        }
    }

    private class Printer
    implements Printable {
        private Image iImage = null;
        private PicInfo iPicInfo = null;
        private double iImgWidth = 0.0;
        private double iImgHeight = 0.0;
        private double iX = 0.0;
        private double iY = 0.0;
        private Image iScaled = null;

        public Printer(Image image, PicInfo info) {
            this.iImage = image;
            this.iPicInfo = info;
        }

        @Override
        public int print(Graphics g, PageFormat format, int page) {
            int status = 1;
            if (page == 0) {
                boolean lscape = true;
                Graphics2D g2 = (Graphics2D)g;
                AffineTransform trans = null;
                if (this.iImage.getWidth(null) < this.iImage.getHeight(null)) {
                    this.calcPortrait(format);
                    trans = AffineTransform.getTranslateInstance(format.getImageableX() + this.iX, format.getImageableY() + this.iY);
                    lscape = false;
                } else {
                    double frac;
                    double fracNeeded = this.landFracNeeded(g2, format);
                    if (fracNeeded < (frac = (double)ImagePrinter.this.iInfoSizePc * 0.01)) {
                        frac = fracNeeded;
                    }
                    this.calcLandscape(format, frac);
                    trans = AffineTransform.getTranslateInstance(format.getImageableX() + this.iY, format.getImageableY() + ImagePrinter.this.iYOffset + this.iX);
                    trans.concatenate(AffineTransform.getRotateInstance(-1.57));
                }
                if (this.iScaled == null) {
                    this.iScaled = this.iImage.getScaledInstance((int)this.iImgWidth, (int)this.iImgHeight, 16);
                    ImageIcon fracNeeded = new ImageIcon(this.iScaled);
                }
                g2.drawImage(this.iScaled, trans, null);
                Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, this.iImgWidth, this.iImgHeight);
                g2.setPaint(Color.black);
                g2.transform(trans);
                g2.draw(rect);
                if (ImagePrinter.this.iInfoSizePc > 0) {
                    g2.setFont(ANNOTFONT);
                    if (lscape) {
                        this.printLandAnnot(g2);
                    } else {
                        this.printPortAnnot(g2);
                    }
                }
                status = 0;
            }
            return status;
        }

        private double landFracNeeded(Graphics2D g2, PageFormat format) {
            FontRenderContext context = g2.getFontRenderContext();
            double maxSize = 0.0;
            PicInfo.ComboField[] fields = PicInfo.comboFieldsByPos();
            int i = 0;
            while (i < PicInfo.COMBOBOXFLDS.length) {
                MString name = new MString(fields[i].name());
                name.capFirstChar();
                String str = name + ": " + fields[i].value();
                Rectangle2D bounds = ANNOTFONT.getStringBounds(str, context);
                if (bounds.getWidth() > maxSize) {
                    maxSize = bounds.getWidth();
                }
                ++i;
            }
            for (PersonGroup person : this.iPicInfo.persons()) {
                String str = ImagePrinter.PERSONINDENT + person.getName();
                Rectangle2D bounds = ANNOTFONT.getStringBounds(str, context);
                if (!(bounds.getWidth() > maxSize)) continue;
                maxSize = bounds.getWidth();
            }
            double frac = (maxSize += 30.0) / format.getImageableHeight();
            return frac;
        }

        private void calcPortrait(PageFormat format) {
            this.iImgHeight = this.iImage.getHeight(null);
            this.iImgWidth = this.iImage.getWidth(null);
            double printWidth = format.getImageableWidth();
            double printHeight = format.getImageableHeight();
            if (ImagePrinter.this.iInfoSizePc > 0) {
                printHeight *= 1.0 - (double)ImagePrinter.this.iInfoSizePc * 0.01;
            }
            this.scale(printWidth, printHeight);
            if (this.iImgWidth < printWidth) {
                this.iX = 0.0;
            }
            if (this.iImgHeight < printHeight) {
                this.iY = (printHeight - this.iImgHeight) * 0.5;
            }
        }

        private void scale(double printWidth, double printHeight) {
            double factor;
            if (this.iImgHeight > printHeight) {
                factor = printHeight / this.iImgHeight;
                this.iImgHeight *= factor;
                this.iImgWidth *= factor;
            }
            if (this.iImgWidth > printWidth) {
                factor = printWidth / this.iImgWidth;
                this.iImgHeight *= factor;
                this.iImgWidth *= factor;
            }
        }

        private void calcLandscape(PageFormat format, double annotFrac) {
            this.iImgHeight = this.iImage.getHeight(null);
            this.iImgWidth = this.iImage.getWidth(null);
            double printWidth = format.getImageableHeight();
            if (ImagePrinter.this.iInfoSizePc > 0) {
                printWidth *= 1.0 - annotFrac;
            }
            double printHeight = format.getImageableWidth();
            this.scale(printWidth, printHeight);
            printWidth = this.iImgWidth + format.getImageableHeight() * annotFrac;
            this.iX = (format.getImageableHeight() - printWidth) * 0.5;
            this.iY = (printHeight - this.iImgHeight) * 0.5;
            ImagePrinter.this.iYOffset = printWidth;
        }

        private void printLandAnnot(Graphics2D g2) {
            int x = (int)this.iImgWidth + 15;
            int ySpacing = (int)(1.5 * (double)ANNOTFONT.getSize());
            int y = 0;
            y = this.printBasic(g2, x, y, ySpacing, 999);
            this.printPersons(g2, x, y, ySpacing);
        }

        private int printBasic(Graphics2D g2, int x, int y, int ySpacing, int maxChars) {
            int yPos = y;
            PicInfo.ComboField[] fields = this.iPicInfo.comboFields();
            int i = 0;
            while (i < PicInfo.COMBOBOXFLDS.length) {
                MString name = new MString();
                name.capFirstChar();
                MString str = new MString(name + fields[i].value().toString());
                str.compress(maxChars);
                g2.drawString(str.toString(), x, yPos += ySpacing);
                ++i;
            }
            MString str = new MString(this.iPicInfo.fileName());
            str.compress(maxChars);
            g2.drawString(str.toString(), x, yPos += ySpacing);
            return yPos;
        }

        private void printPersons(Graphics2D g2, int x, int y, int ySpacing) {
            int yPos = y;
            LinkedList<PersonGroup> persons = this.iPicInfo.persons();
            boolean firstPerson = true;
            for (PersonGroup person : persons) {
                if (person.getName().length() <= 1) continue;
                if (firstPerson) {
                    g2.drawString("Persons:", x, yPos += ySpacing);
                    firstPerson = false;
                }
                g2.drawString(ImagePrinter.PERSONINDENT + person.getName(), x, yPos += ySpacing);
            }
        }

        private void printPortAnnot(Graphics2D g2) {
            int x = 0;
            int ySpacing = (int)(1.5 * (double)ANNOTFONT.getSize());
            int yStart = (int)(this.iImgHeight + (double)ANNOTFONT.getSize());
            int colWidth = (int)(this.iImgWidth * 0.5);
            FontRenderContext context = g2.getFontRenderContext();
            String str = "0123456789";
            Rectangle2D bounds = ANNOTFONT.getStringBounds(str, context);
            double scale = (double)str.length() / bounds.getWidth();
            int maxChars = (int)((double)colWidth * scale);
            this.printBasic(g2, x, yStart, ySpacing, maxChars);
            this.printPersons(g2, colWidth, yStart, ySpacing);
        }
    }
}

