/*
 * Decompiled with CFR 0.152.
 */
package oroma.albumgui;

import dialog.CenteredDialog;
import dialog.DialogEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import oroma.db.ExifTags;
import oroma.db.PicInfo;
import oroma.db.ProgPreferences;
import swing.PanelLabel;
import swing.StdScrollPane;
import swing.SwingProgram;

public class ExifInfoDialog
extends CenteredDialog {
    public static float horzFrac() {
        return 0.75f;
    }

    public static float vertFrac() {
        return 0.75f;
    }

    public ExifInfoDialog(Frame owner, PicInfo picInfo) {
        super(owner, true);
        Collection<ExifTags.Pair> work = picInfo.exifTags().allTags();
        LinkedList<ExifTags.Pair> tags = new LinkedList<ExifTags.Pair>();
        for (ExifTags.Pair tag : work) {
            if (tag.getName().equals("Unknown tag (0x84e0)")) continue;
            tags.add(tag);
        }
        ExifInfoPanel panel = new ExifInfoPanel(tags);
        this.buttons().removeCancelButton();
        this.setFont(ProgPreferences.singleton().menuFont());
        this.addClientPanel(new StdScrollPane(panel));
        this.setFocusComp(panel);
        this.putAcceptLabel("Close", 'C');
    }

    @Override
    public void accept(DialogEvent event) {
        this.dispose();
    }

    @Override
    public void cancel(DialogEvent event) {
        this.dispose();
    }

    @Override
    public void custom(int index, DialogEvent event) {
    }

    private class ExifInfoPanel
    extends JPanel {
        public ExifInfoPanel(Collection<ExifTags.Pair> tags) {
            this.setLayout(new BorderLayout());
            this.add((Component)new ExifNames(tags), "West");
            this.add((Component)new ExifValues(tags), "Center");
        }

        private class ExifNames
        extends JPanel {
            public ExifNames(Collection<ExifTags.Pair> tags) {
                this.setBorder(SwingProgram.STDBORDER);
                this.setBackground(SwingProgram.DIALOGBACKCOLOR);
                this.setLayout(new BoxLayout(this, 1));
                for (ExifTags.Pair tag : tags) {
                    String name = " " + tag.getName() + " ";
                    this.add(new PanelLabel(name, true));
                }
            }
        }

        private class ExifValues
        extends JPanel {
            public ExifValues(Collection<ExifTags.Pair> tags) {
                this.setBorder(SwingProgram.STDBORDER);
                this.setBackground(SwingProgram.DIALOGBACKCOLOR);
                this.setLayout(new BoxLayout(this, 1));
                for (ExifTags.Pair tag : tags) {
                    String value = " " + tag.getValue() + " ";
                    PanelLabel label = new PanelLabel(value, true);
                    label.setHorizontalAlignment(2);
                    label.setAlignmentX(0.0f);
                    this.add(label);
                }
            }
        }
    }
}

