/*
 * Decompiled with CFR 0.152.
 */
package mlib;

import java.io.Serializable;
import java.util.Collection;
import java.util.StringTokenizer;

public class MTimeRange
implements Serializable {
    private Day iDay = null;
    private int iStartMin = 0;
    private int iEndMin = 0;
    private static final int HRMINS = 60;

    public static void main(String[] args) {
        try {
            MTimeRange range = new MTimeRange("mon", "9AM", "3:30PM");
            System.out.println(range);
        }
        catch (Exception xcp) {
            System.out.println(xcp);
        }
    }

    public static boolean anyOverlap(Collection<MTimeRange> range1, Collection<MTimeRange> range2) {
        boolean overlap = false;
        MTimeRange[] array1 = range1.toArray(new MTimeRange[range1.size()]);
        MTimeRange[] array2 = range2.toArray(new MTimeRange[range2.size()]);
        int i = 0;
        while (!overlap && i < array1.length) {
            int j = 0;
            while (!overlap && j < array2.length) {
                overlap = array1[i].anyOverlap(array2[j]);
                ++j;
            }
            ++i;
        }
        return overlap;
    }

    private static int parseNumber(String number) {
        int num = 0;
        if (number.indexOf(58) >= 0) {
            StringTokenizer tken = new StringTokenizer(number, ":");
            num = Integer.parseInt(tken.nextToken()) * 60;
            num += Integer.parseInt(tken.nextToken());
        } else {
            num = Integer.parseInt(number) * 60;
        }
        return num;
    }

    private static String toHrMin(int time) {
        int hours = time / 60;
        int mins = time - hours * 60;
        String str = "" + hours;
        if (mins > 0) {
            str = String.valueOf(str) + ":" + mins;
        }
        return str;
    }

    public MTimeRange(Day day, String start, String end) {
        this.iDay = day;
        this.iStartMin = MTimeRange.parse(start);
        this.iEndMin = MTimeRange.parse(end);
    }

    public MTimeRange(String day, String start, String end) throws Exception {
        this.iDay = null;
        day = day.toUpperCase();
        Day[] dayArray = Day.values();
        int n = dayArray.length;
        int n2 = 0;
        while (n2 < n) {
            Day aDay = dayArray[n2];
            if (aDay.toString().startsWith(day)) {
                this.iDay = aDay;
            }
            ++n2;
        }
        if (this.iDay == null) {
            throw new Exception("invalid day: " + day);
        }
        this.iStartMin = MTimeRange.parse(start);
        this.iEndMin = MTimeRange.parse(end);
    }

    public MTimeRange(char day, String start, String end) throws Exception {
        this.iDay = null;
        day = Character.toUpperCase(day);
        if (day == 'M') {
            this.iDay = Day.MON;
        } else if (day == 'T') {
            this.iDay = Day.TUE;
        } else if (day == 'W') {
            this.iDay = Day.WED;
        } else if (day == 'R') {
            this.iDay = Day.THU;
        } else if (day == 'F') {
            this.iDay = Day.FRI;
        } else if (day == 'S') {
            this.iDay = Day.SAT;
        }
        if (this.iDay == null) {
            throw new Exception("invalid day: " + day);
        }
        this.iStartMin = MTimeRange.parse(start);
        this.iEndMin = MTimeRange.parse(end);
    }

    public boolean anyOverlap(MTimeRange range) {
        boolean outside;
        boolean bl = outside = this.iDay != range.iDay;
        if (!outside) {
            outside = this.iStartMin > range.iEndMin || this.iEndMin < range.iStartMin;
        }
        return !outside;
    }

    public boolean includedIn(MTimeRange range) {
        boolean in;
        boolean bl = in = this.iDay == range.iDay;
        if (in) {
            in = this.iStartMin >= range.iStartMin && this.iEndMin <= range.iEndMin;
        }
        return in;
    }

    public boolean includedIn(Collection<MTimeRange> ranges) {
        boolean in = false;
        for (MTimeRange range : ranges) {
            in |= this.includedIn(range);
        }
        return in;
    }

    public boolean isReasonable() {
        boolean is = this.iStartMin < this.iEndMin;
        return is &= this.iEndMin - this.iStartMin < 360;
    }

    public String toString() {
        String start = MTimeRange.toHrMin(this.iStartMin);
        String end = MTimeRange.toHrMin(this.iEndMin);
        return (Object)((Object)this.iDay) + "," + start + "-" + end;
    }

    private static int parse(String time) {
        time = time.toUpperCase();
        int mins = 0;
        int indexAM = time.indexOf("AM");
        int indexPM = time.indexOf("PM");
        if (indexAM >= 0 || indexPM >= 0) {
            String number = null;
            if (indexAM >= 0) {
                number = time.substring(0, indexAM);
                mins = MTimeRange.parseNumber(number);
            } else {
                number = time.substring(0, indexPM);
                mins = MTimeRange.parseNumber(number);
                int hour = mins / 60;
                if (hour != 12) {
                    mins += 720;
                }
            }
        } else {
            mins = MTimeRange.parseNumber(time);
        }
        return mins;
    }

    public static enum Day {
        MON,
        TUE,
        WED,
        THU,
        FRI,
        SAT;

    }
}

