/*
 * Decompiled with CFR 0.152.
 */
package mlib;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import mlib.MAppMsg;
import mlib.MString;
import utilt.Utility;

public class MIniProps {
    private TreeMap<String, LinkedList<Prop>> iProps = new TreeMap();
    private String iCurSection = null;
    private LinkedList<Prop> iCurProps = new LinkedList();
    private static final char SECTIONSTART = '[';
    private static final char SECTIONEND = ']';
    private static final char COMMENT = ';';
    private static final String PROPASSIGN = "=";
    private static final String VALUEDELIM = ",";
    private static final MAppMsg PROPNOTFOUND = new MAppMsg("NOTFOUND", "Property not found: %1", true);

    public static void main(String[] args) {
        try {
            MIniProps props = MIniProps.read(new File("initest.ini"));
            System.out.println(props);
            String[] value = props.propValue("Section 1", "prop1");
            System.out.println(value[0]);
            value = props.propValue("Section 1", "prop2");
            System.out.println(value.length);
            value = props.propValue("Section 2", "prop1");
            System.out.println(value.length);
        }
        catch (Exception xcp) {
            System.out.println(xcp);
        }
    }

    public static MIniProps read(File file) throws Exception {
        LinkedList<String> lines = Utility.readTextFile(file.getAbsolutePath());
        MIniProps props = new MIniProps();
        Iterator<String> iter = lines.iterator();
        MString line = MIniProps.nextLine(iter);
        while (line != null) {
            props.parseLine(iter, line);
            line = MIniProps.nextLine(iter);
        }
        if (props.iCurSection != null) {
            props.iProps.put(props.iCurSection, props.iCurProps);
        }
        return props;
    }

    public static void throwNotFound(String propName) throws Exception {
        Utility.throwError(PROPNOTFOUND.format(propName));
    }

    private static MString nextLine(Iterator<String> iter) {
        MString nextLine = null;
        if (iter.hasNext()) {
            nextLine = new MString(iter.next()).trimWhitespace();
        }
        return nextLine;
    }

    public int numSections() {
        return this.iProps.keySet().size();
    }

    public int numProps() {
        int num = 0;
        for (String section : this.iProps.keySet()) {
            Collection props = this.iProps.get(section);
            num += props.size();
        }
        return num;
    }

    public String[] propValue(String section, String name) {
        Prop prop = null;
        Iterator iter = this.iProps.get(section).iterator();
        while (prop == null && iter.hasNext()) {
            Prop aProp = (Prop)iter.next();
            boolean matches = name.equalsIgnoreCase(aProp.Name);
            if (!matches) continue;
            prop = aProp;
        }
        String[] value = null;
        if (prop != null) {
            value = prop.Value;
        }
        return value;
    }

    public String toString() {
        String str = this.numSections() + " sections, " + this.numProps() + " properties";
        return str;
    }

    private void parseLine(Iterator<String> iter, MString line) throws Exception {
        if (line.length() > 0 && line.charAt(0) != ';') {
            if (line.charAt(0) == '[') {
                this.parseSection(iter, line);
            } else if (this.iCurSection != null) {
                this.parseProp(line);
            } else {
                throw new Exception("Invalid line: " + line);
            }
        }
    }

    private void parseSection(Iterator<String> iter, MString line) throws Exception {
        if (this.iCurSection != null) {
            LinkedList<Prop> props = new LinkedList<Prop>();
            props.addAll(this.iCurProps);
            this.iProps.put(this.iCurSection, props);
        }
        this.iCurSection = null;
        this.iCurProps.clear();
        line.trim('[');
        line.trim(']');
        this.iCurSection = line.toString();
        LinkedList<Prop> existing = this.iProps.get(this.iCurSection);
        if (existing != null) {
            throw new Exception("Duplicate section: " + this.iCurSection);
        }
        line = MIniProps.nextLine(iter);
        do {
            this.parseLine(iter, line);
        } while ((line = MIniProps.nextLine(iter)) != null);
    }

    private void parseProp(MString line) throws Exception {
        LinkedList<MString> tokens = line.tokenize(PROPASSIGN, true);
        if (tokens.size() < 1 || tokens.size() > 2) {
            throw new Exception("Invalid property: " + line);
        }
        MString[] parts = tokens.toArray(new MString[tokens.size()]);
        Prop aProp = new Prop();
        aProp.Name = parts[0].trimWhitespace().toString();
        if (parts.length == 2) {
            tokens = parts[1].tokenize(VALUEDELIM, false);
            parts = tokens.toArray(new MString[tokens.size()]);
            MString[] temp = tokens.toArray(new MString[tokens.size()]);
            aProp.Value = new String[temp.length];
            int i = 0;
            while (i < temp.length) {
                aProp.Value[i] = temp[i].trimWhitespace().toString();
                ++i;
            }
        }
        this.iCurProps.add(aProp);
    }

    private MIniProps() {
    }

    public static class Prop {
        public String Name = null;
        public String[] Value = null;
    }
}

