/*
 * Decompiled with CFR 0.152.
 */
package mlib;

import java.io.File;
import mlib.MConsoleApp;

public abstract class MDirRecurseApp
extends MConsoleApp {
    public static final String DIRARG = "d";
    public static final String SUBDIRFLAG = "s";

    public MDirRecurseApp(String progTitle) throws Exception {
        super(progTitle);
        this.progArgs().addArg(DIRARG, "Root directory absolute path", null, true, 1, 1);
        this.progArgs().addArg(SUBDIRFLAG, "Flag for doing sub-directories", null, true, 0, 1);
    }

    protected void process(Object accum) throws Exception {
        super.process();
        this.setup();
        String rootDir = this.progArgs().argValue(DIRARG, 0);
        File root = new File(rootDir);
        if (root.exists()) {
            boolean proceed;
            if (this.includeDir(root) && (proceed = this.doBeforeRootDir(root, accum))) {
                this.doDir(root, accum, true);
                this.doAfterLastDir(accum);
            }
        } else {
            this.logger().writeln(String.valueOf(rootDir) + " does not exist", true);
        }
    }

    protected boolean includeDir(File dir) throws Exception {
        String dirName = dir.getName();
        boolean include = dir.isDirectory() && !dirName.equals(".") && !dirName.equals("..") && dirName.indexOf("desktop") < 0;
        return include;
    }

    protected abstract void setup() throws Exception;

    protected abstract boolean doBeforeRootDir(File var1, Object var2) throws Exception;

    protected abstract void doDir(File var1, Object var2, boolean var3) throws Exception;

    protected abstract void doAfterLastDir(Object var1) throws Exception;
}

