/*
 * Decompiled with CFR 0.152.
 */
package mlib;

import mlib.MLogger;
import mlib.MLogging;
import mlib.MProgArgs;

public abstract class MConsoleApp {
    private MProgArgs iProgArgs = new MProgArgs();
    private String iProgTitle = "";
    private MLogging iLogger = new MLogger.System();
    static final String LOGGERARG = "l";
    static final String PARMSARG = "?";

    public MConsoleApp(String progTitle) throws Exception {
        this.iProgTitle = "|" + progTitle + "|";
        this.iProgArgs.addArg(PARMSARG, "Parameter list", null, false, 0, 1);
        this.iProgArgs.addArg(LOGGERARG, "Logger (\"null\" if none)", null, false, 1, 1);
    }

    protected MProgArgs progArgs() {
        return this.iProgArgs;
    }

    protected void setLogger(MLogging logger) {
        this.iLogger = logger;
    }

    protected MLogging logger() {
        return this.iLogger;
    }

    protected String progTitle() {
        return this.iProgTitle;
    }

    protected void setProgTitle(String title) {
        this.iProgTitle = title;
    }

    protected void process() throws Exception {
        this.logger().writeln(this.iProgTitle, false);
    }

    protected boolean parseArgs(String[] args) {
        boolean status = this.iProgArgs.parse(args);
        if (this.progArgs().argSupplied(PARMSARG)) {
            this.iProgArgs.showDesc(this.iLogger);
            System.exit(0);
        } else if (this.iProgArgs.numRequired() > 0 && this.iProgArgs.numFound() == 0) {
            this.iLogger.writeln(this.iProgTitle, false);
            this.iProgArgs.showDesc(this.iLogger);
            status = false;
        } else if (!status) {
            this.iLogger.writeln(this.iProgTitle, false);
            this.iProgArgs.showFirstError(this.iLogger);
            this.iProgArgs.showDesc(this.iLogger);
        } else if (this.progArgs().argSupplied(LOGGERARG)) {
            String logger = this.progArgs().argValue(LOGGERARG, 0);
            if (logger.equalsIgnoreCase("null")) {
                this.setLogger(new MLogger.Empty());
            } else {
                try {
                    MLogger.File fLogger = new MLogger.File(logger, false);
                    this.setLogger(fLogger);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return status;
    }
}

