/*
 * Decompiled with CFR 0.152.
 */
package mlib;

import java.util.Collection;
import mlib.MString;
import utilt.Utility;

public abstract class MCharColl
implements Cloneable {
    protected char[] iChars = new char[128];
    protected int iCount = 0;
    protected int iPos = -1;
    protected int iFirstPush = -1;
    protected char iLastPop = '\u0000';
    protected boolean iSkipWhite = false;
    protected static final int NONE = -1;
    protected static final int INCREMENT = 128;
    protected static final String EMPTY = "empty collection";
    private static int CountSave = 0;
    private static int PosSave = -1;
    private static int FirstPushSave = -1;

    public MCharColl(boolean skipWhitespace) {
        this.iSkipWhite = skipWhitespace;
    }

    public MCharColl(String str, boolean skipWhitespace) {
        this(skipWhitespace);
        this.push(str);
    }

    public MCharColl(MString str, boolean skipWhitespace) throws Exception {
        this(skipWhitespace);
        this.push(str);
    }

    public MCharColl(Collection<MString> strs, boolean skipWhitespace) {
        this(skipWhitespace);
        for (MString str : strs) {
            this.push(str);
        }
    }

    public void push(String str) {
        int i = 0;
        while (i < str.length()) {
            this.push(str.charAt(i));
            ++i;
        }
    }

    public void push(MString str) {
        this.push(str.toString());
    }

    public boolean hasMore() {
        return this.iCount > 0;
    }

    public void clear() {
        this.iChars = new char[0];
    }

    public char lastPop() {
        return this.iLastPop;
    }

    public void push(char chr) {
        if (!this.iSkipWhite || !Character.isWhitespace(chr)) {
            if (this.iCount == 0) {
                this.iPos = this.iChars.length - 1;
                this.iChars[this.iPos] = chr;
                this.iFirstPush = this.iPos;
            } else if (this.iCount >= this.iChars.length) {
                char[] newChars = new char[this.iChars.length + 128];
                int start = newChars.length - this.iCount;
                int i = 0;
                while (i < this.iCount) {
                    newChars[start + i] = this.iChars[i];
                    ++i;
                }
                this.iFirstPush = newChars.length - 1;
                this.iChars = newChars;
                this.iPos = start - 1;
                this.iChars[this.iPos] = chr;
            } else if (this.iPos >= 0) {
                --this.iPos;
                this.iChars[this.iPos] = chr;
            }
            ++this.iCount;
            if (this.iCount == 1) {
                this.iFirstPush = this.iPos;
            }
        }
    }

    public boolean coming(char chr, char before) {
        boolean coming = false;
        if (this.iCount > 1) {
            this.save();
            boolean charFound = false;
            boolean beforeFound = false;
            coming = false;
            try {
                while (!charFound) {
                    char next = this.pop();
                    if (next == before) {
                        beforeFound = true;
                        continue;
                    }
                    if (next != chr) continue;
                    charFound = true;
                    boolean bl = coming = !beforeFound;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.restore();
        }
        return coming;
    }

    public void popWhitespace() {
        boolean more = true;
        try {
            while (this.hasMore() && more) {
                char chr = this.peek();
                more = Character.isWhitespace(chr);
                if (!more) continue;
                this.pop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        this.save();
        MString str = new MString();
        try {
            while (true) {
                str.concat(this.pop());
            }
        }
        catch (Exception exception) {
            this.restore();
            return str.toString();
        }
    }

    public Object clone() {
        MCharColl copy = null;
        try {
            copy = (MCharColl)super.clone();
            char[] chars = new char[this.iChars.length];
            int i = 0;
            while (i < this.iChars.length) {
                chars[i] = this.iChars[i];
                ++i;
            }
            this.iChars = chars;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return copy;
    }

    public abstract char pop() throws Exception;

    public abstract char peek() throws Exception;

    private void save() {
        CountSave = this.iCount;
        PosSave = this.iPos;
        FirstPushSave = this.iFirstPush;
    }

    private void restore() {
        this.iCount = CountSave;
        this.iPos = PosSave;
        this.iFirstPush = FirstPushSave;
    }

    public static class Queue
    extends MCharColl {
        public static void main(String[] args) {
            try {
                Queue queue = new Queue("12345", false);
                queue.push("6789");
                int i = 0;
                while (i < 9) {
                    System.out.println(queue.pop());
                    ++i;
                }
                queue.push("123 45");
                boolean coming = queue.coming('2', '5');
                System.out.println(coming);
                int i2 = 0;
                while (i2 < 15) {
                    System.out.println(queue.pop());
                    ++i2;
                }
            }
            catch (Exception xcp) {
                System.out.println(xcp);
            }
        }

        public Queue(boolean skipWhitespace) {
            super(skipWhitespace);
        }

        public Queue(String str, boolean skipWhitespace) {
            super(skipWhitespace);
            this.push(str);
        }

        public Queue(MString str, boolean skipWhitespace) throws Exception {
            super(skipWhitespace);
            this.push(str);
        }

        public Queue(Collection<MString> strs, boolean skipWhitespace) {
            super(skipWhitespace);
            for (MString str : strs) {
                this.push(str);
            }
        }

        @Override
        public char pop() throws Exception {
            if (this.iCount <= 0) {
                Utility.throwError(MCharColl.EMPTY);
            }
            char chr = this.iChars[this.iFirstPush];
            --this.iFirstPush;
            --this.iCount;
            this.iLastPop = chr;
            return chr;
        }

        @Override
        public char peek() throws Exception {
            if (this.iCount <= 0) {
                Utility.throwError(MCharColl.EMPTY);
            }
            return this.iChars[this.iFirstPush];
        }
    }

    public static class Stack
    extends MCharColl {
        public static void main(String[] args) {
            try {
                Stack stack = new Stack("12345", false);
                stack.push("6789");
                int i = 0;
                while (i < 9) {
                    System.out.println(stack.pop());
                    ++i;
                }
                stack.push("12345");
                i = 0;
                while (i < 15) {
                    System.out.println(stack.pop());
                    ++i;
                }
            }
            catch (Exception xcp) {
                System.out.println(xcp);
            }
        }

        public Stack(boolean skipWhitespace) {
            super(skipWhitespace);
        }

        public Stack(String str, boolean skipWhitespace) {
            super(skipWhitespace);
            this.push(str);
        }

        public Stack(MString str, boolean skipWhitespace) throws Exception {
            super(skipWhitespace);
            this.push(str);
        }

        public Stack(Collection<MString> strs, boolean skipWhitespace) {
            super(skipWhitespace);
            for (MString str : strs) {
                this.push(str);
            }
        }

        @Override
        public char pop() throws Exception {
            if (this.iCount <= 0) {
                Utility.throwError(MCharColl.EMPTY);
            }
            char chr = this.iChars[this.iPos];
            ++this.iPos;
            --this.iCount;
            this.iLastPop = chr;
            return chr;
        }

        @Override
        public char peek() throws Exception {
            if (this.iCount <= 0) {
                Utility.throwError(MCharColl.EMPTY);
            }
            return this.iChars[this.iPos];
        }
    }
}

