/*
 * Decompiled with CFR 0.152.
 */
package math;

import chart.Chart;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Comparator;
import math.Filterable;
import mlib.MEncStr;
import mswing.StdColor;

public interface XYpoint
extends Filterable {
    public double x();

    public double y();

    public double yUncer();

    public void setYUncer(double var1);

    @Override
    public double weight();

    @Override
    public String label();

    public StdColor stdColor();

    public void setColor(StdColor var1);

    public void setHover(String var1);

    public String getHover();

    @Override
    public void setObject(Object var1);

    public Object persistObject();

    public void setPersistObject(Object var1);

    @Override
    public Object object();

    public String toString(DecimalFormat var1);

    public void setChartType(Chart.ScatterAppearance.Type var1);

    @Override
    public void setFilterByX(boolean var1);

    public Chart.ScatterAppearance.Type getChartType();

    public boolean isZero();

    public static class Double
    implements XYpoint,
    Comparable<Double>,
    Serializable,
    Cloneable {
        private double iX = -99999.0;
        private double iY = -99999.0;
        private double iYUncer = -99999.0;
        private double iResidual = -99999.0;
        private double iWeight = -99999.0;
        private MEncStr iK7 = new MEncStr();
        private MEncStr iS4 = null;
        private StdColor iColor = null;
        private boolean iFilterByX = false;
        private Chart.ScatterAppearance.Type iChartType = null;
        private transient Object iObject = null;
        private Object iPersistObject = null;
        private static final long serialVersionUID = 5700842342350298229L;

        public Double() {
            this(-99999.0, -99999.0);
        }

        public Double(double y) {
            this(-99999.0, y);
        }

        public Double(double x, double y) {
            this.iX = x;
            this.iY = y;
        }

        public Double(double y, String label) {
            this(-99999.0, y);
            this.iK7 = new MEncStr(label);
        }

        public Double(double x, double y, String label) {
            this(x, y);
            this.iK7 = new MEncStr(label);
        }

        public Double(double x, double y, double uncer, String label) {
            this(x, y, label);
            this.iYUncer = uncer;
        }

        @Override
        public int compareTo(Double point) {
            int res = 0;
            if (point != this) {
                res = -1;
                if (point != null) {
                    res = this.iY > point.iY ? 1 : -1;
                }
            }
            return res;
        }

        public boolean equals(Object obj) {
            return this.compareTo((Double)obj) == 0;
        }

        public int hashCode() {
            return this.iK7.hashCode();
        }

        @Override
        public double x() {
            return this.iX;
        }

        public void setX(double x) {
            this.iX = x;
        }

        public void setY(double value) {
            this.iY = value;
        }

        @Override
        public double y() {
            return this.iY;
        }

        @Override
        public double yUncer() {
            return this.iYUncer;
        }

        @Override
        public void setYUncer(double yUncer) {
            this.iYUncer = (float)yUncer;
        }

        @Override
        public double residual() {
            return this.iResidual;
        }

        @Override
        public void setResidual(double residual) {
            this.iResidual = (float)residual;
        }

        @Override
        public String label() {
            return this.iK7.toString();
        }

        public void setLabel(String label) {
            this.iK7 = new MEncStr(label);
        }

        @Override
        public String getHover() {
            String hover = null;
            if (this.iS4 != null) {
                hover = this.iS4.toString();
            }
            return hover;
        }

        @Override
        public void setHover(String hover) {
            this.iS4 = new MEncStr(hover);
        }

        @Override
        public double weight() {
            return this.iWeight;
        }

        @Override
        public void setWeight(double weight) {
            this.iWeight = (float)weight;
        }

        @Override
        public boolean hasValue() {
            java.lang.Double value = this.iY;
            boolean has = !value.isInfinite() && this.iY != -99999.0 && !java.lang.Double.isNaN(value);
            return has;
        }

        @Override
        public boolean isZero() {
            double value = this.iY;
            if (this.iFilterByX) {
                value = this.iX;
            }
            boolean isZero = Math.abs(value) < java.lang.Double.MIN_VALUE;
            return isZero;
        }

        @Override
        public boolean isFilterByX() {
            return this.iFilterByX;
        }

        @Override
        public void setFilterByX(boolean byX) {
            this.iFilterByX = byX;
        }

        @Override
        public double value() {
            double value = this.iY;
            if (this.iFilterByX) {
                value = this.iX;
            }
            return value;
        }

        @Override
        public void setValue(double value) {
            if (this.iFilterByX) {
                this.iX = (float)value;
            } else {
                this.iY = (float)value;
            }
        }

        @Override
        public StdColor stdColor() {
            return this.iColor;
        }

        @Override
        public void setColor(StdColor color) {
            this.iColor = color;
        }

        @Override
        public void setObject(Object obj) {
            this.iObject = obj;
        }

        @Override
        public Object object() {
            return this.iObject;
        }

        @Override
        public void setPersistObject(Object obj) {
            this.iPersistObject = obj;
        }

        @Override
        public Object persistObject() {
            return this.iPersistObject;
        }

        @Override
        public void setChartType(Chart.ScatterAppearance.Type type) {
            this.iChartType = type;
        }

        @Override
        public Chart.ScatterAppearance.Type getChartType() {
            return this.iChartType;
        }

        public Object clone() {
            Double copy = null;
            try {
                copy = (Double)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return copy;
        }

        public String toString() {
            String str = String.valueOf(this.iK7.toString()) + ": x=" + this.iX + ", y=" + this.iY + ", unc=" + this.iYUncer;
            if (this.iPersistObject != null) {
                str = String.valueOf(str) + ":" + this.iPersistObject;
            }
            return str;
        }

        @Override
        public String toString(DecimalFormat format) {
            String str = String.valueOf(this.iK7.toString()) + "," + format.format(this.iY);
            return str;
        }

        public static class NameOrderer
        implements Comparator<Float> {
            @Override
            public int compare(Float point1, Float point2) {
                int result = -1;
                if (point1 != null && point2 != null) {
                    result = point1.label().compareToIgnoreCase(point2.label());
                }
                return result;
            }
        }

        public static class ReverseYOrderer
        implements Comparator<Float> {
            @Override
            public int compare(Float point1, Float point2) {
                int result = -1;
                if (point1 != null && point2 != null && point2.y() > point1.y()) {
                    result = 1;
                }
                return result;
            }
        }

        public static class XOrderer
        implements Comparator<Float> {
            @Override
            public int compare(Float point1, Float point2) {
                int result = -1;
                if (point1 != null && point2 != null && point1.x() > point2.x()) {
                    result = 1;
                }
                return result;
            }
        }
    }

    public static class Float
    implements XYpoint,
    Comparable<Float>,
    Serializable,
    Cloneable {
        private float iX = -99999.0f;
        private float iY = -99999.0f;
        private float iYUncer = -99999.0f;
        private float iResidual = -99999.0f;
        private float iWeight = -99999.0f;
        private MEncStr iK7 = new MEncStr();
        private MEncStr iS4 = null;
        private StdColor iColor = StdColor.BLUE;
        private boolean iFilterByX = false;
        private Chart.ScatterAppearance.Type iChartType = null;
        private transient Object iObject = null;
        private Object iPersistObject = null;
        private static final long serialVersionUID = 5700842342350298229L;

        public Float() {
            this(-99999.0f, -99999.0f);
        }

        public Float(float y) {
            this(-99999.0f, y);
        }

        public Float(float x, float y) {
            this.iX = x;
            this.iY = y;
        }

        public Float(float y, String label) {
            this(-99999.0f, y);
            this.iK7 = new MEncStr(label);
        }

        public Float(float x, float y, String label) {
            this(x, y);
            this.iK7 = new MEncStr(label);
        }

        public Float(float x, float y, float uncer, String label) {
            this(x, y, label);
            this.iYUncer = uncer;
        }

        @Override
        public int compareTo(Float point) {
            int res = 0;
            if (point != this) {
                res = -1;
                if (point != null) {
                    res = this.iFilterByX ? (this.iX > point.iX ? 1 : -1) : (this.iY > point.iY ? 1 : -1);
                }
            }
            return res;
        }

        public boolean equals(Object obj) {
            return this.compareTo((Float)obj) == 0;
        }

        public int hashCode() {
            return this.iK7.hashCode();
        }

        @Override
        public double x() {
            return this.iX;
        }

        public void setX(float x) {
            this.iX = x;
        }

        public void setY(float value) {
            this.iY = value;
        }

        @Override
        public double y() {
            return this.iY;
        }

        @Override
        public double yUncer() {
            return this.iYUncer;
        }

        @Override
        public void setYUncer(double yUncer) {
            this.iYUncer = (float)yUncer;
        }

        @Override
        public double residual() {
            return this.iResidual;
        }

        @Override
        public void setResidual(double residual) {
            this.iResidual = (float)residual;
        }

        @Override
        public String label() {
            return this.iK7.toString();
        }

        public void setLabel(String label) {
            this.iK7 = new MEncStr(label);
        }

        @Override
        public String getHover() {
            String hover = null;
            if (this.iS4 != null) {
                hover = this.iS4.toString();
            }
            return hover;
        }

        @Override
        public void setHover(String hover) {
            this.iS4 = new MEncStr(hover);
        }

        @Override
        public double weight() {
            return this.iWeight;
        }

        @Override
        public void setWeight(double weight) {
            this.iWeight = (float)weight;
        }

        @Override
        public boolean hasValue() {
            java.lang.Float value = java.lang.Float.valueOf(this.iY);
            boolean has = !value.isInfinite() && this.iY != -99999.0f && !java.lang.Float.isNaN(value.floatValue());
            return has;
        }

        @Override
        public boolean isZero() {
            double value = this.iY;
            if (this.iFilterByX) {
                value = this.iX;
            }
            boolean isZero = Math.abs(value) < (double)1.4E-45f;
            return isZero;
        }

        @Override
        public boolean isFilterByX() {
            return this.iFilterByX;
        }

        @Override
        public void setFilterByX(boolean byX) {
            this.iFilterByX = byX;
        }

        @Override
        public double value() {
            double value = this.iY;
            if (this.iFilterByX) {
                value = this.iX;
            }
            return value;
        }

        @Override
        public void setValue(double value) {
            if (this.iFilterByX) {
                this.iX = (float)value;
            } else {
                this.iY = (float)value;
            }
        }

        @Override
        public StdColor stdColor() {
            return this.iColor;
        }

        @Override
        public void setColor(StdColor color) {
            this.iColor = color;
        }

        @Override
        public void setObject(Object obj) {
            this.iObject = obj;
        }

        @Override
        public Object object() {
            return this.iObject;
        }

        @Override
        public void setPersistObject(Object obj) {
            this.iPersistObject = obj;
        }

        @Override
        public Object persistObject() {
            return this.iPersistObject;
        }

        @Override
        public void setChartType(Chart.ScatterAppearance.Type type) {
            this.iChartType = type;
        }

        @Override
        public Chart.ScatterAppearance.Type getChartType() {
            return this.iChartType;
        }

        public Double toDouble() {
            Double point = new Double(this.x(), this.y());
            point.iYUncer = this.iYUncer;
            point.iResidual = this.iResidual;
            point.iWeight = this.iWeight;
            point.iK7 = this.iK7;
            point.iS4 = this.iS4;
            point.iColor = this.iColor;
            point.iFilterByX = this.iFilterByX;
            point.iChartType = this.iChartType;
            point.iObject = this.iObject;
            point.iPersistObject = this.iPersistObject;
            return point;
        }

        public Object clone() {
            Float copy = null;
            try {
                copy = (Float)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            return copy;
        }

        public String toString() {
            float lLimit = this.iY - this.iYUncer;
            float uLimit = this.iY + this.iYUncer;
            String str = String.valueOf(this.iK7.toString()) + ": x=" + this.iX + ", y=" + this.iY + ", [" + lLimit + "," + uLimit + "]";
            if (this.iPersistObject != null) {
                str = String.valueOf(str) + ":" + this.iPersistObject;
            }
            return str;
        }

        @Override
        public String toString(DecimalFormat format) {
            String str = String.valueOf(this.iK7.toString()) + "," + format.format(this.iY);
            return str;
        }

        public static class NameOrderer
        implements Comparator<Float> {
            @Override
            public int compare(Float point1, Float point2) {
                int result = -1;
                if (point1 != null && point2 != null) {
                    result = point1.label().compareToIgnoreCase(point2.label());
                }
                return result;
            }
        }

        public static class ReverseYOrderer
        implements Comparator<Float> {
            @Override
            public int compare(Float point1, Float point2) {
                int result = -1;
                if (point1 != null && point2 != null && point2.y() > point1.y()) {
                    result = 1;
                }
                return result;
            }
        }
    }
}

