/*
 * Decompiled with CFR 0.152.
 */
package math;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Iterator;
import math.Dataset;
import math.XYpoint;
import mlib.MString;
import utilt.Utility;

public class DistStats
implements Serializable,
Cloneable {
    private String iName = "";
    private double iSumWts = 0.0;
    private double iSumWtsSqd = 0.0;
    private double iSumWtedValues = 0.0;
    private double iSumWtedValuesSqd = 0.0;
    private double iMaxValue = -1.7976931348623157E308;
    private double iMinValue = Double.MAX_VALUE;
    private int iNumValues = 0;
    private Object iObject = null;
    private static final DecimalFormat FORMAT = new DecimalFormat("0.0");
    private static final long serialVersionUID = -345762717854512977L;

    public static void main(String[] args) {
        DistStats stats = new DistStats("test");
        int i = 1;
        while (i <= 5) {
            stats.add(i, 1.0);
            ++i;
        }
        System.out.println(stats);
    }

    public DistStats(String name) {
        this.iName = name;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public void add(double value, double weight) {
        double factor = value * weight;
        this.iSumWtedValues += factor;
        this.iSumWtedValuesSqd += factor * value;
        this.iSumWts += weight;
        this.iSumWtsSqd += weight * weight;
        ++this.iNumValues;
        if (value > this.iMaxValue) {
            this.iMaxValue = value;
        }
        if (value < this.iMinValue) {
            this.iMinValue = value;
        }
    }

    public void add(double value, double weight, int numTimes) {
        double factor = value * weight;
        this.iSumWtedValues += factor * (double)numTimes;
        this.iSumWtedValuesSqd += factor * (double)numTimes * (factor * (double)numTimes);
        this.iSumWts += weight * (double)numTimes;
        this.iSumWtsSqd += weight * weight * (double)numTimes;
        this.iNumValues += numTimes;
    }

    public void add(Dataset.List<XYpoint.Float> points) {
        Iterator<XYpoint.Float> iter = points.iterator();
        while (iter.hasNext()) {
            XYpoint.Float point = iter.next();
            this.add(point.y(), 1.0);
        }
    }

    public void add(DistStats stats) {
        this.iSumWtedValues += stats.iSumWtedValues;
        this.iSumWtedValuesSqd += stats.iSumWtedValuesSqd;
        this.iSumWts += stats.iSumWts;
        this.iSumWtsSqd += stats.iSumWtsSqd;
        this.iNumValues += stats.iNumValues;
        if (stats.iMaxValue > this.iMaxValue) {
            this.iMaxValue = stats.iMaxValue;
        }
        if (stats.iMinValue < this.iMinValue) {
            this.iMinValue = stats.iMinValue;
        }
    }

    public int numValues() {
        return this.iNumValues;
    }

    public double maxValue() {
        return this.iMaxValue;
    }

    public double minValue() {
        return this.iMinValue;
    }

    public double sumWtedValues() {
        return this.iSumWtedValues;
    }

    public double avg() {
        double avg = Double.NaN;
        if (this.iNumValues > 0) {
            avg = this.iSumWtedValues / this.iSumWts;
        }
        return avg;
    }

    public double sigmaOfAvg() {
        double sigma = Double.NaN;
        if (this.iNumValues > 1) {
            sigma = this.sigma() / Math.sqrt(this.iNumValues);
        }
        return sigma;
    }

    public double sigma() {
        double sigma = Double.NaN;
        if (this.iNumValues > 1) {
            double numer = this.iSumWtedValuesSqd * this.iSumWts - this.iSumWtedValues * this.iSumWtedValues;
            double denom = this.iSumWts * this.iSumWts - this.iSumWtsSqd;
            sigma = Math.sqrt(numer / denom);
        }
        return sigma;
    }

    public double sumWtdValues() {
        return this.iSumWtedValues;
    }

    public double sumWtedValuesSqd() {
        return this.iSumWtedValuesSqd;
    }

    public Object object() {
        return this.iObject;
    }

    public void setObject(Object obj) {
        this.iObject = obj;
    }

    public Object clone() {
        DistStats copy = null;
        try {
            copy = (DistStats)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return copy;
    }

    public String toString() {
        MString str = new MString(Utility.objPrefix(this));
        if (this.getName().length() > 0) {
            str.concat(String.valueOf(this.getName()) + "(" + this.iNumValues + "): ");
        }
        if (this.iNumValues == 0) {
            str.concat("empty");
        } else {
            double range = (double)2.58f * this.sigmaOfAvg();
            double avg = this.avg();
            double ciMin = avg - range;
            double ciMax = avg + range;
            str.concat(String.valueOf(FORMAT.format(avg)) + " [" + FORMAT.format(ciMin) + "," + FORMAT.format(ciMax) + "]");
            range = (double)2.58f * this.sigma();
            ciMin = avg - range;
            ciMax = avg + range;
            str.concat(" [" + FORMAT.format(ciMin) + "," + FORMAT.format(ciMax) + "]");
            str.concat(" [" + FORMAT.format(this.iMinValue) + " >< " + FORMAT.format(this.iMaxValue) + "]");
        }
        if (this.iObject != null) {
            str.concat(",obj=" + this.iObject);
        }
        return str.toString();
    }

    public String abbrevString() {
        MString str = new MString();
        if (this.getName().length() > 0) {
            str.concat(this.getName());
            if (str.indexOf(": ") < 0) {
                str.concat(": ");
            }
        }
        if (this.iNumValues == 0) {
            str.concat("empty");
        } else {
            double range = (double)2.58f * this.sigmaOfAvg();
            str.concat(FORMAT.format(this.avg()));
            str.concat(" +/- " + FORMAT.format(range) + " 99%CI");
        }
        return str.toString();
    }
}

