/*
 * Decompiled with CFR 0.152.
 */
package math;

import Jama.Matrix;
import math.DataBin;
import math.DataModel;
import math.GaussianModel;

public class DiffCorr {
    private DataBin.Dataset iDataset = null;
    private DataModel[] iModels = null;
    private double iConvergFrac = 0.05;
    private int iMaxIter = 10;
    private int iNumIter = -1;
    private double[][] iMatrix = null;
    private Matrix iInverse = null;
    private double[] iRhs = null;
    private double iSumResSqd = 0.0;
    public static final int CONVERGED = 0;
    public static final int CONVERGING = 1;
    public static final int DIVERGED = 2;
    public static final int SINGULAR = 3;
    private static final double CONVERGFRAC = 0.05;
    private static final int MAXITER = 10;

    public static void main(String[] args) {
        try {
            GaussianModel model = new GaussianModel(25.0, 5.0, 100.0);
            DataBin[] bins = new DataBin[50];
            int i = 0;
            while (i < bins.length) {
                DataBin bin = new DataBin(i, i + 1);
                bin.setModelCount((float)model.value(bin));
                bins[i] = bin;
                ++i;
            }
            DataBin.Dataset dataset = new DataBin.Dataset(bins, "test");
            model = GaussianModel.fit(dataset);
            System.out.println(model);
            DataModel[] models = new DataModel[]{new GaussianModel(25.0, 3.0, 150.0)};
            DiffCorr corr = new DiffCorr(dataset, models, 0.01, 10);
            int status = corr.iterate();
            System.out.println(String.valueOf(status) + " " + corr.numIter() + " " + models[0]);
        }
        catch (Exception xcp) {
            System.out.println(xcp);
        }
    }

    public DiffCorr(DataBin.Dataset dataset, DataModel[] models) {
        this(dataset, models, 0.05, 10);
    }

    public DiffCorr(DataBin.Dataset dataset, DataModel[] models, double convergFrac, int maxIter) {
        this.iDataset = dataset;
        this.iModels = models;
        this.iConvergFrac = convergFrac;
        this.iMaxIter = maxIter;
        int stateSize = 0;
        DataModel[] dataModelArray = this.iModels;
        int n = this.iModels.length;
        int n2 = 0;
        while (n2 < n) {
            DataModel.Parm[] state;
            DataModel model = dataModelArray[n2];
            DataModel.Parm[] parmArray = state = model.state();
            int n3 = state.length;
            int n4 = 0;
            while (n4 < n3) {
                DataModel.Parm parm = parmArray[n4];
                parm.setIndex(stateSize++);
                ++n4;
            }
            ++n2;
        }
        this.iRhs = new double[stateSize];
        this.iMatrix = new double[stateSize][stateSize];
    }

    public int iterate() {
        double prevSumResSqd = Double.MAX_VALUE;
        this.iNumIter = 0;
        int status = 1;
        while (status == 1 && this.iNumIter < this.iMaxIter) {
            DataBin[] bins;
            this.iSumResSqd = 0.0;
            this.init();
            DataBin[] dataBinArray = bins = this.iDataset.bins();
            int n = bins.length;
            int n2 = 0;
            while (n2 < n) {
                DataBin bin = dataBinArray[n2];
                double value = 0.0;
                DataModel[] dataModelArray = this.iModels;
                int n3 = this.iModels.length;
                int n4 = 0;
                while (n4 < n3) {
                    DataModel model = dataModelArray[n4];
                    value += model.value(bin);
                    ++n4;
                }
                double residual = (double)bin.count() - value;
                double wt = bin.weight();
                double factor = residual * wt;
                this.iSumResSqd += factor * residual;
                DataModel[] dataModelArray2 = this.iModels;
                int n5 = this.iModels.length;
                int n6 = 0;
                while (n6 < n5) {
                    DataModel.Parm[] state;
                    DataModel model = dataModelArray2[n6];
                    DataModel.Parm[] parmArray = state = model.state();
                    int n7 = state.length;
                    int n8 = 0;
                    while (n8 < n7) {
                        DataModel.Parm parm1 = parmArray[n8];
                        if (parm1.isSolveFor()) {
                            int index1 = parm1.index();
                            double partial1 = model.partialDeriv(bin, parm1);
                            int n9 = index1;
                            this.iRhs[n9] = this.iRhs[n9] + partial1 * factor;
                            DataModel.Parm[] parmArray2 = state;
                            int n10 = state.length;
                            int n11 = 0;
                            while (n11 < n10) {
                                DataModel.Parm parm2 = parmArray2[n11];
                                int index2 = parm2.index();
                                double partial2 = model.partialDeriv(bin, parm2);
                                double[] dArray = this.iMatrix[index1];
                                int n12 = index2;
                                dArray[n12] = dArray[n12] + partial1 * partial2 * wt;
                                ++n11;
                            }
                        }
                        ++n8;
                    }
                    ++n6;
                }
                ++n2;
            }
            if (this.iSumResSqd > prevSumResSqd) {
                status = 2;
                continue;
            }
            boolean again = true;
            if (this.iNumIter > 0) {
                ++this.iNumIter;
                double change = (prevSumResSqd - this.iSumResSqd) / prevSumResSqd;
                boolean bl = again = change > this.iConvergFrac;
                if (!again) {
                    status = 0;
                }
            } else {
                ++this.iNumIter;
                try {
                    Matrix normal = new Matrix(this.iMatrix);
                    this.iInverse = normal.inverse();
                    Matrix rhs = new Matrix(this.iRhs, this.iRhs.length);
                    Matrix sol = this.iInverse.times(rhs);
                    DataModel[] dataModelArray = this.iModels;
                    int n13 = this.iModels.length;
                    int n14 = 0;
                    while (n14 < n13) {
                        DataModel.Parm[] state;
                        DataModel model = dataModelArray[n14];
                        DataModel.Parm[] parmArray = state = model.state();
                        int n15 = state.length;
                        int n16 = 0;
                        while (n16 < n15) {
                            DataModel.Parm parm = parmArray[n16];
                            double value = parm.value();
                            int index = parm.index();
                            parm.setValue(value += sol.get(index, 0));
                            ++n16;
                        }
                        ++n14;
                    }
                }
                catch (Exception xcp) {
                    status = 3;
                }
            }
            prevSumResSqd = this.iSumResSqd;
        }
        if (status == 0) {
            this.calcParmSigmas();
            this.putBinModelValues();
        }
        return status;
    }

    public int numIter() {
        return this.iNumIter;
    }

    private void init() {
        int i = 0;
        while (i < this.iRhs.length) {
            this.iRhs[i] = 0.0;
            int j = 0;
            while (j < this.iRhs.length) {
                this.iMatrix[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
    }

    private void calcParmSigmas() {
        DataModel[] dataModelArray = this.iModels;
        int n = this.iModels.length;
        int n2 = 0;
        while (n2 < n) {
            DataModel.Parm[] state;
            DataModel model = dataModelArray[n2];
            DataModel.Parm[] parmArray = state = model.state();
            int n3 = state.length;
            int n4 = 0;
            while (n4 < n3) {
                DataModel.Parm parm1 = parmArray[n4];
                int index1 = parm1.index();
                double sigma = Math.sqrt(this.iInverse.get(index1, index1) * this.iSumResSqd);
                parm1.setSigma(sigma);
                ++n4;
            }
            ++n2;
        }
    }

    private void putBinModelValues() {
        DataBin[] bins;
        DataBin[] dataBinArray = bins = this.iDataset.bins();
        int n = bins.length;
        int n2 = 0;
        while (n2 < n) {
            DataBin bin = dataBinArray[n2];
            double value = 0.0;
            DataModel[] dataModelArray = this.iModels;
            int n3 = this.iModels.length;
            int n4 = 0;
            while (n4 < n3) {
                DataModel model = dataModelArray[n4];
                value += model.value(bin);
                ++n4;
            }
            bin.setModelCount((float)value);
            ++n2;
        }
    }
}

