/*
 * Decompiled with CFR 0.152.
 */
package math;

import java.text.DecimalFormat;
import math.DataBin;
import mlib.MString;
import org.apache.commons.math3.stat.inference.ChiSquareTest;
import utilt.Utility;

public abstract class DataModel {
    private Parm[] iState = null;
    public static final DecimalFormat PARMFORMAT = new DecimalFormat("0.00");

    protected DataModel() {
    }

    public void setState(Parm[] state) {
        this.iState = state;
    }

    public Parm[] state() {
        return this.iState;
    }

    public Parm parm(String name) {
        Parm parm = null;
        int i = 0;
        while (parm == null && i < this.iState.length) {
            if (name.equalsIgnoreCase(this.iState[i].iName)) {
                parm = this.iState[i];
                continue;
            }
            ++i;
        }
        return parm;
    }

    public int dof(DataBin.Dataset dataset) {
        Parm[] parms;
        int count = 0;
        Parm[] parmArray = parms = this.state();
        int n = parms.length;
        int n2 = 0;
        while (n2 < n) {
            Parm parm = parmArray[n2];
            if (parm.isSolveFor()) {
                ++count;
            }
            ++n2;
        }
        int dof = dataset.numBinsNotEmpty() - count - 1;
        return dof;
    }

    public double unitChiSquare(DataBin.Dataset dataset) {
        DataBin[] bins = dataset.bins();
        double cs = 0.0;
        DataBin[] dataBinArray = bins;
        int n = bins.length;
        int n2 = 0;
        while (n2 < n) {
            DataBin bin = dataBinArray[n2];
            if (bin.hasValue()) {
                double binValue = bin.residual() * bin.residual() / bin.modelCount();
                cs += binValue;
            }
            ++n2;
        }
        return cs /= (double)this.dof(dataset);
    }

    public double chiSquareTest(DataBin.Dataset dataset) {
        DataBin[] bins = dataset.bins();
        double[] expected = new double[bins.length];
        long[] observed = new long[bins.length];
        int i = 0;
        DataBin[] dataBinArray = bins;
        int n = bins.length;
        int n2 = 0;
        while (n2 < n) {
            DataBin bin = dataBinArray[n2];
            expected[i] = bin.modelCount();
            observed[i] = bin.count();
            ++i;
            ++n2;
        }
        ChiSquareTest test = new ChiSquareTest();
        double value = test.chiSquare(expected, observed);
        return value;
    }

    public String toString() {
        Parm[] state = this.state();
        MString str = new MString(Utility.objPrefix(this));
        Parm[] parmArray = state;
        int n = state.length;
        int n2 = 0;
        while (n2 < n) {
            Parm parm = parmArray[n2];
            str.concat(String.valueOf(parm.toString()) + ", ");
            ++n2;
        }
        str.trimTail(' ');
        str.trimTail(',');
        return str.toString();
    }

    public abstract double value(DataBin var1);

    public abstract double partialDeriv(DataBin var1, Parm var2);

    public static class Parm {
        private String iName = null;
        private int iIndex = -1;
        private double iValue = 0.0;
        private double iSigma = 0.0;
        private boolean iSolveFor = true;

        public Parm(String name, double initValue) {
            this.iName = name;
            this.iValue = initValue;
        }

        public int index() {
            return this.iIndex;
        }

        public void setIndex(int index) {
            this.iIndex = index;
        }

        public String name() {
            return this.iName;
        }

        public double value() {
            return this.iValue;
        }

        public void setValue(double value) {
            this.iValue = value;
        }

        public double sigma() {
            return this.iSigma;
        }

        public void setSigma(double sigma) {
            this.iSigma = sigma;
        }

        public void setSolveFor(boolean solveFor) {
            this.iSolveFor = solveFor;
        }

        public boolean isSolveFor() {
            return this.iSolveFor;
        }

        public String toString() {
            String str = String.valueOf(this.iName) + "=" + PARMFORMAT.format(this.iValue) + " \u00b1 " + PARMFORMAT.format(this.iSigma);
            return str;
        }
    }
}

