/*
 * Decompiled with CFR 0.152.
 */
package math;

import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.LinkedList;
import math.DataModel;
import math.Dataset;
import math.DistStats;
import math.XYpoint;
import mlib.MLogging;
import mlib.MReport;
import utilt.Utility;

public class DataBin
implements Comparable<DataBin>,
Cloneable {
    private short iNumber = (short)-999;
    private float iBottom = 0.0f;
    private float iTop = 0.0f;
    private int iCount = -999;
    private float iModelCount = -999.0f;
    private float iWeight = 1.0f;
    private int iCombined = 1;
    private String iLabel = "";
    private LinkedList<XYpoint.Float> iObjects = null;
    public static final float TOLERANCE = 1.0E-5f;
    private static final int EMPTY = -999;

    public DataBin(float bottom, float top) {
        this.iBottom = bottom;
        this.iTop = top;
    }

    public boolean add(float value) {
        boolean added;
        boolean bl = added = value >= this.iBottom && value < this.iTop;
        if (added) {
            this.iCount = this.iCount == -999 ? 1 : ++this.iCount;
        }
        return added;
    }

    public boolean addPoint(XYpoint.Float point) {
        boolean added;
        boolean bl = added = point.y() >= (double)this.iBottom && point.y() < (double)this.iTop;
        if (added) {
            this.iCount = this.iCount == -999 ? 1 : ++this.iCount;
            if (this.iObjects == null) {
                this.iObjects = new LinkedList();
            }
            this.iObjects.add(point);
        }
        return added;
    }

    public LinkedList<XYpoint.Float> getObjects() {
        return this.iObjects;
    }

    public boolean includes(float value) {
        boolean includes = value >= this.iBottom && value < this.iTop;
        return includes;
    }

    public boolean hasValue() {
        return this.iCount != -999;
    }

    public float bottom() {
        return this.iBottom;
    }

    public void setBottom(float bottom) {
        this.iBottom = bottom;
    }

    public float top() {
        return this.iTop;
    }

    public void setTop(float top) {
        this.iTop = top;
    }

    public float center() {
        return 0.5f * (this.iBottom + this.iTop);
    }

    public float width() {
        return Math.abs(this.iTop - this.iBottom);
    }

    public float weight() {
        return this.iWeight;
    }

    public void setWeight(float weight) {
        this.iWeight = weight;
    }

    public int combined() {
        return this.iCombined;
    }

    public void setCombined(int combined) {
        this.iCombined = combined;
    }

    public float residual() {
        float res = Float.MIN_VALUE;
        if ((float)this.iCount > res) {
            res = (float)this.iCount - this.iModelCount;
        }
        return res;
    }

    public int count() {
        return this.iCount;
    }

    public void setCount(int count) {
        this.iCount = count;
    }

    public float modelCount() {
        return this.iModelCount;
    }

    public void setModelCount(float count) {
        this.iModelCount = count;
    }

    public String label() {
        return this.iLabel;
    }

    public void setLabel(String label) {
        this.iLabel = label;
    }

    public short number() {
        return this.iNumber;
    }

    public void setNumber(short number) {
        this.iNumber = number;
    }

    public Object clone() {
        DataBin copy = null;
        try {
            copy = (DataBin)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return copy;
    }

    @Override
    public int compareTo(DataBin obj) {
        int res = 0;
        if (obj != this) {
            res = -1;
            if (obj != null) {
                res = this.iCount > obj.iCount ? 1 : -1;
            }
        }
        return res;
    }

    public boolean equals(Object obj) {
        return this.compareTo((DataBin)obj) == 0;
    }

    public int hashCode() {
        return this.iCount;
    }

    public String toString() {
        String str = Utility.objPrefix(this);
        if (this.iNumber != -999) {
            str = String.valueOf(str) + this.iNumber + ",";
        }
        str = String.valueOf(str) + this.iBottom + "-" + this.iTop + ":";
        str = this.iCount == -999 ? String.valueOf(str) + "empty" : String.valueOf(str) + this.iCount;
        if (this.iModelCount != -999.0f) {
            str = String.valueOf(str) + "," + this.iModelCount;
        }
        return str;
    }

    public static class Dataset {
        private String iName = null;
        private DataBin[] iBins = null;
        private boolean iHasModel = false;
        private boolean iAccumed = false;
        private String iCombined = "";

        public static void main(String[] args) {
            try {
                Dataset dataset = new Dataset(0.0f, 10.0f, 10, "", false);
                dataset.add(new XYpoint.Float(0.0f, 0.5f));
                dataset.add(new XYpoint.Float(0.0f, 1.5f));
                dataset.add(new XYpoint.Float(0.0f, 2.5f));
                dataset.add(new XYpoint.Float(0.0f, 3.5f));
                dataset.add(new XYpoint.Float(0.0f, 3.5f));
                dataset.add(new XYpoint.Float(0.0f, 4.5f));
                dataset.add(new XYpoint.Float(0.0f, 4.5f));
                dataset.add(new XYpoint.Float(0.0f, 5.5f));
                dataset.add(new XYpoint.Float(0.0f, 5.5f));
                dataset.add(new XYpoint.Float(0.0f, 6.5f));
                dataset.add(new XYpoint.Float(0.0f, 7.5f));
                dataset.add(new XYpoint.Float(0.0f, 8.5f));
                dataset.add(new XYpoint.Float(0.0f, 9.5f));
                Dataset combined = dataset.combine(3, 3);
                System.out.println(combined);
            }
            catch (Exception xcp) {
                System.out.println(xcp);
            }
        }

        public static int defNumBins(int numObs) {
            int numBins = (int)(2.0 * Math.pow(numObs, 0.4));
            return numBins;
        }

        public static Dataset binPoints(Dataset.List<XYpoint.Float> points, int numBins, boolean addZeroBin) throws Exception {
            float min = (float)points.min().value();
            float max = (float)points.max().value();
            Dataset dataset = new Dataset(min, max, numBins, points.name(), addZeroBin);
            Iterator<XYpoint.Float> iter = points.iterator();
            while (iter.hasNext()) {
                dataset.add(iter.next());
            }
            dataset.zeroEmptyBins();
            return dataset;
        }

        public Dataset(DataBin[] bins, String name) {
            this.iBins = bins;
            this.iName = name;
        }

        public Dataset(float min, float binSize, int numBins, String name) {
            this.iName = name;
            this.iBins = new DataBin[numBins];
            float bottom = min - 1.0E-5f;
            int i = 0;
            while (i < numBins) {
                float top = bottom + binSize;
                if (i == numBins - 1) {
                    top += 2.0E-5f;
                }
                this.iBins[i] = new DataBin(bottom, top);
                this.iBins[i].setNumber((short)i);
                bottom += binSize;
                ++i;
            }
        }

        public Dataset(float min, float max, int numBins, String name, boolean addZeroBin) {
            int curZeroBinNum;
            this.iName = name;
            this.iBins = new DataBin[numBins];
            float binSize = (max - min) / (float)numBins;
            float bottom = min - 1.0E-5f;
            int i = 0;
            while (i < numBins) {
                float top = bottom + binSize;
                if (i == numBins - 1) {
                    top += 2.0E-5f;
                }
                this.iBins[i] = new DataBin(bottom, top);
                this.iBins[i].setNumber((short)i);
                bottom += binSize;
                ++i;
            }
            if (addZeroBin && (curZeroBinNum = this.binNumForValue(0.0f)) > -999) {
                DataBin[] newBins = new DataBin[numBins + 1];
                if (curZeroBinNum == 0) {
                    int i2 = 0;
                    while (i2 < this.iBins.length) {
                        newBins[i2 + 1] = this.iBins[i2];
                        short newNum = (short)(1 + newBins[i2 + 1].number());
                        newBins[i2 + 1].setNumber(newNum);
                        ++i2;
                    }
                    newBins[0] = new DataBin(-1.0E-5f, 1.0E-5f);
                    newBins[1].iBottom = 1.0E-5f;
                } else {
                    int i3 = 0;
                    while (i3 <= curZeroBinNum) {
                        newBins[i3] = this.iBins[i3];
                        ++i3;
                    }
                    newBins[curZeroBinNum].iTop = -1.0E-5f;
                    newBins[curZeroBinNum + 1] = new DataBin(-1.0E-5f, 1.0E-5f);
                    this.iBins[curZeroBinNum].iBottom = 1.0E-5f;
                    i3 = curZeroBinNum;
                    while (i3 < this.iBins.length) {
                        newBins[i3 + 1] = this.iBins[i3];
                        ++i3;
                    }
                }
                this.iBins = newBins;
            }
        }

        public String name() {
            return this.iName;
        }

        public void setName(String name) {
            this.iName = name;
        }

        public DataBin[] bins() {
            return this.iBins;
        }

        public int numBins() {
            return this.iBins.length;
        }

        public float bottom() {
            return this.iBins[0].bottom();
        }

        public float top() {
            return this.iBins[this.iBins.length - 1].top();
        }

        public boolean isAccumed() {
            return this.iAccumed;
        }

        public boolean add(XYpoint.Float point) {
            boolean added = false;
            int i = 0;
            while (!added && i < this.iBins.length) {
                added = this.iBins[i].addPoint(point);
                ++i;
            }
            return added;
        }

        public int countSum() {
            int count = 0;
            DataBin[] dataBinArray = this.iBins;
            int n = this.iBins.length;
            int n2 = 0;
            while (n2 < n) {
                DataBin bin = dataBinArray[n2];
                if (bin.hasValue()) {
                    count += bin.count();
                }
                ++n2;
            }
            return count;
        }

        public float modelCountSum() {
            int count = 0;
            DataBin[] dataBinArray = this.iBins;
            int n = this.iBins.length;
            int n2 = 0;
            while (n2 < n) {
                DataBin bin = dataBinArray[n2];
                count = (int)((float)count + bin.modelCount());
                ++n2;
            }
            return count;
        }

        public int numBinsNotEmpty() {
            int count = 0;
            DataBin[] dataBinArray = this.iBins;
            int n = this.iBins.length;
            int n2 = 0;
            while (n2 < n) {
                DataBin bin = dataBinArray[n2];
                if (bin.hasValue()) {
                    ++count;
                }
                ++n2;
            }
            return count;
        }

        public int numBinsBelowCount(int value) {
            int count = 0;
            DataBin[] dataBinArray = this.iBins;
            int n = this.iBins.length;
            int n2 = 0;
            while (n2 < n) {
                DataBin bin = dataBinArray[n2];
                if (bin.hasValue() && bin.count() < value) {
                    ++count;
                }
                ++n2;
            }
            return count;
        }

        public DataBin binForValue(float value) {
            DataBin forValue = null;
            DataBin[] dataBinArray = this.iBins;
            int n = this.iBins.length;
            int n2 = 0;
            while (n2 < n) {
                DataBin bin = dataBinArray[n2];
                if (bin.includes(value)) {
                    forValue = bin;
                }
                ++n2;
            }
            return forValue;
        }

        public int[] binCounts() {
            int[] counts = new int[this.iBins.length];
            int i = 0;
            DataBin[] dataBinArray = this.iBins;
            int n = this.iBins.length;
            int n2 = 0;
            while (n2 < n) {
                DataBin bin = dataBinArray[n2];
                counts[i++] = bin.count();
                ++n2;
            }
            return counts;
        }

        public void zeroEmptyBins() {
            DataBin[] dataBinArray = this.iBins;
            int n = this.iBins.length;
            int n2 = 0;
            while (n2 < n) {
                DataBin bin = dataBinArray[n2];
                if (!bin.hasValue()) {
                    bin.setCount(0);
                }
                ++n2;
            }
        }

        public void putModel(DataModel model) {
            DataBin[] dataBinArray = this.iBins;
            int n = this.iBins.length;
            int n2 = 0;
            while (n2 < n) {
                DataBin bin = dataBinArray[n2];
                bin.setModelCount((float)model.value(bin));
                ++n2;
            }
            this.iHasModel = true;
        }

        public Dataset.List<XYpoint.Float> convertToPoints(String listName, DecimalFormat hoverFormat, boolean setUncer) {
            Dataset.List<XYpoint.Float> points = new Dataset.List<XYpoint.Float>(listName);
            DataBin[] dataBinArray = this.iBins;
            int n = this.iBins.length;
            int n2 = 0;
            while (n2 < n) {
                DataBin bin = dataBinArray[n2];
                XYpoint.Float point = new XYpoint.Float(bin.center(), bin.count());
                String label = hoverFormat.format(bin.bottom()) + "-" + hoverFormat.format(bin.top());
                point.setLabel(label);
                if (setUncer) {
                    point.setYUncer(Math.sqrt(bin.count()));
                }
                points.add(point);
                ++n2;
            }
            return points;
        }

        public Dataset convertToPc(int totalCount) {
            DataBin[] bins = new DataBin[this.iBins.length];
            float accumError = 0.0f;
            int i = 0;
            while (i < this.iBins.length) {
                bins[i] = (DataBin)this.iBins[i].clone();
                if (bins[i].iCount == -999) {
                    bins[i].iCount = 0;
                } else {
                    float pc = 100.0f * (float)bins[i].count() / (float)totalCount;
                    int rounded = (int)((double)pc + 0.5);
                    if ((accumError += (float)rounded - pc) > 1.0f) {
                        --rounded;
                        accumError -= 1.0f;
                    } else if (accumError < -1.0f) {
                        ++rounded;
                        accumError += 1.0f;
                    }
                    bins[i].setCount(rounded);
                }
                ++i;
            }
            Dataset set = new Dataset(bins, String.valueOf(this.iName) + " as %");
            return set;
        }

        public Dataset accum() {
            DataBin[] bins = new DataBin[this.iBins.length];
            bins[0] = (DataBin)this.iBins[0].clone();
            int i = 1;
            while (i < this.iBins.length) {
                bins[i] = (DataBin)this.iBins[i].clone();
                DataBin aBin = bins[i];
                if (bins[i - 1].count() != -999) {
                    LinkedList<XYpoint.Float> objs;
                    if (aBin.count() == -999) {
                        aBin.setCount(0);
                    }
                    if ((objs = bins[i - 1].getObjects()) != null) {
                        for (XYpoint.Float obj : objs) {
                            aBin.addPoint(obj);
                        }
                    }
                    aBin.setCount(this.iBins[i].count() + bins[i - 1].count());
                }
                ++i;
            }
            Dataset set = new Dataset(bins, String.valueOf(this.iName) + "-accumulated");
            set.iAccumed = true;
            return set;
        }

        public DistStats stats() {
            DistStats stats = new DistStats(this.name());
            DataBin[] dataBinArray = this.iBins;
            int n = this.iBins.length;
            int n2 = 0;
            while (n2 < n) {
                DataBin bin = dataBinArray[n2];
                stats.add(bin.center(), bin.count());
                ++n2;
            }
            return stats;
        }

        public Dataset diff(Dataset set) {
            Dataset diff = null;
            if (this.iBins.length == set.iBins.length) {
                DataBin[] bins = new DataBin[this.iBins.length];
                int i = 0;
                while (i < bins.length) {
                    bins[i] = (DataBin)this.iBins[i].clone();
                    int count = Math.abs(this.iBins[i].count() - set.iBins[i].count());
                    bins[i].setCount(count);
                    ++i;
                }
                diff = new Dataset(bins, "difference");
            }
            return diff;
        }

        public Dataset combine(int minCount, int maxCombine) {
            LinkedList<DataBin> work = new LinkedList<DataBin>();
            int i = 0;
            while (i < this.iBins.length) {
                if (this.iBins[i].iCount >= minCount) {
                    work.add((DataBin)this.iBins[i].clone());
                    ++i;
                    continue;
                }
                int countSum = 0;
                float modelSum = 0.0f;
                float binBottom = this.iBins[i].iBottom;
                boolean more = true;
                int combined = 0;
                while (more && i < this.iBins.length) {
                    ++combined;
                    modelSum += this.iBins[i].iModelCount;
                    boolean bl = more = (countSum += this.iBins[i].iCount) < minCount;
                    if (!more) {
                        DataBin bin = new DataBin(binBottom, this.iBins[i].iTop);
                        bin.setCount(countSum);
                        bin.setModelCount(modelSum);
                        bin.setCombined(combined);
                        if (combined > maxCombine) {
                            bin.setWeight(0.0f);
                        }
                        work.add(bin);
                    }
                    ++i;
                }
            }
            DataBin[] bins = new DataBin[work.size()];
            i = 0;
            for (DataBin bin : work) {
                bin.setNumber((short)i);
                bins[i++] = bin;
            }
            Dataset combined = new Dataset(bins, "combined");
            combined.iCombined = minCount + "," + maxCombine;
            return combined;
        }

        public void print(MLogging logger) {
            logger.writeln(String.valueOf(Utility.objPrefix(this)) + this.iName + ", " + this.countSum() + " points:", false);
            DataBin[] dataBinArray = this.iBins;
            int n = this.iBins.length;
            int n2 = 0;
            while (n2 < n) {
                DataBin bin = dataBinArray[n2];
                logger.writeln(bin.toString(), false);
                ++n2;
            }
            logger.writeln("total: " + this.countSum(), false);
        }

        public void append(MReport report) {
            DataBin[] dataBinArray = this.iBins;
            int n = this.iBins.length;
            int n2 = 0;
            while (n2 < n) {
                DataBin bin = dataBinArray[n2];
                report.addLine(bin.toString());
                ++n2;
            }
            report.addLine("total: " + this.countSum());
        }

        public String combined() {
            return this.iCombined;
        }

        public String toString() {
            String str = String.valueOf(Utility.objPrefix(this)) + this.iName + ":";
            DataBin[] dataBinArray = this.iBins;
            int n = this.iBins.length;
            int n2 = 0;
            while (n2 < n) {
                DataBin bin = dataBinArray[n2];
                str = String.valueOf(str) + bin.count() + ",";
                ++n2;
            }
            str = String.valueOf(str) + this.countSum() + ",";
            str = String.valueOf(str) + this.numBinsNotEmpty() + ",";
            str = String.valueOf(str) + this.iCombined + ",";
            str = String.valueOf(str) + this.iHasModel;
            return str;
        }

        private int binNumForValue(float value) {
            int num = -999;
            int i = 0;
            while (i < this.iBins.length) {
                if (this.iBins[i].includes(value)) {
                    num = i;
                }
                ++i;
            }
            return num;
        }
    }
}

