/*
 * Decompiled with CFR 0.152.
 */
package help;

import help.HelpListener;
import help.HelpPrefs;
import help.HelpTree;
import help.InfoPanel;
import help.SelectionPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import javax.swing.JSplitPane;
import swing.ColorPanel;
import swing.SwingProgram;

public class HelpPanel
extends ColorPanel {
    private JSplitPane jSplitPane = null;
    private InfoPanel jInfoPanel = null;
    private SelectionPanel jSelectionPanel = null;
    private HelpPrefs iPrefs = null;

    public HelpPanel(HelpPrefs prefs) {
        this.iPrefs = prefs;
        this.setLayout(new GridLayout(0, 1));
        this.setBackground(prefs.backColor());
        this.jInfoPanel = new InfoPanel(prefs);
        this.jInfoPanel.setBorder(SwingProgram.STDBORDER);
        this.jSelectionPanel = new SelectionPanel(prefs);
        this.jSelectionPanel.setInfoPanel(this.jInfoPanel);
        this.jSelectionPanel.setBorder(SwingProgram.STDBORDER);
        this.add(this.getSplitPane());
    }

    public void addHelpListener(HelpListener lis) {
        this.jSelectionPanel.addHelpListener(lis);
    }

    public void removeHelpListener(HelpListener lis) {
        this.jSelectionPanel.removeHelpListener(lis);
    }

    void putTree(HelpTree tree) {
        this.jSelectionPanel.setTree(tree);
    }

    void expandAllNodes() {
        this.jSelectionPanel.expandAllNodes();
    }

    void selectFirstTopic() {
        this.jSelectionPanel.topicsTree().setSelectionRow(0);
        Dimension treeSize = this.jSelectionPanel.topicsTree().getPreferredSize();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int pos = treeSize.width;
        int minWidth = screen.width / 5;
        if (pos < minWidth) {
            pos = minWidth;
        }
        pos += pos / 10;
        this.getSplitPane().setDividerLocation(pos);
        this.jSelectionPanel.clearFind();
    }

    private JSplitPane getSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane(1);
            this.jSplitPane.setBackground(this.iPrefs.backColor());
            this.jSplitPane.add((Component)this.jInfoPanel, "right");
            this.jSplitPane.add((Component)this.jSelectionPanel, "left");
        }
        return this.jSplitPane;
    }
}

