/*
 * Decompiled with CFR 0.152.
 */
package help;

import help.SelectionPanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import swing.ColorButton;
import swing.EntryField;
import swing.Indicator;

class FindPanel
extends JPanel {
    private ColorButton jFindButton = null;
    private EntryField jFindField = null;
    private SelectionPanel iSelPanel = null;
    private ColorButton jClearButton = null;
    private Indicator jFindIndicator = null;

    FindPanel() {
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.getFindIndicator());
        this.add(this.getFindField());
        this.add(this.getFindButton());
        this.add(this.getClearButton());
        FindHandler handler = new FindHandler();
        this.getFindButton().addActionListener(handler);
        this.getClearButton().addActionListener(handler);
        this.getFindField().addActionListener(handler);
    }

    void putIndicator(Color color, String text) {
        this.getFindIndicator().setBackground(color);
        this.getFindIndicator().setText(text);
        this.getFindField().requestFocus();
        this.repaint();
    }

    void putTextFont(Font font) {
        this.getFindField().setFont(font);
        this.getFindButton().setFont(font);
        this.getClearButton().setFont(font);
        Font indicator = new Font("Monospaced", 1, font.getSize());
        this.getFindIndicator().setFont(indicator);
    }

    void setSelPanel(SelectionPanel newSelPanel) {
        this.iSelPanel = newSelPanel;
    }

    private ColorButton getClearButton() {
        if (this.jClearButton == null) {
            this.jClearButton = new ColorButton();
            this.jClearButton.setToolTipText("Clear found");
            this.jClearButton.setMnemonic('C');
            this.jClearButton.setText("Clear");
        }
        return this.jClearButton;
    }

    private ColorButton getFindButton() {
        if (this.jFindButton == null) {
            this.jFindButton = new ColorButton();
            this.jFindButton.setToolTipText("Find text");
            this.jFindButton.setMnemonic('S');
            this.jFindButton.setText("Search");
        }
        return this.jFindButton;
    }

    private EntryField getFindField() {
        if (this.jFindField == null) {
            this.jFindField = new EntryField();
            this.jFindField.setColumns(10);
        }
        return this.jFindField;
    }

    private Indicator getFindIndicator() {
        if (this.jFindIndicator == null) {
            this.jFindIndicator = new Indicator();
            this.jFindIndicator.setName("FindIndicator");
            this.jFindIndicator.setAlignmentX(0.5f);
        }
        return this.jFindIndicator;
    }

    private class FindHandler
    implements ActionListener {
        private FindHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() != FindPanel.this.getClearButton()) {
                String toFind = FindPanel.this.getFindField().getText();
                if (toFind == null) {
                    FindPanel.this.iSelPanel.clearFind();
                } else {
                    FindPanel.this.iSelPanel.doFind(toFind.trim());
                }
            } else {
                FindPanel.this.iSelPanel.clearFind();
                FindPanel.this.getFindField().setText("");
            }
            FindPanel.this.getFindField().requestFocus();
        }
    }
}

