/*
 * Decompiled with CFR 0.152.
 */
package files;

import files.Filesystem;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TreeSet;
import mlib.MString;
import org.apache.commons.net.ftp.FTPFile;
import utilt.Utility;

public abstract class FileInfo
implements Comparable<FileInfo> {
    private Filesystem iFileSys = null;
    private TreeSet<FileInfo> iDirectChildren = new TreeSet();
    public static final char DIRCHAR = '/';
    public static final String DIRSTR = "/";
    public static final String NOTFOLDER = "Not a folder: ";
    public static final String FOLDERNOTFOUND = "Folder not found: ";
    public static final String FOLDERREQD = "Can add child only to folder";

    public Filesystem fileSys() {
        return this.iFileSys;
    }

    public String fileSysPath() {
        MString path = new MString(this.path());
        MString work = new MString(this.iFileSys.rootDir().path());
        work.trim('/');
        path.remove(work, 1, 0);
        path.trim('/');
        return path.toString();
    }

    @Override
    public int compareTo(FileInfo fileInfo) {
        int result = 0;
        if (fileInfo != this) {
            result = -1;
            if (fileInfo != null) {
                result = this.path().compareTo(fileInfo.path());
            }
        }
        return result;
    }

    public boolean equals(FileInfo info) {
        boolean equal = this.compareTo(info) == 0;
        return equal;
    }

    public int hashCode() {
        return this.path().hashCode();
    }

    public void addChild(FileInfo child) throws Exception {
        if (!this.isDir()) {
            Utility.throwError(FOLDERREQD);
        } else {
            this.iDirectChildren.add(child);
        }
    }

    public TreeSet<FileInfo> directChildren() {
        return this.iDirectChildren;
    }

    public TreeSet<FileInfo> allChildren() {
        TreeSet<FileInfo> all = new TreeSet<FileInfo>();
        this.accumChildren(all);
        return all;
    }

    public String extension() {
        String ext = "";
        int index = this.path().lastIndexOf(46);
        if (index > 0) {
            ext = this.path().substring(index);
        }
        return ext;
    }

    public String toString() {
        Date date = new Date(this.timestamp());
        String str = String.valueOf(Utility.objPrefix(this)) + this.path() + "," + this.isDir() + "," + date + "," + this.size();
        return str;
    }

    public abstract String name();

    public abstract String path();

    public abstract long size();

    public abstract boolean isDir();

    public abstract long timestamp();

    public abstract void setTimestamp(long var1);

    public abstract boolean exists();

    public abstract void delete() throws Exception;

    protected FileInfo(Filesystem fs) {
        this.iFileSys = fs;
    }

    private void accumChildren(TreeSet<FileInfo> infos) {
        for (FileInfo info : this.iDirectChildren) {
            if (info.isDir()) {
                info.accumChildren(infos);
                continue;
            }
            infos.add(info);
        }
    }

    public static class Apache
    extends FileInfo {
        private FTPFile iFile = null;
        private String iName = null;
        private String iPath = null;

        public Apache(Filesystem fs, FTPFile file, String dirPath) {
            super(fs);
            this.iFile = file;
            this.iName = this.iFile.getName();
            if (!dirPath.endsWith(FileInfo.DIRSTR)) {
                dirPath = String.valueOf(dirPath) + FileInfo.DIRSTR;
            }
            this.iPath = String.valueOf(dirPath) + this.iFile.getName();
        }

        public Apache(Filesystem fs, String path) {
            super(fs);
            this.iPath = path;
            if (!this.iPath.endsWith(FileInfo.DIRSTR)) {
                this.iPath = String.valueOf(this.iPath) + '/';
            }
            String name = path;
            int index = path.lastIndexOf(47);
            if (index >= 0) {
                name = path.substring(index + 1);
            }
            this.iName = name;
        }

        @Override
        public String name() {
            return this.iName;
        }

        @Override
        public String path() {
            return this.iPath;
        }

        @Override
        public long size() {
            return this.iFile.getSize();
        }

        @Override
        public boolean isDir() {
            boolean isDir;
            boolean bl = isDir = this.iFile == null;
            if (!isDir) {
                isDir = this.iFile.isDirectory();
            }
            return isDir;
        }

        @Override
        public long timestamp() {
            Calendar date = this.iFile.getTimestamp();
            return date.getTime().getTime();
        }

        @Override
        public void setTimestamp(long time) {
            if (!this.isDir()) {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(new Date(time));
                this.iFile.setTimestamp((Calendar)cal);
            }
        }

        @Override
        public boolean exists() {
            boolean exists = this.iFile.getTimestamp() != null;
            return exists;
        }

        @Override
        public void delete() throws Exception {
            Utility.throwError("Not implemented");
        }
    }

    public static class Local
    extends FileInfo {
        private File iFile = null;

        public Local(File file) throws Exception {
            super(new Filesystem.Local(file.getParent(), true));
            this.iFile = file;
        }

        public Local(Filesystem fs, String relPath) {
            super(fs);
            String path = String.valueOf(fs.rootDir().path()) + relPath;
            this.iFile = new File(path);
        }

        public Local(Filesystem fs, File file) {
            super(fs);
            this.iFile = file;
        }

        @Override
        public String name() {
            return this.iFile.getName();
        }

        @Override
        public String path() {
            MString work = new MString(this.iFile.getPath());
            work.replace('\\', '/');
            if (this.isDir() && !work.endsWith('/')) {
                work.concat('/');
            }
            return work.toString();
        }

        public String pathNoTerm() {
            MString work = new MString(this.iFile.getPath());
            work.trimTail('\\');
            work.trimTail('/');
            return work.toString();
        }

        @Override
        public long size() {
            return this.iFile.length();
        }

        @Override
        public boolean isDir() {
            return this.iFile.isDirectory();
        }

        @Override
        public long timestamp() {
            return this.iFile.lastModified();
        }

        @Override
        public void setTimestamp(long time) {
            this.iFile.setLastModified(time);
        }

        @Override
        public boolean exists() {
            return this.iFile.exists();
        }

        @Override
        public void delete() {
            this.iFile.delete();
        }
    }
}

