/*
 * Decompiled with CFR 0.152.
 */
package filedialog;

import filedialog.FileChooser;
import filedialog.FilePanel;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import mswing.ThumbnailImage;
import popup.PopupObject;
import popup.PopupPanel;

public class FilePopupObject
implements PopupObject {
    private FilePanel iPanel = null;
    private String iName = null;
    private String iLabel = null;
    private int iType = 0;
    private boolean iUseThumbnail = false;
    public static final int DIR = 0;
    public static final int FILE = 1;
    public static final int DRIVE = 2;

    FilePopupObject(FilePanel panel, int type) {
        this.iType = type;
        this.iPanel = panel;
    }

    public String getName() {
        return this.iName;
    }

    public int getType() {
        return this.iType;
    }

    @Override
    public void handleEvent(PopupPanel panel, boolean doubleClicked, String menuCmd) {
        if (doubleClicked) {
            if (this.iType == 0) {
                this.iPanel.showDir(this.iName);
            } else if (this.iType == 2) {
                this.iPanel.showDir(this.iName);
            }
        }
    }

    @Override
    public Icon thumb() {
        ImageIcon ic = null;
        if (this.iType == 0) {
            ic = FileChooser.dirIcon();
        } else if (this.iType == 2) {
            ic = FileChooser.driveIcon();
        } else {
            ic = FileChooser.fileIcon();
            if (this.iUseThumbnail && this.iType == 1) {
                ic = FileChooser.fileIcon();
                ThumbnailImage thumb = new ThumbnailImage();
                BufferedImage image = null;
                image = FileChooser.loadImage(this.iName);
                if (image != null) {
                    try {
                        thumb.setup(image, this.iPanel.getFileChooser().thumbSize());
                        ic = thumb.getIcon();
                        image = null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return ic;
    }

    @Override
    public String label() {
        return this.iLabel;
    }

    @Override
    public String id() {
        return this.iName;
    }

    @Override
    public JPopupMenu menu() {
        return null;
    }

    void setName(String name) {
        this.iName = name;
        if (this.iType == 2) {
            this.iLabel = this.iName;
            this.iName = String.valueOf(this.iName) + File.separator;
        } else {
            int lastDelim = name.lastIndexOf(File.separator);
            this.iLabel = name.substring(lastDelim + 1);
        }
    }

    void setUseThumbnail(boolean use) {
        this.iUseThumbnail = use;
    }

    @Override
    public int compareTo(PopupObject obj) {
        int result = 0;
        if (obj != this) {
            result = -1;
            if (obj != null && obj.getClass() == FilePopupObject.class) {
                FilePopupObject theObj = (FilePopupObject)obj;
                result = this.iName.compareToIgnoreCase(theObj.iName);
            }
        }
        return result;
    }

    @Override
    public boolean equalTo(Object obj) {
        return this.compareTo((FilePopupObject)obj) == 0;
    }

    public String toString() {
        return this.iName;
    }
}

