/*
 * Decompiled with CFR 0.152.
 */
package filedialog;

import java.io.File;

public class FileChooserFilter {
    private String[] iExts = null;
    boolean iDirsOnly = false;
    boolean iAcceptDirs = true;
    private String iDesc = "";

    public FileChooserFilter(String[] exts, boolean dirsOnly, boolean acceptDirs, String desc) {
        if (exts != null) {
            int i = 0;
            while (i < exts.length) {
                exts[i] = exts[i].toLowerCase();
                ++i;
            }
        }
        this.iExts = exts;
        this.iDesc = desc;
        this.iDirsOnly = dirsOnly;
        this.iAcceptDirs = acceptDirs;
    }

    public String[] getExts() {
        return this.iExts;
    }

    public String getDesc() {
        return this.iDesc;
    }

    public boolean isDirsOnly() {
        return this.iDirsOnly;
    }

    public boolean isAcceptDirs() {
        return this.iAcceptDirs;
    }

    public boolean accept(File file) {
        boolean accept;
        String fileName = file.getName();
        boolean bl = accept = !fileName.startsWith(".");
        if (accept) {
            accept = this.iDirsOnly ? file.isDirectory() : (file.isDirectory() ? this.iAcceptDirs : this.matchesExts(file));
        }
        return accept;
    }

    public boolean ignore(File file) {
        return false;
    }

    public boolean matchesExts(File file) {
        boolean matches = false;
        if (this.iExts == null) {
            matches = true;
        } else {
            String name = file.getName().toLowerCase();
            int i = 0;
            while (!matches && i < this.iExts.length) {
                matches = name.endsWith(this.iExts[i]);
                ++i;
            }
        }
        return matches;
    }
}

