/*
 * Decompiled with CFR 0.152.
 */
package dialog;

import dialog.DialogEvent;
import dialog.DialogListener;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import swing.ColorButton;
import swing.ControlButton;

public class DialogButtons
extends JPanel {
    private ColorButton jCancelButton = null;
    private ColorButton jAcceptButton = null;
    private LinkedList<DialogListener> iLis = new LinkedList();
    private int iCurIndex = -1;
    private Component[] iComponents = new Component[16];
    private ActionListener iHandler = null;
    private boolean iHasAccept = false;
    private boolean iHasCancel = false;
    private static final int MAXCOMPS = 16;

    public DialogButtons() {
        this.initialize(true, true);
    }

    public DialogButtons(boolean acceptButton, boolean cancelButton) {
        this.initialize(acceptButton, cancelButton);
    }

    public void addButtonListener(DialogListener lis) {
        this.iLis.add(lis);
    }

    public int addCustomButton(String label, char mnemonic, ImageIcon icon, String tip) {
        int index = this.findButton(label);
        if (index < 0) {
            ++this.iCurIndex;
            if (label != null) {
                ColorButton button = new ColorButton();
                button.setText(label);
                button.setMnemonic(mnemonic);
                button.setToolTipText(tip);
                button.addActionListener(this.iHandler);
                this.iComponents[this.iCurIndex] = button;
            } else {
                this.iComponents[this.iCurIndex] = new ControlButton(tip, icon, mnemonic);
            }
            index = this.iCurIndex;
        }
        this.addComps();
        return index;
    }

    public int addComp(Component comp) {
        ++this.iCurIndex;
        this.iComponents[this.iCurIndex] = comp;
        return this.iCurIndex;
    }

    public void enableCustomButton(int index, boolean enable) {
        Component comp;
        if (!enable) {
            this.getAcceptButton().requestFocus();
        }
        if ((comp = this.iComponents[index]) != null) {
            comp.setEnabled(enable);
        }
    }

    public void removeCustomButton(int index) {
        this.iComponents[index] = null;
    }

    public void enableButtons(boolean enable) {
        this.getAcceptButton().setEnabled(enable);
        this.getCancelButton().setEnabled(enable);
        Component[] componentArray = this.iComponents;
        int n = this.iComponents.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (comp != null) {
                comp.setEnabled(enable);
            }
            ++n2;
        }
    }

    public void enableAcceptButton(boolean enable) {
        this.getAcceptButton().setEnabled(enable);
    }

    public void enableCancelButton(boolean enable) {
        this.getCancelButton().setEnabled(enable);
    }

    public void putAcceptLabel(String label, char mnemonic) {
        this.getAcceptButton().setText(label);
        this.getAcceptButton().setMnemonic(mnemonic);
    }

    public void putCancelLabel(String label, char mnemonic) {
        this.getCancelButton().setText(label);
        this.getCancelButton().setMnemonic(mnemonic);
    }

    public void putCustomLabel(String curLabel, String newLabel) {
        int index = this.findButton(curLabel);
        if (index >= 0 && this.iComponents[index].getClass().equals(ColorButton.class)) {
            ColorButton button = (ColorButton)this.iComponents[index];
            button.setText(newLabel);
        }
    }

    public void removeButtonListener(DialogListener lis) {
        this.iLis.remove(lis);
    }

    public void removeCancelButton() {
        this.remove(this.getCancelButton());
        this.iHasCancel = false;
    }

    public void removeAcceptButton() {
        this.remove(this.getAcceptButton());
        this.iHasAccept = false;
    }

    @Override
    public void setFont(Font newFont) {
        if (this.iComponents != null) {
            this.getAcceptButton().setFont(newFont);
            this.getCancelButton().setFont(newFont);
            int i = 0;
            while (i <= this.iCurIndex) {
                if (this.iComponents[i] != null) {
                    this.iComponents[i].setFont(newFont);
                }
                ++i;
            }
        }
    }

    private void addComps() {
        this.removeAll();
        if (this.iHasAccept) {
            this.add(this.getAcceptButton());
        }
        Component[] componentArray = this.iComponents;
        int n = this.iComponents.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            if (comp != null) {
                this.add(comp);
            }
            ++n2;
        }
        if (this.iHasCancel) {
            this.add(this.getCancelButton());
        }
    }

    private int findButton(String label) {
        int index = -1;
        if (label != null) {
            int i = 0;
            while (i <= this.iCurIndex && index == -1) {
                ColorButton button;
                if (this.iComponents[i] != null && this.iComponents[i].getClass().equals(ColorButton.class) && (button = (ColorButton)this.iComponents[i]).getText().startsWith(label)) {
                    index = i;
                }
                ++i;
            }
        }
        return index;
    }

    private void fireAccept() {
        DialogEvent event = new DialogEvent(this);
        for (DialogListener lis : this.iLis) {
            lis.accept(event);
        }
    }

    private void fireCancel() {
        DialogEvent event = new DialogEvent(this);
        for (DialogListener lis : this.iLis) {
            lis.cancel(event);
        }
    }

    private void fireCustom(int index) {
        DialogEvent event = new DialogEvent(this);
        for (DialogListener lis : this.iLis) {
            lis.custom(index, event);
        }
    }

    private ColorButton getAcceptButton() {
        if (this.jAcceptButton == null) {
            this.jAcceptButton = new ColorButton();
            this.jAcceptButton.setMnemonic('A');
            this.jAcceptButton.setText(" Accept ");
        }
        return this.jAcceptButton;
    }

    private ColorButton getCancelButton() {
        if (this.jCancelButton == null) {
            this.jCancelButton = new ColorButton();
            this.jCancelButton.setMnemonic('C');
            this.jCancelButton.setText(" Cancel ");
        }
        return this.jCancelButton;
    }

    private void initialize(boolean acceptButton, boolean cancelButton) {
        this.setLayout(new FlowLayout());
        this.setBackground(SystemColor.control);
        this.iHandler = new ActionHandler();
        this.iHasAccept = acceptButton;
        this.iHasCancel = cancelButton;
        if (this.iHasAccept) {
            this.add(this.getAcceptButton());
            this.getAcceptButton().addActionListener(this.iHandler);
        }
        if (this.iHasCancel) {
            this.add(this.getCancelButton());
            this.getCancelButton().addActionListener(this.iHandler);
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == DialogButtons.this.getAcceptButton()) {
                DialogButtons.this.fireAccept();
            } else if (event.getSource() == DialogButtons.this.getCancelButton()) {
                DialogButtons.this.fireCancel();
            } else {
                boolean done = false;
                int i = 0;
                while (!done && i <= DialogButtons.this.iCurIndex) {
                    if (event.getSource() == DialogButtons.this.iComponents[i]) {
                        DialogButtons.this.fireCustom(i);
                        done = true;
                    }
                    ++i;
                }
            }
        }
    }
}

