/*
 * Decompiled with CFR 0.152.
 */
package dialog;

import dialog.CenteredDialog;
import dialog.DialogEvent;
import java.awt.Font;
import java.awt.Frame;
import java.awt.SystemColor;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import swing.PanelLabel;
import swing.SwingProgram;

public class ConfirmDialog
extends CenteredDialog {
    private JLabel iMsg = new JLabel();
    private JPanel iMsgPanel = new JPanel();
    private boolean iAccepted = false;

    public ConfirmDialog(Frame owner, String title, String msg, Icon icon) {
        super(owner, title, true);
        this.iMsgPanel = new MsgPanel(icon, msg);
        this.addClientPanel(this.iMsgPanel);
        this.iMsgPanel.setBorder(SwingProgram.STDBORDER);
        this.center(0.4, 0.15);
        this.setFont(PanelLabel.fontAll());
        this.setFocusComp(this.iMsgPanel);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.iMsg.setFont(font);
    }

    @Override
    public void accept(DialogEvent event) {
        this.iAccepted = true;
        this.dispose();
    }

    public boolean display() {
        this.iMsg.setFont(this.getFont());
        super.setVisible(true);
        return this.iAccepted;
    }

    @Override
    public void putAcceptLabel(String label, char mnemonic) {
        this.buttons().putAcceptLabel(label, mnemonic);
    }

    @Override
    public void custom(int index, DialogEvent event) {
    }

    private class MsgPanel
    extends JPanel {
        MsgPanel(Icon icon, String msg) {
            this.setLayout(new BoxLayout(this, 0));
            this.add(Box.createHorizontalStrut(10));
            this.add(new JLabel(icon));
            this.add(Box.createHorizontalStrut(10));
            this.setBackground(CenteredDialog.backColorAll());
            ConfirmDialog.this.iMsg.setForeground(SystemColor.windowText);
            ConfirmDialog.this.iMsg.setBackground(CenteredDialog.backColorAll());
            ConfirmDialog.this.iMsg.setForeground(SystemColor.windowText);
            ConfirmDialog.this.iMsg.setHorizontalAlignment(0);
            ConfirmDialog.this.iMsg.setText(msg);
            ConfirmDialog.this.iMsg.setOpaque(true);
            this.add(ConfirmDialog.this.iMsg);
        }
    }
}

