/*
 * Decompiled with CFR 0.152.
 */
package dialog;

import dialog.DialogButtons;
import dialog.DialogEvent;
import dialog.DialogListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import mswing.WindowPos;
import utilt.Utility;

public abstract class CenteredDialog
extends JDialog
implements DialogListener {
    private DialogButtons jButtons = new DialogButtons(true, true);
    private Component iFocusComp = null;
    private JComponent jClientPanel = null;
    private static LinkedList<CenteredDialog> Instances = new LinkedList();
    private static Color AllFore = SystemColor.windowText;
    private static Color AllBack = SystemColor.window;
    private static Font AllFont = Utility.stdFont();

    public static Color buttonColor() {
        return SystemColor.control;
    }

    public static Color backColorAll() {
        return AllBack;
    }

    public static void putBackColorAll(Color back) {
        AllBack = back;
        for (CenteredDialog dialog : Instances) {
            dialog.setBackground(AllBack);
            dialog.getClientPanel().setBackground(AllBack);
        }
    }

    public static void putFontAll(Font font) {
        AllFont = font;
        for (CenteredDialog dialog : Instances) {
            dialog.setFont(AllFont);
        }
    }

    public static void putForeColorAll(Color fore) {
        AllFore = fore;
        for (CenteredDialog dialog : Instances) {
            dialog.setForeground(AllFore);
        }
    }

    public CenteredDialog() {
        this.initialize(true);
    }

    public CenteredDialog(Dialog owner) {
        super(owner);
        this.initialize(true);
    }

    public CenteredDialog(Frame owner) {
        super(owner);
        this.initialize(true);
    }

    public CenteredDialog(Frame owner, String title) {
        super(owner, title);
        this.initialize(true);
    }

    public CenteredDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.initialize(modal);
    }

    public CenteredDialog(Frame owner, boolean modal) {
        super(owner, modal);
        this.initialize(modal);
    }

    public void addClientPanel(JComponent comp) {
        this.jClientPanel.removeAll();
        this.jClientPanel.add(comp);
        this.jClientPanel.validate();
    }

    @Override
    public void accept(DialogEvent event) {
    }

    public int addCustomButton(String label, char mnemonic, ImageIcon icon, String tip) {
        return this.jButtons.addCustomButton(label, mnemonic, icon, tip);
    }

    public int addComp(Component comp) {
        return this.jButtons.addComp(comp);
    }

    public void enableCustomButton(int index, boolean enable) {
        this.jButtons.enableCustomButton(index, enable);
    }

    public void removeCustomButton(int index) {
        this.jButtons.removeCustomButton(index);
    }

    @Override
    public void cancel(DialogEvent event) {
        this.dispose();
    }

    public int center(double horzFrac, double vertFrac) {
        Toolkit tKit = Toolkit.getDefaultToolkit();
        Dimension screen = tKit.getScreenSize();
        int width = (int)(horzFrac * screen.getWidth() + 0.5);
        int height = (int)(vertFrac * screen.getHeight() + 0.5);
        this.setSize(width, height);
        int x = (int)(screen.getWidth() - (double)width) / 2;
        int y = (int)(screen.getHeight() - (double)height) / 2;
        this.setLocation(x, y);
        return Math.max(width, height);
    }

    public int center(double horzFrac, double vertFrac, int maxWidth, int maxHeight) {
        Toolkit tKit = Toolkit.getDefaultToolkit();
        Dimension screen = tKit.getScreenSize();
        int width = (int)(horzFrac * screen.getWidth() + 0.5);
        int height = (int)(vertFrac * screen.getHeight() + 0.5);
        if (width > maxWidth) {
            width = maxWidth;
        }
        if (height > maxHeight) {
            height = maxHeight;
        }
        this.setSize(width, height);
        int x = (int)(screen.getWidth() - (double)width) / 2;
        int y = (int)(screen.getHeight() - (double)height) / 2;
        this.setLocation(x, y);
        return Math.max(width, height);
    }

    public int center(int width, int height) {
        Toolkit tKit = Toolkit.getDefaultToolkit();
        Dimension screen = tKit.getScreenSize();
        this.setSize(width, height);
        int x = (int)(screen.getWidth() - (double)width) / 2;
        int y = (int)(screen.getHeight() - (double)height) / 2;
        this.setLocation(x, y);
        return Math.max(width, height);
    }

    public int centerTop(double vertFrac) {
        Toolkit tKit = Toolkit.getDefaultToolkit();
        Dimension screen = tKit.getScreenSize();
        int width = (int)screen.getWidth();
        int height = (int)(vertFrac * screen.getHeight() + 0.5);
        this.setSize(width, height);
        this.setLocation(0, 0);
        return Math.max(width, height);
    }

    public void enableButtons(boolean enable) {
        this.jButtons.enableButtons(enable);
        this.jButtons.repaint();
    }

    public void enableAcceptButton(boolean enable) {
        this.jButtons.enableAcceptButton(enable);
    }

    public void enableCancelButton(boolean enable) {
        this.jButtons.enableCancelButton(enable);
    }

    public void putAcceptLabel(String label, char mnemonic) {
        this.jButtons.putAcceptLabel(label, mnemonic);
    }

    public void putCancelLabel(String label, char mnemonic) {
        this.jButtons.putCancelLabel(label, mnemonic);
    }

    public Component focusComp() {
        return this.iFocusComp;
    }

    public void setFocusComp(Component comp) {
        this.iFocusComp = comp;
    }

    protected DialogButtons buttons() {
        return this.jButtons;
    }

    public void removeCancelButton() {
        this.jButtons.removeCancelButton();
    }

    public void removeAcceptButton() {
        this.jButtons.removeAcceptButton();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.jButtons.setFont(font);
    }

    public void putCustomLabel(String curLabel, String newLabel) {
        this.jButtons.putCustomLabel(curLabel, newLabel);
    }

    public WindowPos windowPos() {
        return null;
    }

    private void initialize(boolean modal) {
        this.setDefaultCloseOperation(2);
        this.setModal(modal);
        this.getContentPane().setLayout(new BorderLayout());
        this.setBackground(AllBack);
        this.getContentPane().add((Component)this.jButtons, "South");
        this.getContentPane().add((Component)this.getClientPanel(), "Center");
        this.center(0.5, 0.5);
        this.jButtons.addButtonListener(this);
        this.addWindowListener(new WindowHandler());
    }

    private JComponent getClientPanel() {
        if (this.jClientPanel == null) {
            GridLayout gridLayout1 = new GridLayout();
            this.jClientPanel = new JPanel();
            this.jClientPanel.setLayout(gridLayout1);
            this.jClientPanel.setBackground(AllBack);
            gridLayout1.setRows(1);
        }
        return this.jClientPanel;
    }

    @Override
    public abstract void custom(int var1, DialogEvent var2);

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowOpened(WindowEvent event) {
            if (CenteredDialog.this.iFocusComp != null) {
                CenteredDialog.this.iFocusComp.requestFocus();
            }
        }
    }
}

