/*
 * Decompiled with CFR 0.152.
 */
package cmdproc;

import clp.ClpCmd;
import cmdproc.BpmClp;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import math.DataBin;
import math.XYpoint;
import mlib.MAppMsg;
import mlib.MLogger;
import mlib.MReport;
import mlib.MString;
import oroma.db.Database;
import oroma.db.ExifTags;
import oroma.db.PicInfo;
import oroma.db.Query;
import oroma.gui.BpmMsgs;
import utilt.BinnedDb;
import utilt.Utility;

public class ListCmds {
    private ListCmds() {
    }

    private static void doComboField(String name, Query query, Database db, MReport report) throws Exception {
        TreeMap<String, Integer> counts = new TreeMap<String, Integer>();
        TreeSet<PicInfo> infos = db.selectPicInfos(query);
        for (PicInfo info : infos) {
            MString value = info.comboField(name).webDisplayValue();
            if (value == null || value.length() <= 0) continue;
            Integer count = (Integer)counts.get(value.toString());
            count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
            counts.put(value.toString(), count);
        }
        Set mappings = counts.entrySet();
        int total = 0;
        for (Map.Entry entry : mappings) {
            String str = String.valueOf((String)entry.getKey()) + ": " + entry.getValue();
            report.addLine(str);
            total += ((Integer)entry.getValue()).intValue();
        }
        report.addLine("total: " + total);
    }

    private static void doResolution(Query query, Database db, MReport report) {
        DataBin[] bins = new DataBin[8];
        DataBin.Dataset dataset = new DataBin.Dataset(bins, "resolution");
        bins[0] = new DataBin(0.0f, 5.0f);
        bins[1] = new DataBin(5.0f, 10.0f);
        bins[2] = new DataBin(10.0f, 15.0f);
        bins[3] = new DataBin(15.0f, 20.0f);
        bins[4] = new DataBin(20.0f, 25.0f);
        bins[5] = new DataBin(25.0f, 30.0f);
        bins[6] = new DataBin(30.0f, 50.0f);
        bins[7] = new DataBin(50.0f, 100.0f);
        TreeSet<PicInfo> infos = db.selectPicInfos(query);
        for (PicInfo info : infos) {
            XYpoint.Float res = new XYpoint.Float(0.0f, info.resMp());
            dataset.add(res);
        }
        dataset.append(report);
    }

    public static class AlbumFieldDistCmd
    extends ClpCmd {
        public AlbumFieldDistCmd() throws Exception {
            super("list field distribution for album");
            this.add(new ClpCmd.Arg("list", false));
            this.add(new ClpCmd.Arg("album", false));
            ClpCmd.Arg arg = this.arg("album");
            arg.add(new ClpCmd.Option("*album name"));
            this.add(new ClpCmd.Arg("field", false));
            arg = this.arg("field");
            arg.add(new ClpCmd.Option("*field name"));
            this.add(new BpmClp.DbOpened());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws Exception {
            MReport report = new MReport("Album Field Report");
            Database db = Database.singleton();
            report.addLine(db.toString());
            Database database = db;
            synchronized (database) {
                Query query = null;
                String albumName = this.arg("album").firstOptionValue();
                query = albumName.equals("*") ? new Query() : db.query(albumName, true);
                String parm = this.arg("field").firstOptionValue();
                report.addLine("Album: " + albumName + ", parameter: " + parm);
                if (parm.equalsIgnoreCase("resolution")) {
                    ListCmds.doResolution(query, db, report);
                } else {
                    PicInfo info = query.picInfo();
                    PicInfo.ComboField field = info.comboField(parm);
                    if (field == null) {
                        report.addLine("ComboField not found: " + parm);
                    } else {
                        ListCmds.doComboField(field.name(), query, db, report);
                    }
                }
            }
            report.writeTo(this.clp().logger());
            MLogger rptLogger = BpmClp.reportLogger(this, report);
            report.writeTo(rptLogger);
            MAppMsg appMsg = BpmMsgs.get("saved");
            this.clp().logger().writeln(appMsg.format(report.title()));
        }
    }

    public static class AlbumsCmd
    extends ClpCmd {
        public AlbumsCmd() throws Exception {
            super("list albums by name");
            this.add(new ClpCmd.Arg("list", false));
            this.add(new ClpCmd.Arg("albums", false));
            this.add(new BpmClp.DbOpened());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws Exception {
            MReport report = new MReport("Albums Report");
            Database db = Database.singleton();
            report.addLine(db.toString());
            Database database = db;
            synchronized (database) {
                TreeSet<Query> queries = db.queriesByCat("*");
                TreeSet<Album> albums = new TreeSet<Album>();
                for (Query query : queries) {
                    albums.add(new Album(query, db));
                }
                for (Album album : albums) {
                    report.addLine(album.toString());
                }
            }
            report.writeTo(this.clp().logger());
            MLogger rptLogger = BpmClp.reportLogger(this, report);
            report.writeTo(rptLogger);
            MAppMsg appMsg = BpmMsgs.get("saved");
            this.clp().logger().writeln(appMsg.format(report.title()));
        }

        private static class Album
        implements Comparable<Album> {
            private Query iQuery = null;
            private int iNumPics = 0;

            public Album(Query query, Database db) {
                this.iQuery = query;
                TreeSet<PicInfo> infos = db.selectPicInfos(query);
                this.iNumPics = infos.size();
            }

            @Override
            public int compareTo(Album album) {
                int result = 0;
                if (album != this) {
                    result = -1;
                    result = this.iQuery.name().compareTo(album.iQuery.name());
                }
                return result;
            }

            public int hashCode() {
                return this.iQuery.name().hashCode();
            }

            public String toString() {
                PicInfo info = this.iQuery.picInfo();
                String str = String.valueOf(this.iQuery.name()) + "," + this.iNumPics + ": ";
                str = String.valueOf(str) + info.comboFieldsStr();
                if (info.year() != -1) {
                    str = String.valueOf(str) + ", year:" + Integer.toString(info.year());
                }
                if (info.uncer() != -1) {
                    str = String.valueOf(str) + ", uncer:" + Integer.toString(info.uncer());
                }
                if (info.month() != -1) {
                    str = String.valueOf(str) + ", month:" + Integer.toString(info.month());
                }
                if (info.month() != -1) {
                    str = String.valueOf(str) + ", month:" + Integer.toString(info.month());
                }
                if (this.iQuery.personGroup().getName().length() > 0) {
                    str = String.valueOf(str) + ", person:" + this.iQuery.personGroup().getName();
                }
                return str;
            }
        }
    }

    public static class PicInfosCmd
    extends ClpCmd {
        public PicInfosCmd() throws Exception {
            super("list PicInfos");
            this.add(new ClpCmd.Arg("list", false));
            this.add(new ClpCmd.Arg("picinfos", false));
            this.add(new BpmClp.DbOpened());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws Exception {
            MReport report = new MReport("PicInfos Report");
            Database db = Database.singleton();
            report.addLine(db.toString());
            Database database = db;
            synchronized (database) {
                TreeSet<BinnedDb.Binnable> infos = db.infosDb().objsById();
                report.addLine(String.valueOf(infos.size()) + " PicInfos:");
                int count = 0;
                for (BinnedDb.Binnable obj : infos) {
                    PicInfo info = (PicInfo)obj;
                    report.addLine("   " + count++ + "> " + info.toString());
                }
            }
            report.writeTo(this.clp().logger());
            MLogger rptLogger = BpmClp.reportLogger(this, report);
            report.writeTo(rptLogger);
            MAppMsg appMsg = BpmMsgs.get("saved");
            this.clp().logger().writeln(appMsg.format(report.title()));
        }
    }

    public static class PicInfosExifCmd
    extends ClpCmd {
        public PicInfosExifCmd() throws Exception {
            super("list PicInfo BPM EXIF");
            this.add(new ClpCmd.Arg("list", false));
            this.add(new ClpCmd.Arg("picinfos", false));
            this.add(new ClpCmd.Arg("exif", false));
            this.add(new ClpCmd.Arg("reread", true));
            this.add(new BpmClp.DbOpened());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws Exception {
            MReport report = new MReport("PicInfosExif Report");
            Database db = Database.singleton();
            boolean reread = this.supplied("reread");
            report.addLine(db.toString());
            Database database = db;
            synchronized (database) {
                TreeMap<String, PicInfo> infos = db.picInfosByPathname();
                report.addLine(String.valueOf(infos.size()) + " PicInfos:");
                int count = 0;
                for (PicInfo info : infos.values()) {
                    try {
                        ExifTags.Pair bpm;
                        ExifTags tags = ExifTags.read(info, reread);
                        if (reread) {
                            info.setExifTags(tags);
                        }
                        if ((bpm = tags.getTag("Unknown tag (0x84e0)")) != null) {
                            report.addLine(String.valueOf(count) + "> " + info.picPathname() + " has " + bpm);
                        } else {
                            report.addLine(String.valueOf(count) + " No BPM EXIF: " + info.picPathname());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!reread || ++count % 100 != 0) continue;
                    report.addLine("" + count);
                }
            }
            report.writeTo(this.clp().logger());
            MLogger rptLogger = BpmClp.reportLogger(this, report);
            report.writeTo(rptLogger);
            MAppMsg appMsg = BpmMsgs.get("saved");
            this.clp().logger().writeln(appMsg.format(report.title()));
            if (reread) {
                db.save();
            }
        }
    }

    public static class PicInfosXmlCmd
    extends ClpCmd {
        public PicInfosXmlCmd() throws Exception {
            super("list PicInfos XML");
            this.add(new ClpCmd.Arg("list", false));
            this.add(new ClpCmd.Arg("picinfos", false));
            this.add(new ClpCmd.Arg("xml", false));
            this.add(new BpmClp.DbOpened());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws Exception {
            MReport report = new MReport("PicInfos XML Report");
            Database db = Database.singleton();
            report.addLine(db.toString());
            Database database = db;
            synchronized (database) {
                report.addLine("<?xml version=\"1.0\"?>");
                PicInfosXmlCmd.writeDTD(db, report);
                report.addLine("<photos>");
                TreeMap<String, PicInfo> infos = db.picInfosByPathname();
                MLogger.List list = new MLogger.List();
                for (PicInfo info : infos.values()) {
                    info.writeXML(list, true);
                }
                report.addAll(((MLogger)list).lines());
                report.addLine("</photos>");
            }
            report.writeTo(this.clp().logger());
            MLogger rptLogger = BpmClp.reportLogger(this, report);
            report.writeTo(rptLogger);
            MAppMsg appMsg = BpmMsgs.get("saved");
            this.clp().logger().writeln(appMsg.format(report.title()));
        }

        private static void writeDTD(Database db, MReport report) throws Exception {
            String indent = "\t";
            report.addLine("<!DOCTYPE photos [");
            String pathName = String.valueOf(db.parms().bpmPath().path()) + "photos.dtd";
            LinkedList<String> dtd = Utility.readTextFile(pathName);
            Iterator lines = dtd.iterator();
            while (lines.hasNext()) {
                String line = String.valueOf(indent) + (String)lines.next();
                report.addLine(line);
            }
            report.addLine("]>");
        }
    }
}

