/*
 * Decompiled with CFR 0.152.
 */
package cmdproc;

import clp.AbstractClpConsole;
import clp.Clp;
import cmdproc.BpmClp;
import files.FileInfo;
import files.Filesystem;
import oroma.db.Database;
import oroma.db.ProgInstallation;
import oroma.db.ProgPreferences;
import utilt.Utility;

public class ClpConsole
extends AbstractClpConsole {
    private static final String PROGNAME = "BPM Clp";
    private static final String PROGTITLE = "BPM Clp version 11-Jan-2026";

    public static void main(String[] args) {
        try {
            BpmClp bpmClp = new BpmClp(new BpmClp.State(), true);
            ClpConsole console = new ClpConsole(PROGTITLE, bpmClp);
            if (console.parseArgs(args)) {
                console.setup();
                console.process();
            }
        }
        catch (Exception xcp) {
            System.out.println("*** " + Utility.xcpMsg(xcp));
        }
    }

    @Override
    public void setup() throws Exception {
        ProgInstallation install = ProgInstallation.read();
        ProgPreferences.read(install);
        Filesystem.Local fs = new Filesystem.Local(ProgInstallation.singleton().dir(), true);
        FileInfo.Local bpmDir = new FileInfo.Local((Filesystem)fs, "");
        Database.Parms parms = new Database.Parms(bpmDir, null);
        Database.open(parms, true, this.clp().logger());
        Runtime.getRuntime().addShutdownHook(new Shutdown());
    }

    protected ClpConsole(String progName, Clp clp) throws Exception {
        super(progName, clp);
    }

    private class Shutdown
    extends Thread {
        private Shutdown() {
        }

        @Override
        public void run() {
            try {
                if (Database.singleton() != null) {
                    Database.singleton().shutdown();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

