/*
 * Decompiled with CFR 0.152.
 */
package cmdproc;

import clp.ClpCmd;
import cmdproc.BpmClp;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.TreeSet;
import mlib.MAppMsg;
import mlib.MReport;
import mlib.MString;
import mswing.WheelComboBoxDb;
import oroma.db.Database;
import oroma.db.ImageFileInfo;
import oroma.db.PersonGroup;
import oroma.db.PicInfo;
import oroma.db.Query;
import oroma.gui.BpmMsgs;
import utilt.BinnedDb;
import utilt.ImageIOUtil;
import utilt.Utility;

public class CleanCmds {
    private CleanCmds() {
    }

    private static void cleanOthers(Database db, MReport report) throws Exception {
        Collection<PicInfo> infos = db.picInfosByPathname().values();
        Collection<String> dbNames = db.comboDbNames();
        for (String dbName : dbNames) {
            if (dbName.equalsIgnoreCase("persons") || dbName.equalsIgnoreCase("category") || dbName.equalsIgnoreCase("album")) continue;
            WheelComboBoxDb comboDb = db.comboDb(dbName);
            comboDb.clear(null);
            int count = 0;
            for (PicInfo info : infos) {
                boolean added;
                PicInfo.ComboField field = info.comboField(PicInfo.ComboField.dbNameToName(dbName));
                MString value = field.mValue();
                value.remove('!', 99, 0);
                value.remove('*', 99, 0);
                value.capFirstChar();
                if (value.length() != field.value().length()) {
                    field.setValue(value.toString());
                    field.setPrevValue(value.toString());
                    db.putPic(info, false);
                }
                if (!(added = comboDb.addItem(value.toString(), null))) continue;
                ++count;
            }
            comboDb.addItem("", null);
            String str = String.valueOf(dbName) + " has " + count + " values";
            report.addLine(str);
        }
    }

    private static void cleanPersons(Database db, MReport report) throws Exception {
        Collection<PicInfo> infos = db.picInfosByPathname().values();
        int count = 0;
        String name = "persons";
        WheelComboBoxDb comboDb = db.comboDb(name);
        comboDb.clear(null);
        for (PicInfo info : infos) {
            LinkedList<PersonGroup> persons = info.persons();
            for (PersonGroup person : persons) {
                boolean added;
                String personName = person.getName().trim();
                if (personName.length() <= 0 || personName.charAt(0) == '!' || !(added = comboDb.addItem(person.toString(), null))) continue;
                ++count;
            }
        }
        String msg = String.valueOf(name) + " has " + count + " values";
        report.addLine(msg);
    }

    private static void cleanCategories(Database db, MReport report) throws Exception {
        int count = 0;
        WheelComboBoxDb comboDb = db.comboDb("category");
        TreeSet<Query> queries = db.queriesByCat("*");
        for (Query query : queries) {
            MString cat = new MString(query.category());
            cat.capFirstChar();
            boolean added = comboDb.addItem(cat.toString(), null);
            if (!added) continue;
            ++count;
        }
        String msg = "category has " + count + " values";
        report.addLine(msg);
    }

    private static TreeSet<String> imageFolders(Database db, MReport report) {
        String msg = "Image file folders:";
        report.addLine(msg);
        TreeSet<String> dirs = new TreeSet<String>();
        Collection<PicInfo> infos = db.picInfosByPathname().values();
        for (PicInfo info : infos) {
            String path = info.picPathname();
            int index = path.lastIndexOf(47);
            path = path.substring(0, index);
            dirs.add(path);
        }
        for (String dir : dirs) {
            msg = "   " + dir;
            report.addLine(msg);
        }
        return dirs;
    }

    public static class ComboBoxesCmd
    extends ClpCmd {
        public ComboBoxesCmd() throws Exception {
            super("clean ComboBoxes");
            this.add(new ClpCmd.Arg("clean", false));
            this.add(new ClpCmd.Arg("comboboxes", false));
            this.add(new BpmClp.DbOpened());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws Exception {
            MReport report = new MReport("Clean ComboBoxes Report");
            Database db = Database.singleton();
            report.addLine(db.toString());
            Database database = db;
            synchronized (database) {
                CleanCmds.cleanPersons(db, report);
                CleanCmds.cleanCategories(db, report);
                CleanCmds.cleanOthers(db, report);
                db.save();
                report.writeTo(this.clp().logger());
                MAppMsg appMsg = BpmMsgs.get("saved");
                this.clp().logger().writeln(appMsg.format(report.title()));
            }
        }
    }

    public static class FileInfosCmd
    extends ClpCmd {
        public FileInfosCmd() throws Exception {
            super("clean FileInfos");
            this.add(new ClpCmd.Arg("clean", false));
            this.add(new ClpCmd.Arg("fileinfos", false));
            this.add(new ClpCmd.Arg("save", true));
            this.add(new BpmClp.DbOpened());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws Exception {
            boolean listOnly = !this.supplied("save");
            MReport report = new MReport("Clean FileInfos Report");
            Database db = Database.singleton();
            report.addLine(db.toString());
            String msg = null;
            LinkedList<PicInfo> infosToDel = new LinkedList<PicInfo>();
            Database database = db;
            synchronized (database) {
                int count = 0;
                int updated = 0;
                Collection<PicInfo> infos = db.picInfosByPathname().values();
                for (PicInfo info : infos) {
                    ImageFileInfo current = info.getFileInfo();
                    ImageFileInfo work = new ImageFileInfo();
                    if (ImageIOUtil.isJpeg(info.picPathname())) {
                        try {
                            boolean update;
                            File file = new File(info.picPathname());
                            work.readJpegHeader(file);
                            boolean bl = update = current.getNumCols() != work.getNumCols();
                            if (!update) {
                                boolean bl2 = update = current.getNumRows() != work.getNumRows();
                            }
                            if (update) {
                                ++updated;
                                if (listOnly) {
                                    msg = "Would update ImageFileInfo for " + info.picPathname();
                                } else {
                                    current.setNumCols(work.getNumCols());
                                    current.setNumRows(work.getNumRows());
                                    msg = "Updating ImageFileInfo for " + info.picPathname();
                                }
                                report.addLine(msg);
                            }
                        }
                        catch (FileNotFoundException xcp) {
                            infosToDel.add(info);
                            msg = "Would delete PicInfo, file not found: " + info.picPathname();
                            report.addLine(msg);
                        }
                        catch (Exception xcp) {
                            msg = "*** Unable to read " + info.picPathname() + ": " + Utility.xcpMsg(xcp);
                            report.addLine(msg);
                        }
                    }
                    if (++count % 100 != 0) continue;
                    this.clp().logger().writeln("" + count);
                }
                if (listOnly) {
                    msg = "Would update " + updated + " ImageFileInfos";
                    report.addLine(msg);
                    msg = "Would delete " + infosToDel.size() + " PicInfos";
                    report.addLine(msg);
                } else {
                    BinnedDb infosDb = db.infosDb();
                    for (PicInfo info : infosToDel) {
                        infosDb.remove(info, false);
                        report.addLine("Deleted PicInfo: " + info.picPathname());
                    }
                    if (updated + infosToDel.size() > 0) {
                        db.save();
                    }
                    msg = "Updated " + updated + " ImageFileInfos";
                    report.addLine(msg);
                    msg = "Deleted " + infosToDel.size() + " PicInfos";
                    report.addLine(msg);
                }
                report.writeTo(this.clp().logger());
                MAppMsg appMsg = BpmMsgs.get("saved");
                this.clp().logger().writeln(appMsg.format(report.title()));
            }
        }
    }

    public static class PicInfosCmd
    extends ClpCmd {
        public PicInfosCmd() throws Exception {
            super("clean PicInfos");
            this.add(new ClpCmd.Arg("clean", false));
            this.add(new ClpCmd.Arg("picinfos", false));
            this.add(new ClpCmd.Arg("save", true));
            this.add(new BpmClp.DbOpened());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws Exception {
            boolean listOnly = !this.supplied("save");
            MReport report = new MReport("Clean PicInfos Report");
            Database db = Database.singleton();
            report.addLine(db.toString());
            Database database = db;
            synchronized (database) {
                Collection<PicInfo> infos = db.picInfosByPathname().values();
                LinkedList<PicInfo> toDelete = new LinkedList<PicInfo>();
                for (PicInfo info : infos) {
                    File file = new File(info.picPathname());
                    if (file.exists() && db.infosDb().obj(info.id()) != null) continue;
                    if (listOnly) {
                        String msg = "Would delete PicInfo for " + file.getPath();
                        report.addLine(msg);
                        continue;
                    }
                    toDelete.add(info);
                }
                String msg = "Found " + toDelete.size() + " to clean";
                report.addLine(msg);
                if (!listOnly && toDelete.size() > 0) {
                    for (PicInfo info : toDelete) {
                        db.deletePic(info, false);
                        msg = "Deleted " + info.picPathname();
                        report.addLine(msg);
                    }
                    db.save();
                }
                report.writeTo(this.clp().logger());
                MAppMsg appMsg = BpmMsgs.get("saved");
                this.clp().logger().writeln(appMsg.format(report.title()));
            }
        }
    }

    public static class PicsCmd
    extends ClpCmd {
        public PicsCmd() throws Exception {
            super("clean picture files");
            this.add(new ClpCmd.Arg("clean", false));
            this.add(new ClpCmd.Arg("pics", false));
            this.add(new ClpCmd.Arg("save", true));
            this.add(new BpmClp.DbOpened());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws Exception {
            MReport report = new MReport("Clean Pictures Report");
            Database db = Database.singleton();
            report.addLine(db.toString());
            Database database = db;
            synchronized (database) {
                int count = 0;
                TreeMap<String, PicInfo> picInfos = db.picInfosByPathname();
                TreeSet dirs = CleanCmds.imageFolders(db, report);
                if (!this.supplied("save")) {
                    report.addLine("Files that would be deleted:");
                } else {
                    report.addLine("Files deleted:");
                }
                for (String dirPath : dirs) {
                    File[] files;
                    File dir = new File(dirPath);
                    File[] fileArray = files = dir.listFiles();
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int index;
                        File file = fileArray[n2];
                        String name = file.getName();
                        if (ImageIOUtil.isValidImage(name) && !BinnedDb.isBinnedFileName(name = name.substring(0, index = name.lastIndexOf(46))) && !name.endsWith("$")) {
                            String path = file.getAbsolutePath();
                            if (picInfos.get(path = path.replace('\\', '/')) == null) {
                                if (!this.supplied("save")) {
                                    report.addLine("   " + file.getAbsolutePath());
                                } else {
                                    file.delete();
                                    report.addLine("   " + file.getAbsolutePath());
                                }
                                ++count;
                            }
                        }
                        ++n2;
                    }
                }
                report.addLine(count + " files");
                report.writeTo(this.clp().logger());
                MAppMsg appMsg = BpmMsgs.get("saved");
                this.clp().logger().writeln(appMsg.format(report.title()));
            }
        }
    }
}

