/*
 * Decompiled with CFR 0.152.
 */
package clp;

import clp.Clp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import mlib.MLogging;
import swing.ColorPanel;
import swing.EntryField;
import swing.PanelLabel;
import swing.StatusBox;
import swing.StdScrollPane;
import swing.SwingProgram;
import utilt.Utility;

public class EntryLogger
extends ColorPanel
implements MLogging {
    private Clp iClp = null;
    private EntryField iCmdField = null;
    private JTextArea iTextArea = new JTextArea();
    private JScrollPane iPane = null;
    private boolean iFilterRepeats = true;
    private String iPrevMsg = "";
    private MLogging iLinked = null;
    private String iPrefix = "";
    private static final String CLEARCMD = "clear";

    public EntryLogger() {
        this.iCmdField = new EntryField(25);
        Font font = new Font("Monospaced", 1, Utility.stdFontSize());
        this.iTextArea.setFont(font);
        this.iTextArea.setMargin(new Insets(5, 5, 5, 5));
        this.iTextArea.setEditable(false);
        this.setLayout(new BorderLayout());
        this.iPane = new StdScrollPane(this.iTextArea);
        this.add((Component)this.iPane, "Center");
        ColorPanel botPanel = new ColorPanel();
        botPanel.setLayout(new BorderLayout());
        botPanel.add((Component)new PanelLabel("Command: "), "West");
        botPanel.add((Component)this.iCmdField, "Center");
        this.add((Component)botPanel, "South");
        this.iCmdField.setBorder(SwingProgram.STDBORDER);
        this.iCmdField.addActionListener(new EntryHandler());
    }

    public void setClp(Clp clp) throws Exception {
        this.iClp = clp;
    }

    public void setFilterRepeats(boolean filter) {
        this.iFilterRepeats = filter;
    }

    @Override
    public void writeln(String msg, boolean error) {
        if (msg != null) {
            boolean write;
            boolean bl = write = !this.iFilterRepeats || !msg.equalsIgnoreCase(this.iPrevMsg);
            if (write) {
                this.iPrevMsg = msg;
                msg = String.valueOf(this.iPrefix) + msg;
                if (error) {
                    msg = "*** " + msg;
                }
                if (SwingUtilities.isEventDispatchThread()) {
                    if (msg.length() > 0) {
                        this.iTextArea.append(String.valueOf(msg) + "\r\n");
                    }
                    JScrollBar bar = this.iPane.getVerticalScrollBar();
                    bar.setValue(bar.getMaximum());
                } else {
                    EventQueue.invokeLater(new Updater(msg));
                }
            }
            if (this.linked() != null) {
                this.linked().writeln(msg, error);
            }
        }
    }

    @Override
    public void writeln(String msg) {
        this.writeln(msg, false);
    }

    @Override
    public void write(String msg, boolean error) {
        this.writeln(msg, error);
        if (this.linked() != null) {
            this.linked().writeln(msg, error);
        }
    }

    @Override
    public void write(String msg) {
        this.write(msg, false);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.iCmdField.setEnabled(enabled);
        this.iTextArea.setEnabled(enabled);
    }

    @Override
    public MLogging linked() {
        return this.iLinked;
    }

    @Override
    public void setLinked(MLogging next) {
        this.iLinked = next;
    }

    @Override
    public boolean isIncludeTime() {
        return false;
    }

    @Override
    public void setIncludeTime(boolean include) {
    }

    @Override
    public void setPrefix(String prefix) {
        this.iPrefix = prefix;
    }

    @Override
    public String prefix() {
        return this.iPrefix;
    }

    @Override
    public void requestFocus() {
        this.iCmdField.requestFocus();
    }

    @Override
    public void setMaxLines(int maxLine) {
    }

    @Override
    public int maxLines() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void clear() {
        this.iTextArea.setText("");
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public Collection<String> lines() {
        return new LinkedList<String>();
    }

    private class EntryHandler
    implements ActionListener {
        private EntryHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (EntryLogger.this.iClp == null) {
                StatusBox.singleton().showMsg("CLP not selected", true);
            } else {
                String cmdStr = EntryLogger.this.iCmdField.getText().trim();
                if (cmdStr.length() > 0) {
                    if (cmdStr.equalsIgnoreCase(EntryLogger.CLEARCMD)) {
                        EntryLogger.this.iTextArea.setText(">");
                    } else {
                        StatusBox.singleton().showMsg("Running " + cmdStr + "...", false);
                        EntryLogger.this.iCmdField.setEnabled(false);
                        try {
                            EntryLogger.this.iClp.execLine(cmdStr);
                            StatusBox.singleton().queueShowMsg("Completed " + cmdStr, false);
                        }
                        catch (Exception xcp) {
                            StatusBox.singleton().queueShowMsg(Utility.xcpMsg(xcp), true);
                            EntryLogger.this.writeln(Utility.xcpMsg(xcp), true);
                        }
                    }
                    EntryLogger.this.iCmdField.addHistory(cmdStr);
                }
            }
            EntryLogger.this.iCmdField.setText("");
            EntryLogger.this.iCmdField.setEnabled(true);
            EntryLogger.this.iCmdField.requestFocus();
        }
    }

    private class Updater
    extends Thread {
        private String iMsg = null;

        public Updater(String msg) {
            this.iMsg = msg;
        }

        @Override
        public void run() {
            if (this.iMsg.length() > 0) {
                EntryLogger.this.iTextArea.append(String.valueOf(this.iMsg) + "\r\n");
            }
            JScrollBar bar = EntryLogger.this.iPane.getVerticalScrollBar();
            bar.setValue(bar.getMaximum());
        }
    }
}

