/*
 * Decompiled with CFR 0.152.
 */
package clp;

import java.awt.Color;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class ColorMap {
    private TreeMap<String, String> iNamesByKey = new TreeMap();
    private static TreeMap<String, Color> ColorsByName = new TreeMap();

    static {
        ColorsByName.put("red", Color.red);
        ColorsByName.put("green", Color.green);
        ColorsByName.put("blue", Color.blue);
        ColorsByName.put("black", Color.black);
        ColorsByName.put("white", Color.white);
        ColorsByName.put("cyan", Color.cyan);
        ColorsByName.put("magenta", Color.magenta);
        ColorsByName.put("gray", Color.gray);
        ColorsByName.put("yellow", Color.yellow);
        ColorsByName.put("orange", Color.orange);
    }

    public static Color colorByName(String name) {
        return ColorsByName.get(name);
    }

    public void add(String key, String colorName) throws Exception {
        key = key.toLowerCase();
        Color color = ColorsByName.get(colorName);
        if (color == null) {
            throw new Exception("invalid color name: " + colorName);
        }
        this.iNamesByKey.put(key, colorName);
    }

    public Color color(String label) {
        Color color = null;
        String name = this.iNamesByKey.get(label = label.toLowerCase());
        if (name != null) {
            color = ColorsByName.get(name);
        }
        if (color == null) {
            Set<Map.Entry<String, String>> mappings = this.iNamesByKey.entrySet();
            for (Map.Entry<String, String> entry : mappings) {
                if (label.indexOf(entry.getKey()) < 0) continue;
                color = ColorsByName.get(entry.getValue());
            }
        }
        return color;
    }

    public String toString() {
        String str = "";
        Set<Map.Entry<String, String>> mappings = this.iNamesByKey.entrySet();
        for (Map.Entry<String, String> entry : mappings) {
            if (str.length() > 0) {
                str = String.valueOf(str) + ",";
            }
            str = String.valueOf(str) + entry.getKey() + "-" + entry.getValue();
        }
        return str;
    }
}

