/*
 * Decompiled with CFR 0.152.
 */
package clp;

import clp.Clp;
import clp.EntryLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.StringTokenizer;
import mlib.MIniProps;
import mlib.MLogger;
import swing.ColorButton;
import swing.ColorPanel;
import swing.EntryField;
import swing.PanelLabel;
import swing.StatusBox;
import swing.SwingProgram;
import utilt.Utility;

public class ClpLoaderGuiProg
extends SwingProgram {
    private Clp iClp = null;
    private EntryField jConfigField = new EntryField();
    private ColorButton jRunButton = null;
    private ColorButton jClearButton = null;
    private EntryLogger jEntryLogger = new EntryLogger();
    private RunHandler iRunHandler = new RunHandler();
    public static final String PROGNAME = "ClpLoaderGui";
    public static final String VERSION = "22-Jul-2025";
    private static final String PROGTITLE = "ClpLoaderGui version 22-Jul-2025";
    public static final String CONFIGARG = "f";
    private static final String SECTION = "config";
    private static final String CLPPROP = "clp";
    private static final String STATEPROP = "state";
    private static final String ROOTPROP = "root";
    private static final String STARTPROP = "start";

    public static void main(String[] args) {
        try {
            ClpLoaderGuiProg gui = new ClpLoaderGuiProg();
            if (gui.parseArgs(args)) {
                gui.startup();
            }
        }
        catch (Exception xcp) {
            System.out.println(xcp);
        }
    }

    public ClpLoaderGuiProg() throws Exception {
        super(PROGTITLE);
        this.progArgs().addArg(CONFIGARG, "configuration ini file", null, false, 0, 1);
        this.addWindowListener(new WindowHandler());
        ColorPanel prompts = new ColorPanel();
        prompts.setLayout(new GridLayout(0, 1));
        PanelLabel classLabel = new PanelLabel(" CLP configuration file: ");
        classLabel.setAlignmentX(0.0f);
        prompts.add(classLabel);
        ColorPanel values = new ColorPanel();
        values.setLayout(new GridLayout(0, 1));
        values.add(this.jConfigField);
        ColorPanel top = new ColorPanel();
        top.setLayout(new BorderLayout());
        top.add((Component)StatusBox.singleton(), "Center");
        ColorPanel buttons = new ColorPanel();
        buttons.setLayout(new GridLayout(1, 0));
        buttons.add(this.getRunButton());
        buttons.add(this.getClearButton());
        top.add((Component)buttons, "East");
        ColorPanel entry = new ColorPanel();
        entry.setLayout(new BorderLayout());
        entry.add((Component)top, "North");
        entry.add((Component)prompts, "West");
        entry.add((Component)values, "Center");
        ColorPanel main = new ColorPanel();
        main.setLayout(new BorderLayout());
        main.add((Component)entry, "North");
        this.jEntryLogger.setEnabled(true);
        main.add((Component)this.jEntryLogger, "Center");
        this.setContentPane(main);
        this.setTitle(PROGNAME);
        this.getRunButton().addActionListener(this.iRunHandler);
        this.jConfigField.addActionListener(this.iRunHandler);
        this.getClearButton().addActionListener(new ClearHandler());
        String javaVer = System.getProperty("java.version");
        StatusBox.singleton().showMsg("Java version " + javaVer, false);
        StatusBox.singleton().showMsg(PROGTITLE, false);
    }

    private void startup() throws Exception {
        this.setExtendedState(6);
        this.setVisible(true);
        this.showClasspath();
        this.jConfigField.requestFocus();
        if (this.progArgs().argSupplied(CONFIGARG)) {
            String path = this.progArgs().argValue(CONFIGARG, 0);
            this.jConfigField.setText(path);
            this.iRunHandler.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    private void showClasspath() {
        this.jEntryLogger.writeln("Classpath:", false);
        String classPath = System.getProperty("java.class.path");
        String delim = ";";
        if (Utility.isUnixFilesystem()) {
            delim = ":";
        }
        StringTokenizer tken = new StringTokenizer(classPath, delim);
        while (tken.hasMoreTokens()) {
            String token = tken.nextToken();
            this.jEntryLogger.writeln(token, false);
        }
    }

    private ColorButton getRunButton() {
        if (this.jRunButton == null) {
            this.jRunButton = new ColorButton("Run CLP");
            this.jRunButton.setEnabled(true);
        }
        return this.jRunButton;
    }

    private ColorButton getClearButton() {
        if (this.jClearButton == null) {
            this.jClearButton = new ColorButton("Clear screen");
            this.jClearButton.setEnabled(true);
        }
        return this.jClearButton;
    }

    private class ClearHandler
    implements ActionListener {
        private ClearHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ClpLoaderGuiProg.this.jEntryLogger.clear();
        }
    }

    private class RunHandler
    implements ActionListener {
        private RunHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                ClpLoaderGuiProg.this.jEntryLogger.clear();
                File file = new File(ClpLoaderGuiProg.this.jConfigField.getText().trim());
                MIniProps props = MIniProps.read(file);
                String[] prop = props.propValue(ClpLoaderGuiProg.SECTION, ClpLoaderGuiProg.CLPPROP);
                if (prop == null) {
                    MIniProps.throwNotFound(ClpLoaderGuiProg.CLPPROP);
                }
                Class<?> clpClass = Class.forName(prop[0]);
                Class[] parms = new Class[]{Clp.State.class};
                Constructor<?> con = clpClass.getConstructor(parms);
                ClpLoaderGuiProg.this.iClp = (Clp)con.newInstance(new Clp.State());
                ClpLoaderGuiProg.this.jEntryLogger.setClp(ClpLoaderGuiProg.this.iClp);
                ClpLoaderGuiProg.this.iClp.setLogger(ClpLoaderGuiProg.this.jEntryLogger);
                ClpLoaderGuiProg.this.jEntryLogger.setLinked(new MLogger.File("clplog.txt", false));
                prop = props.propValue(ClpLoaderGuiProg.SECTION, ClpLoaderGuiProg.STATEPROP);
                if (prop == null) {
                    MIniProps.throwNotFound(ClpLoaderGuiProg.STATEPROP);
                }
                Class<?> stateClass = Class.forName(prop[0]);
                con = stateClass.getConstructor(new Class[0]);
                Clp.State state = (Clp.State)con.newInstance(new Object[0]);
                ClpLoaderGuiProg.this.iClp.setState(state);
                ClpLoaderGuiProg.this.jEntryLogger.writeln("Loaded CLP " + ClpLoaderGuiProg.this.iClp.name(), false);
                prop = props.propValue(ClpLoaderGuiProg.SECTION, ClpLoaderGuiProg.ROOTPROP);
                if (prop == null) {
                    MIniProps.throwNotFound(ClpLoaderGuiProg.ROOTPROP);
                }
                ClpLoaderGuiProg.this.iClp.setScriptsRoot(new File(prop[0]));
                ClpLoaderGuiProg.this.jEntryLogger.writeln(ClpLoaderGuiProg.this.iClp.toString(), false);
                prop = props.propValue(ClpLoaderGuiProg.SECTION, ClpLoaderGuiProg.STARTPROP);
                if (prop != null) {
                    ClpLoaderGuiProg.this.iClp.execFile(prop[0]);
                }
                ClpLoaderGuiProg.this.jEntryLogger.requestFocus();
            }
            catch (Exception xcp) {
                StatusBox.singleton().showMsg(Utility.xcpMsg(xcp), true);
            }
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            System.exit(0);
        }
    }
}

