/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.Chart;
import chart.ChartPanel;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import math.Dataset;
import math.XYpoint;
import mswing.StdColor;
import utilt.Utility;

public class VertBarDrawer
extends ChartPanel.Drawer {
    private static VertBarDrawer Singleton = new VertBarDrawer();

    public static VertBarDrawer singleton() {
        return Singleton;
    }

    @Override
    public boolean yMinAlwaysZero() {
        return true;
    }

    @Override
    public float minY(Chart chart) {
        return 0.0f;
    }

    @Override
    public float maxY(Chart chart) {
        float max = 0.0f;
        Chart.VertBarAppearance app = (Chart.VertBarAppearance)chart.appearance();
        Chart.VertBarAppearance.Type type = app.type();
        if (type.equals(Chart.VertBarAppearance.Type.NOTSTACKED)) {
            max = chart.maxY();
        } else if (type.equals(Chart.VertBarAppearance.Type.STACKEDWITHUNCER)) {
            max = -3.4028235E38f;
            Iterator<Dataset.List<XYpoint.Float>> iter = chart.sets().iterator();
            Dataset.List<XYpoint.Float> set = iter.next();
            Iterator<XYpoint.Float> points = set.iterator();
            while (points.hasNext()) {
                XYpoint.Float point = points.next();
                float y = (float)(point.y() + point.yUncer());
                if (!(y > max)) continue;
                max = y;
            }
        } else {
            max = -3.4028235E38f;
            int size = -1;
            LinkedList<XYpoint.Float[]> arrays = new LinkedList<XYpoint.Float[]>();
            for (Dataset.List<XYpoint.Float> set : chart.sets()) {
                XYpoint.Float[] points = new XYpoint.Float[set.size()];
                Iterator<XYpoint.Float> iter = set.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    points[i++] = iter.next();
                }
                arrays.add(points);
                size = points.length;
            }
            float[] sums = new float[size];
            for (XYpoint.Float[] array : arrays) {
                int i = 0;
                while (i < sums.length) {
                    int n = i;
                    sums[n] = (float)((double)sums[n] + array[i].y());
                    ++i;
                }
            }
            float[] fArray = sums;
            int n = sums.length;
            int n2 = 0;
            while (n2 < n) {
                float y = fArray[n2];
                if (y > max) {
                    max = y;
                }
                ++n2;
            }
        }
        return max;
    }

    @Override
    public void draw(Chart chart, ChartPanel panel, Graphics2D g2) throws Exception {
        Chart.VertBarAppearance app = (Chart.VertBarAppearance)chart.appearance();
        Chart.VertBarAppearance.Type type = app.type();
        Collection<Dataset.List<XYpoint.Float>> sets = chart.sets();
        float barWidth = VertBarDrawer.barWidth(app, sets, panel);
        if (type.equals(Chart.VertBarAppearance.Type.NOTSTACKED)) {
            VertBarDrawer.drawNotStacked(chart, app, panel, barWidth, g2);
        } else if (type.equals(Chart.VertBarAppearance.Type.STACKED)) {
            VertBarDrawer.drawStacked(app, panel, barWidth, sets, g2);
        } else {
            VertBarDrawer.drawStackedUncer(chart, app, panel, barWidth, g2);
        }
    }

    private static void drawNotStacked(Chart chart, Chart.VertBarAppearance app, ChartPanel panel, float barWidth, Graphics2D g2) {
        Collection<Dataset.List<XYpoint.Float>> sets = chart.sets();
        DecimalFormat yFormat = new DecimalFormat(app.yScalesFormat());
        ChartPanel.Rectangle boundary = panel.innerBoundary();
        float x = boundary.getX() + 0.33f * barWidth;
        XYpoint.Float aPoint = new XYpoint.Float(0.0f);
        float barsBottom = panel.yPos(aPoint);
        for (Dataset.List<XYpoint.Float> set : sets) {
            Iterator<XYpoint.Float> iter = set.iterator();
            while (iter.hasNext()) {
                XYpoint.Float point = iter.next();
                float top = panel.yPos(point);
                float barHeight = barsBottom - top;
                float y = boundary.getY() + boundary.getHeight() - barHeight;
                Rectangle2D.Float bar = new Rectangle2D.Float(x, y, barWidth, barHeight);
                StdColor color = point.stdColor();
                if (color == null) {
                    color = app.defaultItemColor();
                }
                g2.setPaint(color.color());
                g2.fill(bar);
                if (point.getHover() == null) {
                    point.setHover(String.valueOf(point.label()) + ": " + yFormat.format(point.y()));
                }
                panel.hoverMgr().add(set.name(), point.getHover(), bar);
                x += barWidth + (float)app.barSpacing().intValue();
            }
            x += (float)app.datasetSpacing().intValue();
        }
    }

    private static void drawStacked(Chart.VertBarAppearance app, ChartPanel panel, float barWidth, Collection<Dataset.List<XYpoint.Float>> sets, Graphics2D g2) {
        DecimalFormat yFormat = new DecimalFormat(app.yScalesFormat());
        ChartPanel.Rectangle boundary = panel.innerBoundary();
        XYpoint.Float aPoint = new XYpoint.Float(0.0f);
        float bottom = panel.yPos(aPoint);
        float[] barTops = null;
        float[] barBottoms = new float[]{};
        int setNum = 0;
        for (Dataset.List<XYpoint.Float> set : sets) {
            ++setNum;
            XYpoint.Float[] points = new XYpoint.Float[set.size()];
            int i = 0;
            Iterator<XYpoint.Float> iter = set.iterator();
            while (iter.hasNext()) {
                points[i++] = iter.next();
            }
            float x = boundary.getX() + 0.5f * barWidth;
            if (barTops == null) {
                barTops = new float[points.length];
                barBottoms = new float[points.length];
                i = 0;
                while (i < barTops.length) {
                    barTops[i] = 0.0f;
                    barBottoms[i] = bottom;
                    ++i;
                }
            }
            i = 0;
            while (i < points.length) {
                if (barTops[i] > 0.0f) {
                    barBottoms[i] = barTops[i];
                }
                XYpoint.Float point = points[i];
                float barHeight = bottom - panel.yPos(point);
                float y = barBottoms[i] - barHeight;
                Rectangle2D.Float bar = new Rectangle2D.Float(x, y, barWidth, barHeight);
                StdColor color = point.stdColor();
                if (color == null) {
                    color = app.defaultItemColor();
                }
                g2.setPaint(color.color());
                g2.fill(bar);
                if (app.type().equals(Chart.VertBarAppearance.Type.STACKEDWITHUNCER) && setNum > 1) {
                    Line2D.Float line;
                    Point2D.Float right;
                    Point2D.Float left;
                    g2.setPaint(app.uncerLineColor().color());
                    g2.setStroke(new BasicStroke(app.boundaryWidth().intValue()));
                    if (point.weight() > 0.0) {
                        left = new Point2D.Float(x, y + barHeight / 2.0f);
                        right = new Point2D.Float(x + barWidth, y + barHeight / 2.0f);
                        line = new Line2D.Float(left, right);
                        g2.draw(line);
                    } else {
                        left = new Point2D.Float(x, y + barHeight);
                        right = new Point2D.Float(x + barWidth, y + barHeight);
                        line = new Line2D.Float(left, right);
                        g2.draw(line);
                    }
                }
                if (point.getHover() == null) {
                    point.setHover(String.valueOf(point.label()) + ": " + yFormat.format(point.y()));
                }
                panel.hoverMgr().add(set.name(), point.getHover(), bar);
                x += barWidth + (float)app.barSpacing().intValue();
                barTops[i] = y;
                ++i;
            }
        }
    }

    private static void drawStackedUncer(Chart chart, Chart.VertBarAppearance app, ChartPanel panel, float barWidth, Graphics2D g2) throws Exception {
        VertBarDrawer.checkStackedUncer(chart);
        DecimalFormat yFormat = new DecimalFormat(app.yScalesFormat());
        Iterator<Dataset.List<XYpoint.Float>> sets = chart.sets().iterator();
        Dataset.List<XYpoint.Float> set = sets.next();
        Dataset.List<XYpoint.Float> baseValues = new Dataset.List<XYpoint.Float>("values");
        Dataset.List<XYpoint.Float> uncers = new Dataset.List<XYpoint.Float>("uncertainties");
        DecimalFormat moreFormat = (DecimalFormat)yFormat.clone();
        moreFormat.setMaximumFractionDigits(yFormat.getMaximumFractionDigits() + 1);
        Iterator<XYpoint.Float> points = set.iterator();
        while (points.hasNext()) {
            XYpoint.Float point = points.next();
            XYpoint.Float baseValue = (XYpoint.Float)point.clone();
            XYpoint.Float uncer = (XYpoint.Float)point.clone();
            String valueStr = moreFormat.format(point.y());
            String uncerStr = moreFormat.format(point.yUncer());
            String hover = String.valueOf(point.label()) + ": " + valueStr + " +/- " + uncerStr;
            baseValue.setHover(hover);
            uncer.setHover(hover);
            float base = (float)(point.y() - point.yUncer());
            if (base > 0.0f) {
                baseValue.setY(base);
                baseValues.add(baseValue);
                uncer.setY((float)(2.0 * point.yUncer()));
                uncer.setColor(app.uncerColor());
                uncer.setWeight(1.0);
                uncers.add(uncer);
                continue;
            }
            baseValues.add(baseValue);
            uncer.setY((float)point.yUncer());
            uncer.setColor(app.uncerColor());
            uncer.setWeight(0.0);
            uncers.add(uncer);
        }
        LinkedList<Dataset.List<XYpoint.Float>> splitSets = new LinkedList<Dataset.List<XYpoint.Float>>();
        splitSets.add(baseValues);
        splitSets.add(uncers);
        Chart.VertBarAppearance.Type type = app.type();
        app.setType(Chart.VertBarAppearance.Type.STACKEDWITHUNCER);
        VertBarDrawer.drawStacked(app, panel, barWidth, splitSets, g2);
        app.setType(type);
    }

    private static float barWidth(Chart.VertBarAppearance app, Collection<Dataset.List<XYpoint.Float>> sets, ChartPanel panel) {
        float width = 0.0f;
        Iterator<Dataset.List<XYpoint.Float>> iter = sets.iterator();
        Dataset.List<XYpoint.Float> firstSet = iter.next();
        if (firstSet != null) {
            float panelWidth;
            boolean stacked;
            int numBars = firstSet.size();
            boolean bl = stacked = !app.type().equals(Chart.VertBarAppearance.Type.NOTSTACKED);
            if (!stacked) {
                numBars *= sets.size();
            }
            float barSpaces = numBars * app.barSpacing();
            float setSpaces = app.datasetSpacing().intValue();
            if (!stacked) {
                setSpaces = sets.size() * app.datasetSpacing() + app.datasetSpacing() / 2;
            }
            if ((width = ((panelWidth = panel.innerBoundary().getWidth()) - barSpaces - setSpaces) / (float)numBars) < 1.0f) {
                app.setBarSpacing(0);
                width = (panelWidth - setSpaces - (float)(numBars * app.barSpacing())) / (float)numBars;
            } else {
                width = (panel.innerBoundary().getWidth() - barSpaces - setSpaces - width / 2.0f) / (float)numBars;
            }
        }
        return width;
    }

    private static void checkStackedUncer(Chart chart) throws Exception {
        Collection<Dataset.List<XYpoint.Float>> sets = chart.sets();
        if (sets.size() != 1) {
            Utility.throwError("VertBarDrawer: type StackedWithUncer must have exactly 1 set");
        } else {
            int size = -1;
            for (Dataset.List<XYpoint.Float> set : sets) {
                if (size < 0) {
                    size = set.size();
                } else if (set.size() != size) {
                    Utility.throwError("VertBarDrawer: sets must be same size");
                }
                Iterator<XYpoint.Float> iter = set.iterator();
                while (iter.hasNext()) {
                    XYpoint.Float point = iter.next();
                    if (!(point.y() < 0.0) && !(point.x() < 0.0)) continue;
                    Utility.throwError("VertBarDrawer: all x and y values must be positive");
                }
            }
        }
    }

    private VertBarDrawer() {
    }
}

