/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.Chart;
import chart.ChartPanel;
import chart.ScatterDrawer;
import chart.VertBarDrawer;
import chart.Viewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.zip.GZIPOutputStream;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import math.Dataset;
import math.XYpoint;
import mlib.MString;
import mswing.StdColor;
import swing.ColorButton;
import swing.ColorPanel;
import swing.EntryField;
import swing.NumberSpinner;
import swing.PanelLabel;
import swing.Selector;
import swing.StatusBox;
import swing.StdScrollPane;
import swing.SwingProgram;

public class AppearancePanel
extends ColorPanel {
    private Viewer iViewer = null;
    private ChartPanel iChartPanel = null;
    private Chart.Appearance iApp = null;
    private String iFilePath = null;
    private Selector.StdColor iAxesColor = new Selector.StdColor(null);
    private Selector.StdColor iChartColor = new Selector.StdColor(null);
    private Selector.StdColor iPageColor = new Selector.StdColor(null);
    private Selector.StdColor iLabelsColor = new Selector.StdColor(null);
    private Selector.StdColor iScalesColor = new Selector.StdColor(null);
    private Selector.StdColor iTicksColor = new Selector.StdColor(null);
    private Selector.StdColor iTitleColor = new Selector.StdColor(null);
    private NumberSpinner iLabelsFont = new NumberSpinner(10, 10, 75);
    private NumberSpinner iScalesFont = new NumberSpinner(10, 10, 75);
    private NumberSpinner iTitleFont = new NumberSpinner(10, 10, 75);
    private NumberSpinner iBoundaryWidth = new NumberSpinner(3, 1, 50);
    private NumberSpinner iTickWidth = new NumberSpinner(3, 1, 50);
    private NumberSpinner iLeftMargin = new NumberSpinner(10, 10, 300);
    private NumberSpinner iRightMargin = new NumberSpinner(10, 10, 300);
    private NumberSpinner iVertMargin = new NumberSpinner(10, 10, 300);
    private NumberSpinner iNumYTicks = new NumberSpinner(3, 3, 10);
    private EntryField iXScalesFormat = new EntryField();
    private EntryField iYScalesFormat = new EntryField();
    private EntryField iTitle = new EntryField();
    private EntryField iXLabel = new EntryField();
    private EntryField iYLabel = new EntryField();
    private Selector.TrueFalse iShowXTicks = new Selector.TrueFalse(null);
    private Selector.TrueFalse iExtendTicks = new Selector.TrueFalse(null);
    private Selector.TrueFalse iShowXScales = new Selector.TrueFalse(null);
    private Selector iScatterMark = null;
    private NumberSpinner iPointSize = new NumberSpinner(5, 0, 30);
    private NumberSpinner iBarSpacing = new NumberSpinner(5, 0, 100);
    private NumberSpinner iDatasetSpacing = new NumberSpinner(25, 0, 200);
    private Selector.TrueFalse iShowCenterDot = new Selector.TrueFalse(null);
    private EntryField iMinY = new EntryField();
    private EntryField iMaxY = new EntryField();
    private EntryField iMinX = new EntryField();
    private EntryField iMaxX = new EntryField();
    private Selector.Listener iSelHandler = new SelectorHandler();
    private ChangeListener iSpinnerHandler = new SpinnerHandler();
    private ActionListener iEntryHandler = new EntryHandler();
    private ColorButton iSaveButton = new ColorButton("Save");
    private ColorButton iSaveAppButton = new ColorButton("SaveApp");
    private ColorButton iCloseButton = new ColorButton("Close");
    private static final int MINFONT = 10;
    private static final int MAXFONT = 75;
    private static final int MINMARGIN = 10;
    private static final int MAXMARGIN = 300;
    private static final String LONGESTPROMPT = "Labels font size";
    private static final int PIXPERCHAR = 10;
    private static final String INVALIDNUM = "Invalid number";

    private static PanelLabel fieldPrompt(String text) {
        PanelLabel label = new PanelLabel(String.valueOf(text) + ":");
        int size = (LONGESTPROMPT.length() + 1) * 10;
        label.setPreferredSize(new Dimension(size, 0));
        return label;
    }

    private static void addItem(ColorPanel container, Component item, String prompt) {
        ColorPanel panel = new ColorPanel();
        panel.setBorder(SwingProgram.STDGAP);
        panel.setLayout(new BorderLayout());
        panel.add((Component)AppearancePanel.fieldPrompt(prompt), "West");
        panel.add(item, "Center");
        container.add(panel);
    }

    public AppearancePanel(Viewer viewer, ChartPanel chartPanel) {
        this.iViewer = viewer;
        this.iChartPanel = chartPanel;
        this.iApp = this.iChartPanel.chart().appearance();
        this.setBorder(SwingProgram.EMPTYBORDER);
        this.setLayout(new BorderLayout());
        ColorPanel topPanel = new ColorPanel();
        topPanel.setBorder(SwingProgram.STDGAP);
        topPanel.setLayout(new FlowLayout());
        topPanel.add(this.iSaveButton);
        this.iSaveButton.addActionListener(new SaveHandler());
        topPanel.add(this.iSaveAppButton);
        this.iSaveAppButton.addActionListener(new SaveAppHandler());
        topPanel.add(this.iCloseButton);
        this.iCloseButton.addActionListener(new CloseHandler());
        this.add((Component)topPanel, "North");
        ColorPanel botPanel = new ColorPanel();
        botPanel.setLayout(new GridLayout(0, 1));
        StdScrollPane spane = new StdScrollPane(botPanel);
        spane.setHorizontalScrollBarPolicy(31);
        this.add((Component)spane, "Center");
        Toolkit tKit = Toolkit.getDefaultToolkit();
        Dimension screen = tKit.getScreenSize();
        float width = (float)screen.width / 3.75f;
        this.setPreferredSize(new Dimension((int)width, 1000));
        this.setupStd(botPanel);
        if (this.iChartPanel.chart().drawer().getClass() == ScatterDrawer.class) {
            this.setupScatter(botPanel);
        } else if (this.iChartPanel.chart().drawer().getClass() == VertBarDrawer.class) {
            this.setupBar(botPanel);
        }
    }

    private void setupStd(ColorPanel panel) {
        String value;
        DecimalFormat format;
        PanelLabel label = new PanelLabel("Labels");
        label.setHorizontalAlignment(0);
        label.setBorder(SwingProgram.EMPTYBORDER);
        panel.add(label);
        AppearancePanel.addItem(panel, this.iTitle, "Title");
        Dimension panelDimen = this.iTitle.getPreferredSize();
        this.iTitle.setPreferredSize(new Dimension(panelDimen.width / 2, 1));
        this.iTitle.setText(this.iChartPanel.chart().title());
        this.iTitle.addActionListener(this.iEntryHandler);
        AppearancePanel.addItem(panel, this.iXLabel, "X label");
        this.iXLabel.setText(this.iChartPanel.chart().xLabel());
        this.iXLabel.addActionListener(this.iEntryHandler);
        AppearancePanel.addItem(panel, this.iYLabel, "Y label");
        this.iYLabel.setText(this.iChartPanel.chart().yLabel());
        this.iYLabel.addActionListener(this.iEntryHandler);
        label = new PanelLabel("Font sizes");
        label.setHorizontalAlignment(0);
        label.setBorder(SwingProgram.EMPTYBORDER);
        panel.add(label);
        AppearancePanel.addItem(panel, this.iTitleFont, "Title font size");
        this.iTitleFont.setValue(new Integer(this.iApp.titleFont().getSize()));
        this.iTitleFont.addChangeListener(this.iSpinnerHandler);
        AppearancePanel.addItem(panel, this.iLabelsFont, LONGESTPROMPT);
        this.iLabelsFont.setValue(new Integer(this.iApp.labelsFont().getSize()));
        this.iLabelsFont.addChangeListener(this.iSpinnerHandler);
        AppearancePanel.addItem(panel, this.iScalesFont, "Scales font size");
        this.iScalesFont.setValue(new Integer(this.iApp.scalesFont().getSize()));
        this.iScalesFont.addChangeListener(this.iSpinnerHandler);
        label = new PanelLabel("Colors");
        label.setHorizontalAlignment(0);
        label.setBorder(SwingProgram.EMPTYBORDER);
        panel.add(label);
        AppearancePanel.addItem(panel, this.iAxesColor, "Axes color");
        this.iAxesColor.setSelection(this.iApp.axesColor(), false);
        this.iAxesColor.addListener(this.iSelHandler);
        AppearancePanel.addItem(panel, this.iChartColor, "Chart color");
        this.iChartColor.setSelection(this.iApp.chartColor(), false);
        this.iChartColor.addListener(this.iSelHandler);
        AppearancePanel.addItem(panel, this.iLabelsColor, "Labels color");
        this.iLabelsColor.setSelection(this.iApp.labelsColor(), false);
        this.iLabelsColor.addListener(this.iSelHandler);
        AppearancePanel.addItem(panel, this.iPageColor, "Page color");
        this.iPageColor.setSelection(this.iApp.pageColor(), false);
        this.iPageColor.addListener(this.iSelHandler);
        AppearancePanel.addItem(panel, this.iScalesColor, "Scales color");
        this.iScalesColor.setSelection(this.iApp.scalesColor(), false);
        this.iScalesColor.addListener(this.iSelHandler);
        AppearancePanel.addItem(panel, this.iTicksColor, "Ticks color");
        this.iTicksColor.setSelection(this.iApp.ticksColor(), false);
        this.iTicksColor.addListener(this.iSelHandler);
        AppearancePanel.addItem(panel, this.iTitleColor, "Title color");
        this.iTitleColor.setSelection(this.iApp.titleColor(), false);
        this.iTitleColor.addListener(this.iSelHandler);
        label = new PanelLabel("Axes");
        label.setHorizontalAlignment(0);
        label.setBorder(SwingProgram.EMPTYBORDER);
        panel.add(label);
        AppearancePanel.addItem(panel, this.iShowXTicks, "Show X ticks");
        Boolean bool = this.iApp.isShowXTicks();
        this.iShowXTicks.setSelection(bool.toString(), false);
        this.iShowXTicks.addListener(this.iSelHandler);
        AppearancePanel.addItem(panel, this.iExtendTicks, "Extend ticks");
        bool = this.iApp.isExtendTicks();
        this.iExtendTicks.setSelection(bool.toString(), false);
        this.iExtendTicks.addListener(this.iSelHandler);
        AppearancePanel.addItem(panel, this.iShowXScales, "Show X scales");
        bool = this.iApp.isShowXScales();
        this.iShowXScales.setSelection(bool.toString(), false);
        this.iShowXScales.addListener(this.iSelHandler);
        label = new PanelLabel("Dimensions");
        label.setHorizontalAlignment(0);
        label.setBorder(SwingProgram.EMPTYBORDER);
        panel.add(label);
        AppearancePanel.addItem(panel, this.iBoundaryWidth, "Boundary width");
        this.iBoundaryWidth.setValue(this.iApp.boundaryWidth());
        this.iBoundaryWidth.addChangeListener(this.iSpinnerHandler);
        AppearancePanel.addItem(panel, this.iTickWidth, "Tick width");
        this.iTickWidth.setValue(this.iApp.tickWidth());
        this.iTickWidth.addChangeListener(this.iSpinnerHandler);
        AppearancePanel.addItem(panel, this.iLeftMargin, "Left margin");
        this.iLeftMargin.setValue(this.iApp.leftMargin());
        this.iLeftMargin.addChangeListener(this.iSpinnerHandler);
        AppearancePanel.addItem(panel, this.iRightMargin, "Right margin");
        this.iRightMargin.setValue(this.iApp.rightMargin());
        this.iRightMargin.addChangeListener(this.iSpinnerHandler);
        AppearancePanel.addItem(panel, this.iVertMargin, "Vertical margin");
        this.iVertMargin.setValue(this.iApp.vertMargin());
        this.iVertMargin.addChangeListener(this.iSpinnerHandler);
        AppearancePanel.addItem(panel, this.iNumYTicks, "Number Y ticks");
        this.iNumYTicks.setValue(this.iApp.numYTicks());
        this.iNumYTicks.addChangeListener(this.iSpinnerHandler);
        label = new PanelLabel("Scale formats");
        label.setHorizontalAlignment(0);
        label.setBorder(SwingProgram.EMPTYBORDER);
        panel.add(label);
        AppearancePanel.addItem(panel, this.iXScalesFormat, "X scale format");
        this.iXScalesFormat.setText(this.iApp.xScalesFormat());
        this.iXScalesFormat.addActionListener(this.iEntryHandler);
        AppearancePanel.addItem(panel, this.iYScalesFormat, "Y scale format");
        this.iYScalesFormat.setText(this.iApp.yScalesFormat());
        this.iYScalesFormat.addActionListener(this.iEntryHandler);
        label = new PanelLabel("Manual XY scaling");
        label.setHorizontalAlignment(0);
        label.setBorder(SwingProgram.EMPTYBORDER);
        panel.add(label);
        AppearancePanel.addItem(panel, this.iMinX, "Minimum X");
        if (this.iApp.minX().floatValue() != -99999.0f) {
            format = new DecimalFormat(this.iApp.xScalesFormat());
            value = format.format(this.iApp.minX());
            this.iMinX.setText(value);
        }
        this.iMinX.addActionListener(this.iEntryHandler);
        AppearancePanel.addItem(panel, this.iMaxX, "Maximum X");
        if (this.iApp.maxX().floatValue() != -99999.0f) {
            format = new DecimalFormat(this.iApp.xScalesFormat());
            value = format.format(this.iApp.maxX());
            this.iMaxX.setText(value);
        }
        this.iMaxX.addActionListener(this.iEntryHandler);
        AppearancePanel.addItem(panel, this.iMinY, "Minimum Y");
        if (this.iApp.minY().floatValue() != -99999.0f) {
            format = new DecimalFormat(this.iApp.yScalesFormat());
            value = format.format(this.iApp.minY());
            this.iMinY.setText(value);
        }
        this.iMinY.addActionListener(this.iEntryHandler);
        AppearancePanel.addItem(panel, this.iMaxY, "Maximum Y");
        if (this.iApp.maxY().floatValue() != -99999.0f) {
            format = new DecimalFormat(this.iApp.yScalesFormat());
            value = format.format(this.iApp.maxY());
            this.iMaxY.setText(value);
        }
        this.iMaxY.addActionListener(this.iEntryHandler);
    }

    private void setupScatter(ColorPanel panel) {
        Chart.ScatterAppearance sapp = (Chart.ScatterAppearance)this.iApp;
        PanelLabel label = new PanelLabel("Scatter chart");
        label.setHorizontalAlignment(0);
        label.setBorder(SwingProgram.EMPTYBORDER);
        panel.add(label);
        this.iScatterMark = new Selector(null, Chart.ScatterAppearance.Type.names());
        AppearancePanel.addItem(panel, this.iScatterMark, "Datapoint mark");
        this.iScatterMark.setSelection(sapp.type().name(), false);
        this.iScatterMark.addListener(this.iSelHandler);
        AppearancePanel.addItem(panel, this.iPointSize, "Point size");
        this.iPointSize.setValue(sapp.getMinPointSize());
        this.iPointSize.addChangeListener(this.iSpinnerHandler);
        AppearancePanel.addItem(panel, this.iShowCenterDot, "Show center dot");
        Boolean bool = sapp.isShowCenterDot();
        this.iShowCenterDot.setSelection(bool.toString(), false);
        this.iShowCenterDot.addListener(this.iSelHandler);
        int i = 1;
        Collection<Dataset.List<XYpoint.Float>> sets = this.iChartPanel.chart().sets();
        for (Dataset.List<XYpoint.Float> dataset : sets) {
            Selector.StdColor selector = new Selector.StdColor(null);
            AppearancePanel.addItem(panel, selector, "Dataset " + i + " color");
            Iterator<XYpoint.Float> iter = dataset.iterator();
            XYpoint.Float first = iter.next();
            selector.setSelection(first.stdColor(), false);
            selector.addListener(new DatasetHandler(selector, dataset));
            ++i;
        }
    }

    private void setupBar(ColorPanel panel) {
        Chart.VertBarAppearance bapp = (Chart.VertBarAppearance)this.iApp;
        PanelLabel label = new PanelLabel("Bar chart");
        label.setHorizontalAlignment(0);
        label.setBorder(SwingProgram.EMPTYBORDER);
        panel.add(label);
        AppearancePanel.addItem(panel, this.iBarSpacing, "Bar spacing");
        this.iBarSpacing.setValue(bapp.barSpacing());
        this.iBarSpacing.addChangeListener(this.iSpinnerHandler);
        AppearancePanel.addItem(panel, this.iDatasetSpacing, "Dataset spacing");
        this.iDatasetSpacing.setValue(bapp.datasetSpacing());
        this.iDatasetSpacing.addChangeListener(this.iSpinnerHandler);
    }

    private class CloseHandler
    implements ActionListener {
        private CloseHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            AppearancePanel.this.iViewer.close(AppearancePanel.this);
        }
    }

    private class DatasetHandler
    implements Selector.Listener {
        private Dataset<XYpoint.Float> iDataset = null;
        private Selector.StdColor iSelector = null;

        public DatasetHandler(Selector.StdColor selector, Dataset<XYpoint.Float> dataset) {
            this.iSelector = selector;
            this.iDataset = dataset;
        }

        @Override
        public synchronized void selected(Selector.Event event) {
            StdColor color = this.iSelector.selected();
            Iterator<XYpoint.Float> iter = this.iDataset.iterator();
            while (iter.hasNext()) {
                iter.next().setColor(color);
            }
            AppearancePanel.this.iChartPanel.repaint();
        }
    }

    private class EntryHandler
    implements ActionListener {
        private EntryHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == AppearancePanel.this.iTitle) {
                AppearancePanel.this.iChartPanel.chart().setTitle(AppearancePanel.this.iTitle.getText());
                AppearancePanel.this.iChartPanel.repaint();
            } else if (event.getSource() == AppearancePanel.this.iXLabel) {
                AppearancePanel.this.iChartPanel.chart().setXLabel(AppearancePanel.this.iXLabel.getText());
                AppearancePanel.this.iChartPanel.repaint();
            } else if (event.getSource() == AppearancePanel.this.iYLabel) {
                AppearancePanel.this.iChartPanel.chart().setYLabel(AppearancePanel.this.iYLabel.getText());
                AppearancePanel.this.iChartPanel.repaint();
            } else if (event.getSource() == AppearancePanel.this.iYScalesFormat) {
                AppearancePanel.this.iApp.setYScalesFormat(AppearancePanel.this.iYScalesFormat.getText());
                AppearancePanel.this.iChartPanel.repaint();
            } else if (event.getSource() == AppearancePanel.this.iXScalesFormat) {
                AppearancePanel.this.iApp.setXScalesFormat(AppearancePanel.this.iXScalesFormat.getText());
                AppearancePanel.this.iChartPanel.repaint();
            } else if (event.getSource() == AppearancePanel.this.iMinX) {
                String str = AppearancePanel.this.iMinX.getText();
                try {
                    float value = Float.parseFloat(str);
                    AppearancePanel.this.iApp.setMinX(Float.valueOf(value));
                    AppearancePanel.this.iChartPanel.rescale();
                    AppearancePanel.this.iChartPanel.repaint();
                    StatusBox.singleton().clearError();
                }
                catch (Exception xcp) {
                    StatusBox.singleton().showMsg("Invalid number: minimum X", true);
                }
            } else if (event.getSource() == AppearancePanel.this.iMaxX) {
                String str = AppearancePanel.this.iMaxX.getText();
                try {
                    float value = Float.parseFloat(str);
                    AppearancePanel.this.iApp.setMaxX(Float.valueOf(value));
                    AppearancePanel.this.iChartPanel.rescale();
                    AppearancePanel.this.iChartPanel.repaint();
                    StatusBox.singleton().clearError();
                }
                catch (Exception xcp) {
                    StatusBox.singleton().showMsg("Invalid number: maximum X", true);
                }
            } else if (event.getSource() == AppearancePanel.this.iMinY) {
                String str = AppearancePanel.this.iMinY.getText();
                try {
                    float value = Float.parseFloat(str);
                    AppearancePanel.this.iApp.setMinY(Float.valueOf(value));
                    AppearancePanel.this.iChartPanel.rescale();
                    AppearancePanel.this.iChartPanel.repaint();
                    StatusBox.singleton().clearError();
                }
                catch (Exception xcp) {
                    StatusBox.singleton().showMsg("Invalid number: minimum Y", true);
                }
            } else if (event.getSource() == AppearancePanel.this.iMaxY) {
                String str = AppearancePanel.this.iMaxY.getText();
                try {
                    float value = Float.parseFloat(str);
                    AppearancePanel.this.iApp.setMaxY(Float.valueOf(value));
                    AppearancePanel.this.iChartPanel.rescale();
                    AppearancePanel.this.iChartPanel.repaint();
                    StatusBox.singleton().clearError();
                }
                catch (Exception xcp) {
                    StatusBox.singleton().showMsg("Invalid number: maximum Y", true);
                }
            }
        }
    }

    private class SaveAppHandler
    implements ActionListener {
        private SaveAppHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            MString name = new MString(AppearancePanel.this.iApp.getClass().getName());
            name.remove("mchart.", 999, 0);
            name.remove("Chart$", 999, 0);
            name.remove("Appearance", 999, 0);
            name.toLowerCase();
            int index = AppearancePanel.this.iFilePath.lastIndexOf(File.separatorChar);
            String path = String.valueOf(AppearancePanel.this.iFilePath.substring(0, index + 1)) + name.toString() + ".cap";
            try {
                GZIPOutputStream zipout = new GZIPOutputStream(new FileOutputStream(path));
                ObjectOutputStream out = new ObjectOutputStream(zipout);
                out.writeObject(AppearancePanel.this.iChartPanel.chart());
                out.close();
                StatusBox.singleton().showMsg("Saved chart appearance: " + path, false);
            }
            catch (Exception xcp) {
                StatusBox.singleton().showMsg("Unable to save chart appearance: " + xcp.getClass().getName(), true);
            }
        }
    }

    private class SaveHandler
    implements ActionListener {
        private SaveHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                AppearancePanel.this.iChartPanel.chart().write(AppearancePanel.this.iFilePath);
                StatusBox.singleton().showMsg("Saved chart: " + AppearancePanel.this.iFilePath, false);
            }
            catch (Exception xcp) {
                StatusBox.singleton().showMsg("Unable to save chart: " + xcp.getClass().getName(), true);
            }
        }
    }

    private class SelectorHandler
    implements Selector.Listener {
        private SelectorHandler() {
        }

        @Override
        public synchronized void selected(Selector.Event event) {
            if (event.getSource() == AppearancePanel.this.iAxesColor) {
                StdColor color = AppearancePanel.this.iAxesColor.selected();
                AppearancePanel.this.iApp.setAxesColor(color);
            } else if (event.getSource() == AppearancePanel.this.iPageColor) {
                StdColor color = AppearancePanel.this.iPageColor.selected();
                AppearancePanel.this.iApp.setPageColor(color);
            } else if (event.getSource() == AppearancePanel.this.iChartColor) {
                StdColor color = AppearancePanel.this.iChartColor.selected();
                AppearancePanel.this.iApp.setChartColor(color);
            } else if (event.getSource() == AppearancePanel.this.iLabelsColor) {
                StdColor color = AppearancePanel.this.iLabelsColor.selected();
                AppearancePanel.this.iApp.setLabelsColor(color);
            } else if (event.getSource() == AppearancePanel.this.iScalesColor) {
                StdColor color = AppearancePanel.this.iScalesColor.selected();
                AppearancePanel.this.iApp.setScalesColor(color);
            } else if (event.getSource() == AppearancePanel.this.iTicksColor) {
                StdColor color = AppearancePanel.this.iTicksColor.selected();
                AppearancePanel.this.iApp.setTicksColor(color);
            } else if (event.getSource() == AppearancePanel.this.iTitleColor) {
                StdColor color = AppearancePanel.this.iTitleColor.selected();
                AppearancePanel.this.iApp.setTitleColor(color);
            } else if (event.getSource() == AppearancePanel.this.iShowXTicks) {
                Boolean bool = AppearancePanel.this.iShowXTicks.selected();
                AppearancePanel.this.iApp.setShowXTicks(bool);
            } else if (event.getSource() == AppearancePanel.this.iExtendTicks) {
                Boolean bool = AppearancePanel.this.iExtendTicks.selected();
                AppearancePanel.this.iApp.setExtendTicks(bool);
            } else if (event.getSource() == AppearancePanel.this.iShowXScales) {
                Boolean bool = AppearancePanel.this.iShowXScales.selected();
                AppearancePanel.this.iApp.setShowXScales(bool);
            } else if (event.getSource() == AppearancePanel.this.iScatterMark) {
                String name = AppearancePanel.this.iScatterMark.getSelection();
                Chart.ScatterAppearance sapp = (Chart.ScatterAppearance)AppearancePanel.this.iApp;
                sapp.setType(Chart.ScatterAppearance.Type.forName(name));
            } else if (event.getSource() == AppearancePanel.this.iShowCenterDot) {
                Chart.ScatterAppearance sapp = (Chart.ScatterAppearance)AppearancePanel.this.iApp;
                Boolean bool = AppearancePanel.this.iShowCenterDot.selected();
                sapp.setShowCenterDot(bool);
            }
            AppearancePanel.this.iChartPanel.repaint();
        }
    }

    private class SpinnerHandler
    implements ChangeListener {
        private SpinnerHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            if (event.getSource() == AppearancePanel.this.iBoundaryWidth) {
                Integer width = (Integer)AppearancePanel.this.iBoundaryWidth.getModel().getValue();
                AppearancePanel.this.iApp.setBoundaryWidth(width);
            } else if (event.getSource() == AppearancePanel.this.iTickWidth) {
                Integer width = (Integer)AppearancePanel.this.iTickWidth.getModel().getValue();
                AppearancePanel.this.iApp.setTickWidth(width);
            } else if (event.getSource() == AppearancePanel.this.iLeftMargin) {
                Integer width = (Integer)AppearancePanel.this.iLeftMargin.getModel().getValue();
                AppearancePanel.this.iApp.setLeftMargin(width);
            } else if (event.getSource() == AppearancePanel.this.iRightMargin) {
                Integer width = (Integer)AppearancePanel.this.iRightMargin.getModel().getValue();
                AppearancePanel.this.iApp.setRightMargin(width);
            } else if (event.getSource() == AppearancePanel.this.iVertMargin) {
                Integer width = (Integer)AppearancePanel.this.iVertMargin.getModel().getValue();
                AppearancePanel.this.iApp.setVertMargin(width);
            } else if (event.getSource() == AppearancePanel.this.iTitleFont) {
                Font current = AppearancePanel.this.iApp.titleFont();
                Integer width = (Integer)AppearancePanel.this.iTitleFont.getModel().getValue();
                Font font = current.deriveFont((float)width.intValue() * 1.0f);
                AppearancePanel.this.iApp.setTitleFont(font);
            } else if (event.getSource() == AppearancePanel.this.iLabelsFont) {
                Font current = AppearancePanel.this.iApp.labelsFont();
                Integer width = (Integer)AppearancePanel.this.iLabelsFont.getModel().getValue();
                Font font = current.deriveFont((float)width.intValue() * 1.0f);
                AppearancePanel.this.iApp.setLabelsFont(font);
            } else if (event.getSource() == AppearancePanel.this.iScalesFont) {
                Font current = AppearancePanel.this.iApp.scalesFont();
                Integer width = (Integer)AppearancePanel.this.iScalesFont.getModel().getValue();
                Font font = current.deriveFont((float)width.intValue() * 1.0f);
                AppearancePanel.this.iApp.setScalesFont(font);
            } else if (event.getSource() == AppearancePanel.this.iNumYTicks) {
                Integer num = (Integer)AppearancePanel.this.iNumYTicks.getModel().getValue();
                AppearancePanel.this.iApp.setNumYTicks(num);
            } else if (AppearancePanel.this.iChartPanel.chart().drawer().getClass() == ScatterDrawer.class) {
                Chart.ScatterAppearance sapp = (Chart.ScatterAppearance)AppearancePanel.this.iApp;
                Integer num = (Integer)AppearancePanel.this.iPointSize.getModel().getValue();
                sapp.setMinPointSize(num);
            } else if (AppearancePanel.this.iChartPanel.chart().drawer().getClass() == VertBarDrawer.class) {
                Chart.VertBarAppearance bapp = (Chart.VertBarAppearance)AppearancePanel.this.iApp;
                if (event.getSource() == AppearancePanel.this.iBarSpacing) {
                    Integer num = (Integer)AppearancePanel.this.iBarSpacing.getModel().getValue();
                    bapp.setBarSpacing(num);
                } else if (event.getSource() == AppearancePanel.this.iDatasetSpacing) {
                    Integer num = (Integer)AppearancePanel.this.iDatasetSpacing.getModel().getValue();
                    bapp.setDatasetSpacing(num);
                }
            }
            AppearancePanel.this.iChartPanel.repaint();
        }
    }
}

