/*
 * Decompiled with CFR 0.152.
 */
package bpv;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.TreeMap;
import minstall.Installation;
import mlib.MLogging;

class UserData
implements Comparable<UserData>,
Serializable {
    private String iUserId = null;
    private Date iLastUse = null;
    private TreeMap<String, Integer> iViewings = new TreeMap();

    UserData(Date userId) {
        this.iUserId = userId.toString();
        this.iLastUse = new Date();
    }

    void setLastUse(Date date) {
        this.iLastUse = date;
    }

    int incViewings(String album) {
        int newCount = this.iViewings.get(album) + 1;
        this.iViewings.put(album, newCount);
        return newCount;
    }

    boolean equals(UserData data) {
        return this.compareTo(data) == 0;
    }

    int albumViewings(String name) {
        return this.iViewings.get(name);
    }

    int totalViewings() {
        int total = 0;
        for (String album : this.iViewings.keySet()) {
            total += this.albumViewings(album);
        }
        return total;
    }

    @Override
    public int compareTo(UserData data) {
        return this.totalViewings() - data.totalViewings();
    }

    public String toString() {
        String str = this.iUserId + "," + this.iLastUse + "," + this.totalViewings();
        return str;
    }

    static class Database
    implements Serializable {
        private TreeMap<String, UserData> iDb = new TreeMap();
        static final String FILENAME = "bpv.dat";

        static void main(String[] args) {
            ObjectOutputStream out = null;
            try {
                try {
                    Database db = new Database();
                    String path = String.valueOf(System.getProperty("user.home")) + File.separator + FILENAME;
                    out = new ObjectOutputStream(new FileOutputStream(path));
                    out.writeObject(db);
                }
                catch (Exception xcp) {
                    System.out.println(xcp);
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }

        Database() {
        }

        void add(String userId) {
            Installation install = Installation.singleton();
            UserData data = new UserData(install.date());
            this.iDb.put(userId, data);
        }

        int numUsers() {
            return this.iDb.keySet().size();
        }

        UserData userData(String userId) {
            return this.iDb.get(userId);
        }

        int totalViewings() {
            int total = 0;
            for (UserData data : this.iDb.values()) {
                total += data.totalViewings();
            }
            return total;
        }

        int incCount(String userId, String album) {
            UserData data = this.iDb.get(userId);
            int newCount = data.incViewings(album);
            return newCount;
        }

        void list(MLogging logger) {
        }

        public String toString() {
            String str = this.numUsers() + " users, " + this.totalViewings() + " viewings";
            return str;
        }
    }
}

