/*
 * Decompiled with CFR 0.152.
 */
package bpv;

import bpv.BpvMsgs;
import bpv.PicDialog;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import mlib.MAppMsg;
import mlib.MString;
import oroma.website.WebImg;
import swing.ColorPanel;
import swing.PanelLabel;
import swing.StatusBox;
import swing.SwingProgram;
import utilt.Utility;

class Thumbnail
extends ColorPanel {
    private int iNum = -1;
    private WebImg iWebImg = null;
    private Thumbnail iPrev = null;
    private Thumbnail iNext = null;
    private static final int MAXLABELLEN = 32;

    private static String label(WebImg webImg) {
        String imgLabel = webImg.label();
        if (imgLabel.length() > 32) {
            try {
                MString work = new MString();
                String[] tokens = Utility.parseDelimStr(imgLabel, ",");
                boolean done = false;
                int i = 0;
                while (i < tokens.length && !done) {
                    if (work.length() + tokens[i].length() < 32) {
                        if (work.length() > 0) {
                            work.concat(", ");
                        }
                        work.concat(tokens[i]);
                    }
                    ++i;
                }
                imgLabel = work.toString();
            }
            catch (Exception xcp) {
                System.out.println(xcp);
            }
        }
        return imgLabel;
    }

    Thumbnail(int num, WebImg webImg, Image image, Thumbnail prev) {
        this.iWebImg = webImg;
        this.iPrev = prev;
        this.iNum = num;
        this.setLayout(new BoxLayout(this, 1));
        this.setLayout(new BoxLayout(this, 1));
        PanelLabel icon = new PanelLabel(new ImageIcon(image));
        icon.setAlignmentX(0.5f);
        icon.setHorizontalAlignment(0);
        icon.setBorder(BorderFactory.createEtchedBorder());
        String imgLabel = Thumbnail.label(webImg);
        PanelLabel label = new PanelLabel(imgLabel.toString());
        label.setVerticalTextPosition(1);
        this.add(label);
        this.add(icon);
        this.setBorder(SwingProgram.STDBORDER);
        icon.addMouseListener(new MouseHandler());
    }

    void setNext(Thumbnail tnail) {
        this.iNext = tnail;
    }

    WebImg webImg() {
        return this.iWebImg;
    }

    Thumbnail prev() {
        return this.iPrev;
    }

    Thumbnail next() {
        return this.iNext;
    }

    int num() {
        return this.iNum;
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getClickCount() > 1) {
                try {
                    Thumbnail.this.setCursor(Cursor.getPredefinedCursor(3));
                    PicDialog dialog = new PicDialog(Thumbnail.this);
                    dialog.setVisible(true);
                    Thumbnail.this.setCursor(Cursor.getDefaultCursor());
                    dialog.requestFocus();
                }
                catch (Exception xcp) {
                    MAppMsg msg = BpvMsgs.get("unable_load_photo");
                    StatusBox.singleton().queueShowMsg(msg.format(xcp), msg.isError());
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            Thumbnail.this.setBorder(BorderFactory.createEtchedBorder(Color.red, Color.gray));
        }

        @Override
        public void mouseExited(MouseEvent event) {
            Thumbnail.this.setBorder(SwingProgram.STDBORDER);
        }
    }
}

