/*
 * Decompiled with CFR 0.152.
 */
package bpv;

import bpv.Album;
import bpv.DisplayFiller;
import bpv.Main;
import bpv.SearchDialog;
import help.HelpPrefs;
import help.HelpWindow;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.EventObject;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import swing.ColorButton;
import swing.ColorPanel;
import swing.EntryField;
import swing.PanelLabel;
import swing.WheelComboBox;

class SelectionPanel
extends ColorPanel {
    private Album iAlbum = null;
    private WheelComboBox jAlbumBox = null;
    private WheelComboBox jOrderBox = null;
    private EntryField jSelectionField = null;
    private ColorButton jHelpButton = null;
    private ColorButton jSearchButton = null;
    private SearchDialog jSearchDialog = null;
    private AlbumHandler iAlbumHandler = new AlbumHandler();
    private boolean iNoneAdded = false;
    private static SelectionPanel Singleton = null;
    static final String None = "None";

    static SelectionPanel singleton() {
        return Singleton;
    }

    SelectionPanel(TreeMap<String, Album> albums) {
        this.setBackground(SystemColor.control);
        this.setLayout(new BoxLayout(this, 0));
        TreeSet<Album> ordered = new TreeSet<Album>();
        ordered.addAll(albums.values());
        this.add(new PanelLabel(" Album: "));
        this.add(this.albumBox(ordered));
        this.add(new PanelLabel(" Order: "));
        this.add(this.orderBox());
        this.add(new PanelLabel(" Select: "));
        this.add(this.selectField());
        this.add(this.searchButton());
        this.add(this.helpButton());
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.jAlbumBox.getPreferredSize();
        size.width = (int)((double)screen.width * 0.5);
        this.jAlbumBox.setPreferredSize(size);
        Singleton = this;
    }

    void enableControls(boolean enable) {
        this.jAlbumBox.setEnabled(enable);
        this.jSelectionField.setEnabled(enable);
        this.jSearchButton.setEnabled(enable);
        this.jOrderBox.setEnabled(enable);
    }

    void selectFirstAlbum() {
        this.iAlbumHandler.selected(null);
    }

    String orderBy() {
        return (String)this.orderBox().getSelectedItem();
    }

    private EntryField selectField() {
        if (this.jSelectionField == null) {
            this.jSelectionField = new EntryField();
            this.jSelectionField.addActionListener(new SelectionHandler());
            this.jSelectionField.setToolTipText("Select photos from album");
        }
        return this.jSelectionField;
    }

    private WheelComboBox albumBox(Collection<Album> albums) {
        if (this.jAlbumBox == null) {
            this.jAlbumBox = new WheelComboBox();
            this.jAlbumBox.setKeepOrder(true);
            this.jAlbumBox.setEnabled(true);
            boolean didFirst = false;
            for (Album album : albums) {
                this.jAlbumBox.addItem(album.title());
                if (didFirst) continue;
                this.jAlbumBox.setSelectedItem(album.title());
                didFirst = true;
            }
            this.jAlbumBox.addListener(this.iAlbumHandler);
            this.jAlbumBox.setToolTipText("Select album");
        }
        return this.jAlbumBox;
    }

    private WheelComboBox orderBox() {
        if (this.jOrderBox == null) {
            this.jOrderBox = new WheelComboBox();
            Object[] options = new String[]{"By date", "By region", "By id"};
            this.jOrderBox.setItems(options);
            this.jOrderBox.setEditable(false);
            this.jOrderBox.setEnabled(false);
            this.jOrderBox.setKeepOrder(true);
            this.jOrderBox.addListener(new OrderHandler());
            this.jOrderBox.setToolTipText("Order photos");
        }
        return this.jOrderBox;
    }

    private ColorButton helpButton() {
        if (this.jHelpButton == null) {
            this.jHelpButton = new ColorButton(" Help ");
            this.jHelpButton.addActionListener(new HelpHandler());
            this.jHelpButton.setToolTipText("Display help");
        }
        return this.jHelpButton;
    }

    private ColorButton searchButton() {
        if (this.jSearchButton == null) {
            this.jSearchButton = new ColorButton(" Search ");
            this.jSearchButton.setToolTipText("Search albums for photos");
            this.jSearchButton.addActionListener(new SearchHandler());
        }
        return this.jSearchButton;
    }

    private class AlbumHandler
    implements WheelComboBox.Listener {
        private AlbumHandler() {
        }

        @Override
        public boolean selected(EventObject event) {
            String title = ((String)SelectionPanel.this.jAlbumBox.getSelectedItem()).trim();
            if (!title.equals(SelectionPanel.None)) {
                SelectionPanel.this.enableControls(false);
                SelectionPanel.this.iAlbum = Main.singleton().findAlbum(title);
                String orderBy = SelectionPanel.this.iAlbum.query().ordering();
                SelectionPanel.this.orderBox().setSelectedItem(orderBy);
                SelectionPanel.this.selectField().setText("");
                DisplayFiller filler = new DisplayFiller(true);
                filler.doAlbum(SelectionPanel.this.iAlbum, orderBy);
            }
            return true;
        }
    }

    private class HelpHandler
    implements ActionListener {
        private HelpHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ImageIcon icon = Main.singleton().iconMgr().icon("bpm");
            HelpWindow dialog = HelpWindow.create(Main.TheHelpTree, icon, new HelpPrefs());
            dialog.setVisible(true);
        }
    }

    private class OrderHandler
    implements WheelComboBox.Listener {
        private OrderHandler() {
        }

        @Override
        public boolean selected(EventObject event) {
            SelectionPanel.this.enableControls(false);
            String selection = (String)SelectionPanel.this.orderBox().getSelectedItem();
            DisplayFiller filler = new DisplayFiller(false);
            filler.doOrdering(selection);
            return true;
        }
    }

    private class SearchHandler
    implements ActionListener {
        private SearchHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (!SelectionPanel.this.iNoneAdded) {
                SelectionPanel.this.jAlbumBox.addItem(SelectionPanel.None);
                SelectionPanel.this.iNoneAdded = true;
            }
            SelectionPanel.this.jAlbumBox.setSelectedItem(SelectionPanel.None);
            SelectionPanel.this.selectField().setText("");
            if (SelectionPanel.this.jSearchDialog == null) {
                SelectionPanel.this.jSearchDialog = new SearchDialog();
            }
            SelectionPanel.this.jSearchDialog.setVisible(true);
        }
    }

    private class SelectionHandler
    implements ActionListener {
        private SelectionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent obj) {
            SelectionPanel.this.enableControls(false);
            String orderBy = (String)SelectionPanel.this.orderBox().getSelectedItem();
            String selection = SelectionPanel.this.selectField().getText().toLowerCase();
            DisplayFiller filler = new DisplayFiller(false);
            filler.doSelection(selection, orderBy);
        }
    }
}

