/*
 * Decompiled with CFR 0.152.
 */
package bpv;

import bpv.BpvMsgs;
import bpv.DisplayFiller;
import bpv.ImageLoader;
import bpv.Thumbnail;
import dialog.CenteredDialog;
import dialog.DialogEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.EventObject;
import javax.swing.Timer;
import mlib.MAppMsg;
import oroma.albumgui.PicInfoSummary;
import swing.ColorPanel;
import swing.PanelLabel;
import swing.StatusBox;
import swing.SwingProgram;
import swing.WheelComboBox;
import swing.ZoomableImagePanel;

class PicDialog
extends CenteredDialog {
    private ZoomableImagePanel iImgPanel = new ZoomableImagePanel();
    private Thumbnail iThumb = null;
    private Image iImage = null;
    private ImageLoader iNextLoader = null;
    private boolean iSlides = false;
    private boolean iPaused = false;
    private int iSlideInterval = 5;
    private int iTimerCount = 0;
    private Timer iTimer = null;
    private SlideshowHandler iShowHandler = new SlideshowHandler();
    private WheelComboBox jIntervalBox = null;
    private int iPrevButton = -1;
    private int iNextButton = -1;
    private int iSlideshowButton = -1;
    private int iPauseButton = -1;
    private static final int DEFAULTINTERVAL = 5;
    private static final String PAUSE = "Pause";
    private static final String SLIDESHOW = "Slideshow";
    private static final double MAXVIEWFACTOR = 0.95;
    private static double MaxViewFactor = 0.8;
    private static int MaxViewPixels = 800;
    private static boolean CanMaximize = true;
    private static boolean Zoomable = false;

    static void putMaxViewFactor(double factor) {
        if (MaxViewFactor > 0.95) {
            factor = 0.95;
        }
        MaxViewFactor = factor;
    }

    static void putMaxViewPixels(int pixels) {
        MaxViewPixels = pixels;
    }

    static void putZoomable(boolean zoomable) {
        Zoomable = zoomable;
    }

    PicDialog(Thumbnail tnail) throws Exception {
        this.iThumb = tnail;
        this.setModal(true);
        Toolkit tKit = Toolkit.getDefaultToolkit();
        Dimension screen = tKit.getScreenSize();
        int maxHeight = (int)((double)screen.height * MaxViewFactor);
        ZoomableImagePanel.putMaxNomarkSize(maxHeight);
        this.setupButtons();
        this.setResizable(CanMaximize);
        this.iImgPanel.setBorder(SwingProgram.STDBORDER);
        ColorPanel panel = new ColorPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)PicInfoSummary.singleton(), "North");
        panel.add((Component)this.iImgPanel, "Center");
        this.addClientPanel(panel);
        this.showPic();
        this.addWindowListener(new WindowHandler());
        this.fetchNext();
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public void custom(int index, DialogEvent event) {
        if (index == this.iPrevButton) {
            if (this.iThumb.prev() != null) {
                this.iThumb = this.iThumb.prev();
                this.showPic();
            }
        } else if (index == this.iNextButton) {
            if (this.iThumb.next() != null) {
                this.iThumb = this.iThumb.next();
                this.showPic();
                this.fetchNext();
            }
        } else if (index == this.iSlideshowButton) {
            if (this.iSlides) {
                this.endSlideshow();
            } else {
                this.putCustomLabel(SLIDESHOW, SLIDESHOW);
                this.putCustomLabel("Resume", PAUSE);
                this.enableCustomButton(this.iPauseButton, true);
                this.enableCustomButton(this.iPrevButton, false);
                this.enableCustomButton(this.iNextButton, false);
                this.iTimerCount = 0;
                this.iTimer = new Timer(1000, this.iShowHandler);
                this.iTimer.setRepeats(true);
                this.iTimer.setInitialDelay(0);
                this.iTimer.start();
                MAppMsg msg = BpvMsgs.get("slideshow_started");
                StatusBox.singleton().showMsg(msg.format(), msg.isError());
            }
            this.iSlides = !this.iSlides;
        } else if (index == this.iPauseButton) {
            if (this.iPaused) {
                this.putCustomLabel("Resume", PAUSE);
                this.iTimer.start();
            } else {
                this.putCustomLabel(PAUSE, "Resume");
                this.iTimer.stop();
            }
            this.iPaused = !this.iPaused;
        }
        this.requestFocus();
    }

    private void endSlideshow() {
        if (this.iTimer != null) {
            this.iTimer.stop();
            this.enableCustomButton(this.iPauseButton, false);
            this.enableCustomButton(this.iPrevButton, true);
            this.enableCustomButton(this.iNextButton, true);
            this.putCustomLabel(SLIDESHOW, SLIDESHOW);
            MAppMsg msg = BpvMsgs.get("slideshow_ended");
            StatusBox.singleton().showMsg(msg.format(), msg.isError());
        }
    }

    private void fetchNext() {
        Thumbnail nextThumb = this.iThumb.next();
        if (nextThumb != null) {
            if (this.iNextLoader != null) {
                try {
                    this.iNextLoader.join();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!nextThumb.webImg().equals(this.iThumb.webImg())) {
                this.iNextLoader = new ImageLoader(nextThumb.webImg(), false);
                this.iNextLoader.start();
            }
        }
    }

    private void showPic() {
        boolean haveNext;
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.iImage = null;
        if (this.iNextLoader != null) {
            try {
                this.iNextLoader.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean bl = haveNext = this.iNextLoader != null && this.iNextLoader.image() != null && this.iNextLoader.webImg().equals(this.iThumb.webImg());
        if (haveNext) {
            this.iImage = this.iNextLoader.image();
        } else {
            this.iNextLoader = new ImageLoader(this.iThumb.webImg(), false);
            this.iNextLoader.start();
            try {
                this.iNextLoader.join();
                this.iImage = this.iNextLoader.image();
            }
            catch (Exception xcp) {
                System.out.println(xcp);
            }
        }
        if (this.iImage == null) {
            MAppMsg msg = BpvMsgs.get("unable_load_photo");
            StatusBox.singleton().showMsg(msg.format("unknown"), msg.isError());
        } else {
            boolean zoomable = this.iThumb.webImg().album().isZoomable() || Zoomable;
            this.iImgPanel.showPic(this.iImage, this.iThumb.webImg().isUseMark(), zoomable);
            PicInfoSummary.singleton().put(this.iThumb.webImg().picInfo());
            MAppMsg msg = BpvMsgs.get("displayed_photo");
            int numImgs = DisplayFiller.numDisplayImgs();
            StatusBox.singleton().showMsg(msg.format(this.iThumb.num(), numImgs), msg.isError());
            this.validate();
            this.repaint();
            this.maximize();
            this.setCursor(Cursor.getDefaultCursor());
            int height = this.iImage.getHeight(null);
            int width = this.iImage.getWidth(null);
            String albumTitle = this.iThumb.webImg().album().title();
            int start = albumTitle.indexOf(", ");
            if (start >= 0) {
                albumTitle = albumTitle.substring(0, start);
            }
            String title = String.valueOf(albumTitle) + ", " + " photo " + this.iThumb.num() + " (" + width + " x " + height + ")";
            this.setTitle(title);
            this.requestFocus();
            if (!this.iSlides) {
                boolean enable = this.iThumb.prev() != null;
                this.enableCustomButton(this.iPrevButton, enable);
                enable = this.iThumb.next() != null;
                this.enableCustomButton(this.iNextButton, enable);
            }
        }
    }

    private void setupButtons() {
        this.iSlideshowButton = this.addCustomButton(SLIDESHOW, 's', null, SLIDESHOW);
        this.addComp(new PanelLabel("Interval:"));
        this.addComp(this.intervalBox());
        this.iPauseButton = this.addCustomButton(PAUSE, 's', null, null);
        this.enableCustomButton(this.iPauseButton, false);
        this.iPrevButton = this.addCustomButton("Previous", 'p', null, null);
        this.iNextButton = this.addCustomButton("Next", 'n', null, null);
        this.removeAcceptButton();
        this.removeCancelButton();
    }

    private void maximize() {
        int height;
        Toolkit tKit = Toolkit.getDefaultToolkit();
        Dimension screen = tKit.getScreenSize();
        int width = (int)(1.0 * (double)screen.width * MaxViewFactor);
        if (width > MaxViewPixels) {
            width = MaxViewPixels;
        }
        if ((height = (int)(1.0 * (double)screen.height * MaxViewFactor)) > MaxViewPixels) {
            height = MaxViewPixels;
        }
        this.center(width, height);
    }

    private WheelComboBox intervalBox() {
        if (this.jIntervalBox == null) {
            this.jIntervalBox = new WheelComboBox();
            Object[] options = new String[]{"2", "3", "4", "5", "10", "15", "30"};
            this.jIntervalBox.setItems(options);
            this.jIntervalBox.setEditable(false);
            this.jIntervalBox.setEnabled(true);
            this.jIntervalBox.setKeepOrder(true);
            this.jIntervalBox.setBackground(SystemColor.control);
            this.jIntervalBox.setForeground(SystemColor.controlText);
            this.jIntervalBox.addListener(new IntervalHandler());
            this.jIntervalBox.setToolTipText("Order photos");
            this.jIntervalBox.setSelectedItem(new Integer(5).toString());
        }
        return this.jIntervalBox;
    }

    private class IntervalHandler
    implements WheelComboBox.Listener {
        private IntervalHandler() {
        }

        @Override
        public boolean selected(EventObject event) {
            String interval = ((String)PicDialog.this.jIntervalBox.getSelectedItem()).trim();
            PicDialog.this.iSlideInterval = Integer.parseInt(interval);
            return true;
        }
    }

    private class SlideshowHandler
    implements ActionListener {
        private SlideshowHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            PicDialog picDialog = PicDialog.this;
            picDialog.iTimerCount = picDialog.iTimerCount + 1;
            if (PicDialog.this.iTimerCount >= PicDialog.this.iSlideInterval) {
                PicDialog.this.iTimerCount = 0;
                if (PicDialog.this.iThumb.next() != null) {
                    PicDialog.this.iThumb = PicDialog.this.iThumb.next();
                    PicDialog.this.showPic();
                    PicDialog.this.fetchNext();
                } else {
                    PicDialog.this.endSlideshow();
                }
            }
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            PicDialog.this.endSlideshow();
        }
    }
}

