/*
 * Decompiled with CFR 0.152.
 */
package bpv;

import bpv.Album;
import bpv.AlbumGroup;
import bpv.BpvMsgs;
import bpv.PicDialog;
import bpv.SelectionPanel;
import help.HelpTree;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JTabbedPane;
import minstall.Installation;
import mlib.MAppMsg;
import mlib.MEncrypter;
import mlib.MIniProps;
import oroma.gui.BpmMsgs;
import oroma.website.WebImg;
import swing.ColorPanel;
import swing.PanelLabel;
import swing.SplashScreen;
import swing.StatusBox;
import swing.VersionedProgram;
import swing.ZoomableImagePanel;
import utilt.Utility;

public class Main
extends VersionedProgram {
    private String iBaseUrl = "";
    private String iListFile = "";
    private AlbumGroup iGroup = null;
    private LinkedList<WebImg> iAllWebImgs = new LinkedList();
    private TreeMap<String, Album> iAlbums = new TreeMap();
    private StatusPanel iStatusPanel = new StatusPanel();
    private JTabbedPane iTabsPanel = new JTabbedPane();
    private int iNumCols = 3;
    static final String PROGNAME = "Bluemont Photo Viewer";
    private static final String VERSION = "14-Jan-2026";
    private static final String WEBSITEURL = "http://www.bluemontsw.com/bpv/";
    private static final String PROGTITLE = "Bluemont Photo Viewer version 14-Jan-2026";
    public static final String IMAGESFILENAME = "images.dat";
    static final char DELIM = '#';
    static final int KEYOFFSET = 1001;
    static final String[] SearchFields = new String[]{"place", "location", "town", "region", "country"};
    private static final String BASEURLARG = "u";
    private static final String ALBUMGROUPARG = "a";
    private static final String PREFFILE = "pref.ini";
    private static SplashScreen Splash = null;
    static Main Singleton = null;
    static HelpTree TheHelpTree = null;

    static Main singleton() {
        return Singleton;
    }

    public static void main(String[] args) {
        try {
            boolean installed = Installation.read(".bpv", "a52gg8lpk.ins");
            if (!installed) {
                MAppMsg msg = BpvMsgs.get("not_installed");
                System.out.println(msg.format());
            } else {
                Singleton = new Main();
                if (Singleton.parseArgs(args)) {
                    URL url = Main.class.getResource("splash.gif");
                    Splash = new SplashScreen(url);
                    Splash.splash();
                    Singleton.process();
                }
            }
        }
        catch (Exception xcp) {
            MAppMsg msg = BpvMsgs.get("startup_error");
            System.out.println(msg.format(Utility.xcpMsg(xcp)));
        }
        if (Splash != null) {
            Splash.dispose();
        }
    }

    Album findAlbum(String title) {
        return this.iAlbums.get(title);
    }

    int numCols() {
        return this.iNumCols;
    }

    String baseUrl() {
        return this.iBaseUrl;
    }

    JTabbedPane tabsPanel() {
        return this.iTabsPanel;
    }

    LinkedList<WebImg> allImages() {
        return this.iAllWebImgs;
    }

    private Main() throws Exception {
        super(PROGTITLE);
        this.progArgs().addArg(BASEURLARG, "Base URL", "http://www.bluemontsw.com", true, 1, 1);
        this.progArgs().addArg(ALBUMGROUPARG, "AlbumGroup file", "bpv.grp", true, 1, 1);
        this.setExtendedState(6);
        this.addWindowListener(new WindowHandler());
        Toolkit tKit = Toolkit.getDefaultToolkit();
        Dimension screen = tKit.getScreenSize();
        if (screen.width > 1400) {
            this.iNumCols = 4;
        }
        this.setIconImage(this.iconMgr().icon("bpm").getImage());
        Singleton = this;
    }

    private void process() throws Exception {
        this.setLogger(Installation.singleton().fileLogger());
        TheHelpTree = HelpTree.readZip(new File("help.dat"));
        StatusBox.singleton().showMsg(PROGTITLE, false);
        this.setupPrefs();
        this.loadAlbumGroup();
        this.loadAlbums();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.iTabsPanel, "Center");
        contentPane.add((Component)this.iStatusPanel, "South");
        SelectionPanel panel = new SelectionPanel(this.iAlbums);
        this.getContentPane().add((Component)panel, "North");
        this.setTitle(PROGNAME);
        String info = "Total: " + this.iAlbums.size() + " albums and " + this.iAllWebImgs.size() + " photos";
        this.iStatusPanel.setInfo(info);
        MAppMsg msg = BpvMsgs.get("found_albums");
        Singleton.logger().writeln(msg.format(this.iAlbums.size(), this.iAllWebImgs.size()));
        this.validate();
        this.repaint();
        Splash.dispose();
        this.setVisible(true);
        panel.selectFirstAlbum();
        this.checkVersion();
    }

    private void loadAlbumGroup() throws Exception {
        this.iBaseUrl = this.progArgs().argValue(BASEURLARG, 0).trim();
        if (!this.iBaseUrl.endsWith("/")) {
            this.iBaseUrl = String.valueOf(this.iBaseUrl) + "/";
        }
        this.iListFile = this.progArgs().argValue(ALBUMGROUPARG, 0).trim();
        String urlStr = String.valueOf(this.iBaseUrl) + "bpv" + "/" + this.iListFile;
        URL url = new URL(urlStr);
        ObjectInputStream in = new ObjectInputStream(url.openStream());
        this.iGroup = (AlbumGroup)in.readObject();
        in.close();
        this.logger().writeln("Loaded Album Group: " + this.iGroup);
        PicDialog.putMaxViewFactor(this.iGroup.maxViewFactor());
        PicDialog.putMaxViewPixels(this.iGroup.maxViewPixels());
        ZoomableImagePanel.putImageMarkType(this.iGroup.mark());
        ZoomableImagePanel.putCopyrightMsg(this.iGroup.copyrightMsg());
    }

    private void loadAlbums() throws Exception {
        TreeSet imgs = new TreeSet();
        MEncrypter encrypter = new MEncrypter(this.iGroup.date() + 1001L);
        LinkedList<AlbumGroup.ViewerAlbum> vAlbums = this.iGroup.albums();
        for (AlbumGroup.ViewerAlbum vAlbum : vAlbums) {
            Album album = new Album(vAlbum.query(), encrypter, vAlbum.isUseMark(), vAlbum.isZoomable());
            String urlStr = String.valueOf(this.iBaseUrl) + album.serverFolder() + "/" + IMAGESFILENAME;
            URL url = new URL(urlStr);
            ObjectInputStream in = new ObjectInputStream(url.openStream());
            LinkedList webImgs = (LinkedList)in.readObject();
            in.close();
            for (WebImg webImg : webImgs) {
                webImg.setAlbum(album);
                webImg.setServerFolder(album.serverFolder());
            }
            imgs.addAll(webImgs);
            this.iAlbums.put(album.title(), album);
            this.logger().writeln("Added Album: " + album.title());
        }
        this.iAllWebImgs.addAll(imgs);
        MAppMsg msg = BpvMsgs.get("found_albums");
        StatusBox.singleton().showMsg(msg.format(this.iAlbums.size(), this.iAllWebImgs.size()), msg.isError());
    }

    private void setupPrefs() {
        try {
            MIniProps props = MIniProps.read(new File(PREFFILE));
            String[] fontProp = props.propValue("bpv", "font");
            int fontSize = Utility.stdFontSize();
            if (!fontProp[0].equals("*")) {
                fontSize = Integer.parseInt(fontProp[0]);
            }
            int type = 0;
            if (fontProp[0].equalsIgnoreCase("bold")) {
                type = 1;
            }
            Font font = new Font(this.pref().fontName(), type, fontSize);
            this.pref().setMenuFont(font);
            fontProp = props.propValue("bpv", "backcolor");
            Color backColor = new Color(Integer.parseInt(fontProp[0]), Integer.parseInt(fontProp[1]), Integer.parseInt(fontProp[2]));
            this.pref().setPanelBackColor(backColor);
            fontProp = props.propValue("bpv", "forecolor");
            Color foreColor = new Color(Integer.parseInt(fontProp[0]), Integer.parseInt(fontProp[1]), Integer.parseInt(fontProp[2]));
            this.pref().setPanelForeColor(foreColor);
            fontProp = props.propValue("bpv", "entrycolor");
            Color entryColor = new Color(Integer.parseInt(fontProp[0]), Integer.parseInt(fontProp[1]), Integer.parseInt(fontProp[2]));
            this.pref().setEntryBackColor(entryColor);
            this.setupGui(this.pref());
        }
        catch (Exception xcp) {
            MAppMsg msg = BpvMsgs.get("no_pref");
            this.logger().writeln(msg.format(Utility.xcpMsg(xcp)));
        }
    }

    private void checkVersion() {
        try {
            boolean avail = this.newVersionAvail(WEBSITEURL, VERSION);
            if (avail) {
                MAppMsg msg = BpmMsgs.get("update-available");
                StatusBox.singleton().showMsg(msg.format(), msg.isError());
            }
        }
        catch (Exception xcp) {
            MAppMsg msg = BpmMsgs.get("unable-read-version");
            this.logger().writeln(msg.format(Utility.xcpMsg(xcp)));
        }
    }

    private class StatusPanel
    extends ColorPanel {
        private PanelLabel iInfo = new PanelLabel();

        private StatusPanel() {
            this.iInfo.setHorizontalAlignment(0);
            this.setLayout(new GridLayout());
            this.add(this.iInfo);
            this.add(StatusBox.singleton());
        }

        private void setInfo(String info) {
            this.iInfo.setText(info);
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            System.exit(0);
        }
    }
}

