/*
 * Decompiled with CFR 0.152.
 */
package bpv;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import swing.CopyProtectMark;

public class LabelMark
implements CopyProtectMark,
Serializable {
    private String iText = "Copyrighted";
    private int iStroke = 3;
    private float iFontSize = 0.1f;
    private int iCount = 2;
    private double iX = 0.0;
    private double iY = 0.0;
    private static final int BOUNDARYSPACE = 5;
    private static final double BASELINEOFFSET = 0.8;
    private static final int MINFONTSIZE = 12;
    private static final Font BASEFONT = new Font("Dialog", 1, 18);
    static final long serialVersionUID = 1994712298439622605L;

    public static LabelMark parse(Element markEle) throws Exception {
        LabelMark mark = new LabelMark();
        Element label = (Element)markEle.getFirstChild();
        Text text = (Text)label.getFirstChild();
        mark.iText = text.getData().trim();
        Element stroke = (Element)label.getNextSibling();
        text = (Text)stroke.getFirstChild();
        mark.iStroke = Integer.parseInt(text.getData().trim());
        Element fontSize = (Element)stroke.getNextSibling();
        text = (Text)fontSize.getFirstChild();
        mark.iFontSize = Float.parseFloat(text.getData().trim());
        Element count = (Element)fontSize.getNextSibling();
        text = (Text)count.getFirstChild();
        mark.iCount = Integer.parseInt(text.getData().trim());
        Element xPos = (Element)count.getNextSibling();
        text = (Text)xPos.getFirstChild();
        mark.iX = Double.parseDouble(text.getData().trim());
        Element yPos = (Element)xPos.getNextSibling();
        text = (Text)yPos.getFirstChild();
        mark.iY = Double.parseDouble(text.getData().trim());
        return mark;
    }

    public static LabelMark defaultMark() {
        return new LabelMark();
    }

    private LabelMark() {
    }

    @Override
    public void draw(Graphics2D g2, JPanel panel) {
        g2.setStroke(new BasicStroke(this.iStroke));
        float fontSize = (float)panel.getSize().height * this.iFontSize;
        if (fontSize < 12.0f) {
            fontSize = 12.0f;
        }
        Font font = BASEFONT.deriveFont(fontSize);
        g2.setFont(font);
        FontRenderContext context = g2.getFontRenderContext();
        Rectangle2D bounds = font.getStringBounds(this.iText, context);
        Rectangle2D.Double boundary = new Rectangle2D.Double(0.0, 0.0, bounds.getWidth() + 10.0, bounds.getHeight());
        double x = (double)panel.getSize().width * this.iX;
        double y = (double)panel.getSize().height * this.iY;
        float offset = 0.0f;
        if (this.iCount > 1) {
            offset = fontSize * 0.15f;
        }
        if (this.iX <= 0.0 || this.iY <= 0.0) {
            x = ((double)panel.getSize().width - ((RectangularShape)boundary).getWidth()) * 0.5;
            x -= (double)offset * 0.5;
            y = ((double)panel.getSize().height - ((RectangularShape)boundary).getHeight()) * 0.5;
            y -= (double)offset * 0.5;
        }
        ((Rectangle2D)boundary).setRect(x, y, ((RectangularShape)boundary).getWidth(), ((RectangularShape)boundary).getHeight());
        g2.draw(boundary);
        double baseline = y + bounds.getHeight() * 0.8;
        g2.drawString(this.iText, (int)(x += 5.0), (int)baseline);
        if (this.iCount > 1) {
            g2.setPaint(Color.black);
            g2.drawString(this.iText, (int)(x + (double)offset), (int)(baseline + (double)offset));
        }
    }
}

