/*
 * Decompiled with CFR 0.152.
 */
package bpv;

import bpv.BpvMsgs;
import bpv.Main;
import java.awt.Image;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import mlib.MAppMsg;
import oroma.db.PicInfo;
import oroma.website.WebImg;
import swing.StatusBox;

public class ImageLoader
extends Thread {
    private WebImg iWebImg = null;
    private Image iImage = null;
    private boolean iThumb = false;

    public ImageLoader(WebImg webImg, boolean isThumb) {
        this.iWebImg = webImg;
        this.iThumb = isThumb;
        this.setPriority(1);
    }

    @Override
    public void run() {
        PicInfo picInfo = this.iWebImg.picInfo();
        String fileName = picInfo.id() + ".jpg";
        if (this.iThumb) {
            fileName = this.iWebImg.thumbFilename();
        }
        String urlStr = "";
        InputStream stream = null;
        try {
            try {
                urlStr = String.valueOf(Main.singleton().baseUrl()) + this.iWebImg.serverFolder() + '/' + fileName;
                URL url = new URL(urlStr);
                URLConnection connect = url.openConnection(Proxy.NO_PROXY);
                stream = connect.getInputStream();
                this.iImage = ImageIO.read(stream);
            }
            catch (Exception xcp) {
                MAppMsg msg = BpvMsgs.get("unable_load_photo");
                StatusBox.singleton().queueShowMsg(msg.format(xcp), msg.isError());
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public Image image() {
        return this.iImage;
    }

    public WebImg webImg() {
        return this.iWebImg;
    }
}

